/*
 * #%L
 * JAXX :: Widgets
 * $Id: DateCellRenderer.java 2455 2012-07-30 18:47:43Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.14/jaxx-widgets/src/main/java/jaxx/runtime/swing/renderer/DateCellRenderer.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.renderer;

import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class DateCellRenderer implements TableCellRenderer {

    protected TableCellRenderer delegate;
    protected SimpleDateFormat dateFormat;

    public DateCellRenderer(TableCellRenderer renderer, String datePattern) {
        this.delegate = renderer;
        dateFormat = new SimpleDateFormat();
        if (datePattern != null) {
            dateFormat.applyPattern(datePattern);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel render = (JLabel) delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Date date = (Date) value;
        String formatedDate = StringUtils.EMPTY;
        if (date != null) {
            formatedDate = dateFormat.format(date);
        }
        render.setText(formatedDate);
        return render;

    }
}
