/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class ListSelectorUI<B> extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_TO_COMBO_TIP = "addToComboTip";
    public static final String PROPERTY_ADD_TO_LIST_TIP = "addToListTip";
    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_RENDERER = "renderer";
    public static final String PROPERTY_SHOW_HIDOR = "showHidor";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ENABLED = "add.enabled";
    public static final String BINDING_ADD_TOOL_TIP_TEXT = "add.toolTipText";
    public static final String BINDING_COMBO_ENABLED = "combo.enabled";
    public static final String BINDING_COMBO_RENDERER = "combo.renderer";
    public static final String BINDING_HIDOR_ENABLED = "hidor.enabled";
    public static final String BINDING_HIDOR_VISIBLE = "hidor.visible";
    public static final String BINDING_LIST_CELL_RENDERER = "list.cellRenderer";
    public static final String BINDING_LIST_ENABLED = "list.enabled";
    public static final String BINDING_REMOVE_ENABLED = "remove.enabled";
    public static final String BINDING_REMOVE_TOOL_TIP_TEXT = "remove.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JPANEL1_MINIMUM_SIZE = "$JPanel1.minimumSize";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVWz28TRxSemNiJ84MGAjRVQxtKi4RabEDcgvjhlChE5oewi1DNgfHOJB40O7PMziZLD6i3XvsntPdeKvXWU9VDzz1wQfwLVdVDr1Xf2117venirFg1hziZ971vvvdmvjf+4Q9S9Q0585SGYcMEygqXN7ZvPnp0r/+UO/Zz7jtGeFYbEv9MVUilR+bZaN235GyvjenNJL25oV1PK67GstfbZM63zyX3B5xbS05nMxzfb3ZG4fXQC8yQdSQqj/W7v/6sfMu+/r5CSOiBuiUoZe2wrLSS6TapCGbJcdhpjzYlVbsgwwi1C3oXcW1DUt+/S13+jLwgM21S86gBMks+Kl5yxBHlh54lsx9v36eKy4v2QNP9fdi30Ra+7XAJrdfmi9ueFyXWLKn7A72/JZg2lhxDZQ1U22hpLTlVKW7W1UzsCM7w/6Pp+gJlrKuRvQvqyFJKERecIhcjJBTU1wDFxeUxeqieccNBxSpShGOyN7iUD5JwmjEzoIpJTDh3SLlbMXBsMwlRbJYl745vtt1xjJYSI4ispwlJby/BkWYSolUErY6w00ie9HKEQzkY/3AEqw04Zah+JUd9l/blAQlVBxtnyckMb9TNlg4R9EnaGupYoRU46EQG3YVDbVGTBR+BY7FkOQNsBdZqhYBPU8GGu3ovUnUxG6kO4uvzQU4l0c3K0BnyfgYHFm2kFk09NNUjVRPAMrSo919XP4BQ7OeVA35Gwij6z6nllz+//mlzaOIV2PtkLnRsBoG5PKM9OBmBW78TOziwQjbvUG+9B4ZJrhVEV3OEDW8diIP9YkthemOL+gOgqM68+uXXU09+P0Iqm2ROaso2KeJvk7odGOiCliz0rt+IFC3sz+L0QW1wApI+19BKcvQqo5au9YVi0ONrITRhNacJIyX9+m9/L3d+vDFsxBQIe++N8LQZ1S9JTSgpFI/mWTKqcufXvOfzgOl0JOUNqSn8nPMSI65Hv6/nVbrkaBm4aiuyyEPB9xHZCgP82IgKwL9uRXynD+XD5ZsTGNYKKJp3hRJu4HbEV7wk1YIzNs8mcJ0twDXDFY4KVpKmvqOVveBDbTDgrsZHvkYtDPB+YPm1tyeuwqsRD8i3VofLjycwnC/EsFuKYex9KslT3wHH2+F47+cTfVaAaFo48Uh9g5hm6cYezgC2sPCkwGve5aEtLebFBIbLpcspxvDN/6rhShFLw2vKky9IZWjwe115mpqlZpdPOtsiLIsxy0Phi+Tml6lsrxDNv1IuFZOBDAAA";
    private static final Log log = LogFactory.getLog(ListSelectorUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToolBar actions;
    protected JButton add;
    protected String addToComboTip;
    protected String addToListTip;
    protected JComboBox combo;
    protected ListSelectorHandler<B> handler;
    protected Table header;
    protected HidorButton hidor;
    protected JList list;
    protected JScrollPane listPane;
    protected Boolean modified;
    protected JButton remove;
    protected ListCellRenderer renderer;
    protected Boolean showHidor;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ListSelectorUI<B> $JPanel0 = this;
    private JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(ListSelectorHandler<B> handler) {
        this.handler = handler;
    }
    
    /**
     * @return the datas from the combo box.
     */
    public List<B> getComboDatas() {
        return handler.getComboDatas();
    }
    
    /**
     * @return the data for the list.
     */
    public List<B> getListDatas() {
        return handler.getListDatas();
    }
    
    /**
     * Initialize the component.
     *
     * @param toCombo datas to set in combo
     * @param toList  datas to set in list
     */
    public void init(List<B> toCombo, List<B> toList) {
         handler.init(toCombo, toList);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ListSelectorUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ListSelectorUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ListSelectorUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ListSelectorUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ListSelectorUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ListSelectorUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ListSelectorUI() {
        $initialize();
    }

    public ListSelectorUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__add(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.transfertToList((B) combo.getSelectedItem());
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.transfertToCombo((B[]) list.getSelectedValues());
    }

    public void doMouseClicked__on__list(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (event.getClickCount()==2) { handler.transfertToCombo((B[]) list.getSelectedValues()); }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JToolBar getActions() {
        return actions;
    }

    public JButton getAdd() {
        return add;
    }

    public String getAddToComboTip() {
        return addToComboTip;
    }

    public String getAddToListTip() {
        return addToListTip;
    }

    public JComboBox getCombo() {
        return combo;
    }

    public ListSelectorHandler<B> getHandler() {
        return handler;
    }

    public Table getHeader() {
        return header;
    }

    public HidorButton getHidor() {
        return hidor;
    }

    public JList getList() {
        return list;
    }

    public JScrollPane getListPane() {
        return listPane;
    }

    public Boolean getModified() {
        return modified;
    }

    public JButton getRemove() {
        return remove;
    }

    public ListCellRenderer getRenderer() {
        return renderer;
    }

    public Boolean getShowHidor() {
        return showHidor;
    }

    public Boolean isModified() {
        return modified !=null && modified;
    }

    public Boolean isShowHidor() {
        return showHidor !=null && showHidor;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAddToComboTip(String addToComboTip) {
        String oldValue = this.addToComboTip;
        this.addToComboTip = addToComboTip;
        firePropertyChange(PROPERTY_ADD_TO_COMBO_TIP, oldValue, addToComboTip);
    }

    public void setAddToListTip(String addToListTip) {
        String oldValue = this.addToListTip;
        this.addToListTip = addToListTip;
        firePropertyChange(PROPERTY_ADD_TO_LIST_TIP, oldValue, addToListTip);
    }

    public void setModified(Boolean modified) {
        Boolean oldValue = this.modified;
        this.modified = modified;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, modified);
    }

    public void setRenderer(ListCellRenderer renderer) {
        ListCellRenderer oldValue = this.renderer;
        this.renderer = renderer;
        firePropertyChange(PROPERTY_RENDERER, oldValue, renderer);
    }

    public void setShowHidor(Boolean showHidor) {
        Boolean oldValue = this.showHidor;
        this.showHidor = showHidor;
        firePropertyChange(PROPERTY_SHOW_HIDOR, oldValue, showHidor);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActions() {
        if (!allComponentsCreated) {
            return;
        }
        actions.add(add);
        actions.add(remove);
        actions.add(hidor);
    }

    protected void addChildrenToHeader() {
        if (!allComponentsCreated) {
            return;
        }
        header.add(combo, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        header.add(actions, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToListPane() {
        if (!allComponentsCreated) {
            return;
        }
        listPane.getViewport().add($JPanel1);
    }

    protected void createActions() {
        $objectMap.put("actions", actions = new JToolBar());
        
        actions.setName("actions");
        actions.setFloatable(false);
    }

    protected void createAdd() {
        $objectMap.put("add", add = new JButton());
        
        add.setName("add");
        add.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__add"));
    }

    protected void createAddToComboTip() {
        $objectMap.put("addToComboTip", addToComboTip = "-");
    }

    protected void createAddToListTip() {
        $objectMap.put("addToListTip", addToListTip = "+");
    }

    protected void createCombo() {
        $objectMap.put("combo", combo = new JComboBox());
        
        combo.setName("combo");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new ListSelectorHandler<B>(this));
    }

    protected void createHeader() {
        $objectMap.put("header", header = new Table());
        
        header.setName("header");
    }

    protected void createHidor() {
        $objectMap.put("hidor", hidor = new HidorButton());
        
        hidor.setName("hidor");
    }

    protected void createList() {
        $objectMap.put("list", list = new JList());
        
        list.setName("list");
        if (list.getFont() != null) {
            list.setFont(list.getFont().deriveFont((float) 11));
        }
        list.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__list"));
    }

    protected void createListPane() {
        $objectMap.put("listPane", listPane = new JScrollPane());
        
        listPane.setName("listPane");
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createRenderer() {
        $objectMap.put("renderer", renderer = null);
    }

    protected void createShowHidor() {
        $objectMap.put("showHidor", showHidor = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(listPane, BorderLayout.CENTER);
        add(header, BorderLayout.SOUTH);
        addChildrenToListPane();
        // inline complete setup of $JPanel1
        $JPanel1.add(list, BorderLayout.CENTER);
        addChildrenToHeader();
        addChildrenToActions();
        
        // apply 11 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 11 property setters
        listPane.setColumnHeaderView(header);
        list.setModel(new DefaultListModel());
        combo.setModel(new DefaultComboBoxModel());
        add.setIcon(SwingUtil.createActionIcon("add"));
        remove.setIcon(SwingUtil.createActionIcon("remove"));
        hidor.setHideTip(_("listSelector.hideList"));
        hidor.setShowTip(_("listSelector.showList"));
        hidor.setTarget(list);
        hidor.setTargetVisible(true);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createShowHidor();
        createModified();
        createAddToListTip();
        createAddToComboTip();
        createRenderer();
        createHandler();
        createListPane();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createList();
        createHeader();
        createCombo();
        createActions();
        createAdd();
        createRemove();
        createHidor();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 11 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 11 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JPANEL1_MINIMUM_SIZE, true ,"minimumSize") {
        
            @Override
            public void processDataBinding() {
                $JPanel1.setMinimumSize(getMinimumSize());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LIST_CELL_RENDERER, true ,"renderer") {
        
            @Override
            public void processDataBinding() {
                list.setCellRenderer(getRenderer());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LIST_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                list.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBO_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                combo.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBO_RENDERER, true ,"renderer") {
        
            @Override
            public void processDataBinding() {
                combo.setRenderer(getRenderer());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (combo != null) {
                    combo.addPropertyChangeListener("enabled", this);
                }
                if (combo != null) {
                    $bindingSources.put("combo", combo);
                    combo.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (combo != null) {
                    add.setEnabled(handler.updateAddEnabled(combo.isEnabled() && combo.getSelectedIndex() > -1));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (combo != null) {
                    combo.removePropertyChangeListener("enabled", this);
                }
                if (combo != null) {
                    JComboBox $target = (JComboBox) $bindingSources.remove("combo");
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                    }
                }
            }
        
            public void $pr$u0(ItemEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_TOOL_TIP_TEXT, true ,"addToListTip") {
        
            @Override
            public void processDataBinding() {
                add.setToolTipText(_(getAddToListTip()));
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (list != null) {
                    list.addPropertyChangeListener("enabled", this);
                }
                if (list != null) {
                    $bindingSources.put("list.getSelectionModel()", list.getSelectionModel());
                    list.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    list.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(jaxx.runtime.swing.ListSelectorUI.this, BINDING_REMOVE_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (list != null) {
                    remove.setEnabled(handler.updateRemoveEnabled(list.isEnabled() && list.getSelectedIndex() > -1));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (list != null) {
                    list.removePropertyChangeListener("enabled", this);
                }
                if (list != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("list.getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    }
                    list.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(jaxx.runtime.swing.ListSelectorUI.this, BINDING_REMOVE_ENABLED));
                }
            }
        
            public void $pr$u1(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_TOOL_TIP_TEXT, true ,"addToComboTip") {
        
            @Override
            public void processDataBinding() {
                remove.setToolTipText(_(getAddToComboTip()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HIDOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                hidor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HIDOR_VISIBLE, true ,"showHidor") {
        
            @Override
            public void processDataBinding() {
                hidor.setVisible(isShowHidor());
            }
        });
    }

}