/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing;

import java.awt.*;
import java.awt.event.*;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class MemoryStatusWidget extends javax.swing.JComponent implements java.awt.event.ActionListener, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_PROGRESS_BACKGROUND = "progressBackground";
    public static final String PROPERTY_PROGRESS_FOREGROUND = "progressForeground";
    public static final String PROPERTY_TIMER = "timer";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TPW8TQRAdH9jBTvhILKwgAgohiajOUBtBIMgikQMSRiLCDWvfYm843y27c/hCgfgJ/AToaZDoqBAFNQUN4i8gREGLmF07dzY5CFfsnnbezLyZefP6G+S1gnM7LI5dFQUo+tzdvLa9fbu9wzt4g+uOEhJDBcMv54DTgmkvedcI51sN414duVfXw74MAx6MedcaUNK463Pd4xwRzkx6dLSuNhNzLZaR2ouakMqK+vLHd+eF9/yVAxBLYlegUhYP8korOdwAR3gIc5TpCav6LOgSDSWCLvE9at7Wfab1Ldbnj+EZTDWgIJmiYAhL/1+yjWH9Y4kws7yZgC8irEyw1QPK7W7xfqh2m8gw0veE1+UopQ1QQMgbnEKYNezikcNd85Zi5qQKu4prfZ11HnVVGAVU4zHj4LIBUkv8MAtdDxUfoo1lNkWUl5u2po1AoGC+eMoVMV+1zDtUi/C5codlu/uQ/wxzyZgqBFFweqIRJAg3FUQ6sVwL8iqiZ4T51n4N3SHTUD3zf6jHBLTWX5Xy53df39b3JONQ7pOZ0DHF0yipS5IaL0zq40O9RCj86haTtRYUNfdpXew6LGQQa47MRI7y2eG5xt29yXSPQuSnvrz/UHnw6RA4dSj5IfPqzOA3oIg9Gk4v9L1YXl2zjGYGR+g8YbghlNrjQ77sMWSLbRF4pIsrMTViIaMRCZt28ePPcvPN2l4zckTu1F/haUPy96EgAl8E3G7QaDkyN2Zaah55YboEWWuRM3dJjrRy1p5LmdU+nBDpShyZa9VSN38Xkki/AbR9wrLZBAAA";
    private static final Log log = LogFactory.getLog(jaxx.runtime.swing.MemoryStatusWidget.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.awt.Color progressBackground;
    protected java.awt.Color progressForeground;
    protected javax.swing.Timer timer;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MemoryStatusWidget $JComponent0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private final static String memoryTestStr = "99999/99999Mb";
    private FontRenderContext frc;
    private LineMetrics lm;
    
    
    @Override
    public void actionPerformed(ActionEvent evt) {
        repaint();
    }
    
    /** Adds a feature to the Notify attribute of the MemoryStatus object */
    @Override
    public void addNotify() {
        super.addNotify();
        setTimer(new javax.swing.Timer(2000, this));
        timer.start();
    }
    
    @Override
    public void removeNotify() {
        if (timer != null) {
            timer.stop();
            timer = null;
        }
        super.removeNotify();
    }
    
    @Override
    public void paintComponent(Graphics g) {
        Insets insets = new Insets(0, 0, 0, 0);
        Runtime runtime = Runtime.getRuntime();
        int freeMemory = (int) (runtime.freeMemory() / 1024L);
        int totalMemory = (int) (runtime.totalMemory() / 1024L);
        int usedMemory = totalMemory - freeMemory;
        int width = getWidth() - insets.left - insets.right;
        int height = getHeight() - insets.top - insets.bottom - 1;
        float fraction = (float) usedMemory / (float) totalMemory;
        g.setColor(progressBackground);
        g.fillRect(insets.left, insets.top, (int) ((float) width * fraction), height);
        // No i18n string was :
        // String str = usedMemory / 1024 + "/" + totalMemory / 1024 + "Mb";
        String str = _("memorywidget.memory", usedMemory / 1024, totalMemory / 1024);
        //FontRenderContext frc = new FontRenderContext(null, false, false);
        Rectangle2D bounds = g.getFont().getStringBounds(str, frc);
        Graphics g2 = g.create();
        g2.setClip(insets.left, insets.top,
                (int) ((float) width * fraction), height);
        g2.setColor(progressForeground);
        g2.drawString(str, insets.left
                + (int) ((double) width - bounds.getWidth()) / 2,
                (int) ((float) insets.top + lm.getAscent()));
        g2.dispose();
        g2 = g.create();
        g2.setClip(insets.left + (int) ((float) width * fraction),
                insets.top, getWidth() - insets.left
                        - (int) ((float) width * fraction), height);
        g2.setColor(getForeground());
        g2.drawString(str, insets.left
                + (int) ((double) width - bounds.getWidth()) / 2,
                (int) ((float) insets.top + lm.getAscent()));
        g2.dispose();
    }
    
    
    void $afterCompleteSetup() {
        setFont(new JLabel().getFont());
        Rectangle2D bounds = getFont().getStringBounds(memoryTestStr, frc);
        Dimension dim = new Dimension((int) bounds.getWidth(), (int) bounds .getHeight());
        setPreferredSize(dim);
        setMaximumSize(dim);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MemoryStatusWidget() {
        $initialize();
    }

    public MemoryStatusWidget(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.awt.Color getProgressBackground() {
        return progressBackground;
    }

    public java.awt.Color getProgressForeground() {
        return progressForeground;
    }

    public javax.swing.Timer getTimer() {
        return timer;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setProgressBackground(java.awt.Color newValue) {
        java.awt.Color oldValue = this.progressBackground;
        this.progressBackground = newValue;
        firePropertyChange(PROPERTY_PROGRESS_BACKGROUND, oldValue, newValue);
    }

    public void setProgressForeground(java.awt.Color newValue) {
        java.awt.Color oldValue = this.progressForeground;
        this.progressForeground = newValue;
        firePropertyChange(PROPERTY_PROGRESS_FOREGROUND, oldValue, newValue);
    }

    public void setTimer(javax.swing.Timer newValue) {
        javax.swing.Timer oldValue = this.timer;
        this.timer = newValue;
        firePropertyChange(PROPERTY_TIMER, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createProgressBackground() {
        $objectMap.put("progressBackground", progressBackground = Color.decode("#666699a"));
    }

    protected void createProgressForeground() {
        $objectMap.put("progressForeground", progressForeground = Color.decode("#cccccc"));
    }

    protected void createTimer() {
        $objectMap.put("timer", timer = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        // apply 2 property setters
        setBackground(Color.WHITE);
        setForeground(Color.BLACK);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JComponent0", this);
        createTimer();
        createProgressBackground();
        createProgressForeground();
        frc = new FontRenderContext(null, false, false);
        lm = new JLabel().getFont().getLineMetrics(memoryTestStr, frc);
        // inline creation of $JComponent0
        setName("$JComponent0");
        
        $completeSetup();
    }

}