/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing;

import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class ListSelectorUI<B> extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_TO_COMBO_TIP = "addToComboTip";
    public static final String PROPERTY_ADD_TO_LIST_TIP = "addToListTip";
    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_RENDERER = "renderer";
    public static final String PROPERTY_SHOW_HIDOR = "showHidor";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ENABLED = "add.enabled";
    public static final String BINDING_ADD_TOOL_TIP_TEXT = "add.toolTipText";
    public static final String BINDING_COMBO_ENABLED = "combo.enabled";
    public static final String BINDING_COMBO_RENDERER = "combo.renderer";
    public static final String BINDING_HIDOR_ENABLED = "hidor.enabled";
    public static final String BINDING_HIDOR_VISIBLE = "hidor.visible";
    public static final String BINDING_LIST_CELL_RENDERER = "list.cellRenderer";
    public static final String BINDING_LIST_ENABLED = "list.enabled";
    public static final String BINDING_REMOVE_ENABLED = "remove.enabled";
    public static final String BINDING_REMOVE_TOOL_TIP_TEXT = "remove.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JPANEL1_MINIMUM_SIZE = "$JPanel1.minimumSize";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVWy27TQBSdpk3a9EELpVCgoPAQAokmdIfUqpQUVW0VHmoCArKAiT1tphp7zHjcGpAQCz6AT4A9GyR2rBAL1izYIH4BIRZsEXdsJ46Lm1q1yMJJ5p575tw7Ptd++wNlbYFOb2LXLQrHlNQgxdVr9+7damwSTV4ntiaoJblA/qcngzJ1NKS3122JztYrKr0UpJcWuWFxk5gd2bMVNGjLJ4zYTUKkRCejGZptl6rt8KxrOaLF2hYVx/r618/MK/3FmwxCrgXqRqGUwl5ZYSV9FZShukSHYKctXGLY3AAZgpoboHdErS0ybNs3sUEeo+eov4JyFhZAJtGZ5CV7HF6+a0k0cG71NjYJuyx3NN3ehn2LFWrLKmHQei7urFiWl5iTKG83+fYy1bmQ6KBSVlRqi2XOGcFmiBswuE7XKdHV/wPh+jDW9RpX7DVQh8ZCCr/gEDniIaGgBgeoWhzvoIfqdSIIqJhSFG6H7EXC2FoQ7shgEFIVS3S0M2O1qgnOmIooZD5MCBo0A+cSSfBWFehYG9unyIOGtHFKi4pPtWG5JsG60jwZ0/EabrAdErKaql6iiQiv15IydxXoTBvbjzVJuQk2OBxB1+BkylhEwb3QW4nGI8CyIyU3FeBCKFgQg295qqajkWzTvwdOxVTi3R4ROoFORHDgs2Los9AIPXWUFQ4sQ4vq/1pzDUK+KSd3mFIRetE/R8a/fvj+fqnlxEnYeyIW2jFIwCGW4BacDFVbj/o2dCRlpRvYmq3DXR9YAaJTMcJaTgFxsJ/vC5VeXMZ2Eyiy/d8+fjry6EsvyiyhQcaxvoQVfgXlZVNAFzjTXevqgqdoeHsArmNKG5wAw084tBIdmNOxxIUGNXXo8bwLTZiKaUJbSSP/+fd49d1CqxE9IOzYrvCwGdkHKEdNRk3iDaVg3sQOoSHLJo7Ow7kSN2l61PegFRjxinedi6t0TOPMMcxlzyJ3KdlWyKuuo74WvALUr7LHd3xPPrU834XhZAJFQwY1qeEYVfqUpKQa1jqGUheuQgKufmKqUaGnpMmvc1NO21AbDLg5/8gLWMIUbjiSzO+fOAuj3x+Q+1anlu93YTifiKFbh/Zm6HjIpOTJr4PjZWu8P4wnupiAqI9q/kjdRcyl1I3dmwFsIeGRAo/kGnFlajHPujCUUpeTjOHlf9Uwk8TS8DQlwVtOGhr1cpaeJiex2CDdzjYJy4jPcpfaNLjz01S2lYjmL741qUZGDAAA";
    protected static final Log log = LogFactory.getLog(jaxx.runtime.swing.ListSelectorUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JToolBar actions;
    protected javax.swing.JButton add;
    protected java.lang.String addToComboTip;
    protected java.lang.String addToListTip;
    protected javax.swing.JComboBox combo;
    protected jaxx.runtime.swing.Table header;
    protected jaxx.runtime.swing.HidorButton hidor;
    protected javax.swing.JList list;
    protected javax.swing.JScrollPane listPane;
    protected java.lang.Boolean modified;
    protected javax.swing.JButton remove;
    protected javax.swing.ListCellRenderer renderer;
    protected java.lang.Boolean showHidor;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ListSelectorUI $JPanel0 = this;
    private javax.swing.JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    /**
     * @return the datas from the combo box.
     */
    public java.util.List<B> getComboDatas() {
        java.util.List<B> datas = new java.util.ArrayList<B>();
        ComboBoxModel comboModel = combo.getModel();
        for (int i = 0, j = comboModel.getSize(); i < j; i++) {
            B g = (B) comboModel.getElementAt(i);
            datas.add(g);
        }
        return datas;
    }
    
    /**
     * @return the data for the list.
     */
    public java.util.List<B> getListDatas() {
        java.util.List<B> datas = new java.util.ArrayList<B>();
        ListModel listModel = list.getModel();
        for (int i = 0, j = listModel.getSize(); i < j; i++) {
            B g = (B) listModel.getElementAt(i);
            datas.add(g);
        }
        return datas;
    }
    
    /**
     * Initialize the component.
     *
     * @param toCombo datas to set in combo
     * @param toList  datas to set in list
     */
    public void init(java.util.List<B> toCombo, java.util.List<B> toList) {
        setComboDatas(toCombo);
        setListDatas(toList);
        // after init, always unmodified editor
        // TODO should avoid to fire a changed ?
        setModified(false);
    }
    
    /**
     * Transfert the {@code b} data from combo box to list.
     *
     * @param b the data to transfert
     */
    protected void transfertToList(B b) {
        ((DefaultListModel) list.getModel()).addElement(b);
        ((DefaultComboBoxModel) combo.getModel()).removeElement(b);
        setModified(true);
    }
    
    /**
     * Transfert the {@code b} data from list to combo box.
     *
     * @param bs the data to transfert
     */
    protected void transfertToCombo(B[] bs) {
        for (B b : bs) {
            ((DefaultListModel) list.getModel()).removeElement(b);
            ((DefaultComboBoxModel) combo.getModel()).addElement(b);
        }
        setModified(true);
    }
    
    /**
     * @param enabled databinding
     * @return {@code true} if add button should be enabled
     */
    protected boolean updateAddEnabled(boolean enabled) {
        return enabled && combo.getModel().getSize() > 0;
    }
    
    /**
     * @param enabled databinding
     * @return {@code true} if remove button should be enabled
     */
    protected boolean updateRemoveEnabled(boolean enabled) {
        return enabled && list.getModel().getSize() > 0;
    }
    
    /**
     * Set the data in combo box model.
     *
     * @param toCombo datas to set in combo box model
     */
    protected void setComboDatas(java.util.List<B> toCombo) {
        SwingUtil.fillComboBox(combo, toCombo, null);
        //Note : there is a case when combo was selected, then come here with an empty
        // combo model : no propertyChanged is fired, so add button stays enabled...
        processDataBinding("add.enabled");
    }
    
    /**
     * Set the data in the list model.
     *
     * @param toList datas to set in list model
     */
    protected void setListDatas(java.util.List<B> toList) {
        SwingUtil.fillList(list, toList, null);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ListSelectorUI() {
        $initialize();
    }

    public ListSelectorUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__add(java.awt.event.ActionEvent event) {
        transfertToList((B) combo.getSelectedItem());
    }

    public void doActionPerformed__on__remove(java.awt.event.ActionEvent event) {
        transfertToCombo((B[]) list.getSelectedValues());
    }

    public void doMouseClicked__on__list(java.awt.event.MouseEvent event) {
        if (event.getClickCount()==2) { transfertToCombo((B[]) list.getSelectedValues()); };
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JToolBar getActions() {
        return actions;
    }

    public javax.swing.JButton getAdd() {
        return add;
    }

    public java.lang.String getAddToComboTip() {
        return addToComboTip;
    }

    public java.lang.String getAddToListTip() {
        return addToListTip;
    }

    public javax.swing.JComboBox getCombo() {
        return combo;
    }

    public jaxx.runtime.swing.Table getHeader() {
        return header;
    }

    public jaxx.runtime.swing.HidorButton getHidor() {
        return hidor;
    }

    public javax.swing.JList getList() {
        return list;
    }

    public javax.swing.JScrollPane getListPane() {
        return listPane;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public javax.swing.ListCellRenderer getRenderer() {
        return renderer;
    }

    public java.lang.Boolean getShowHidor() {
        return showHidor;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    public java.lang.Boolean isShowHidor() {
        return showHidor !=null && showHidor;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAddToComboTip(java.lang.String newValue) {
        java.lang.String oldValue = this.addToComboTip;
        this.addToComboTip = newValue;
        firePropertyChange(PROPERTY_ADD_TO_COMBO_TIP, oldValue, newValue);
    }

    public void setAddToListTip(java.lang.String newValue) {
        java.lang.String oldValue = this.addToListTip;
        this.addToListTip = newValue;
        firePropertyChange(PROPERTY_ADD_TO_LIST_TIP, oldValue, newValue);
    }

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, newValue);
    }

    public void setRenderer(javax.swing.ListCellRenderer newValue) {
        javax.swing.ListCellRenderer oldValue = this.renderer;
        this.renderer = newValue;
        firePropertyChange(PROPERTY_RENDERER, oldValue, newValue);
    }

    public void setShowHidor(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showHidor;
        this.showHidor = newValue;
        firePropertyChange(PROPERTY_SHOW_HIDOR, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActions() {
        if (!allComponentsCreated) {
            return;
        }
        actions.add(add);
        actions.add(remove);
        actions.add(hidor);
    }

    protected void addChildrenToHeader() {
        if (!allComponentsCreated) {
            return;
        }
        header.add(combo, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        header.add(actions, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToListPane() {
        if (!allComponentsCreated) {
            return;
        }
        listPane.getViewport().add($JPanel1);
    }

    protected void createActions() {
        $objectMap.put("actions", actions = new javax.swing.JToolBar());
        actions.setName("actions");
        actions.setFloatable(false);
    }

    protected void createAdd() {
        $objectMap.put("add", add = new javax.swing.JButton());
        add.setName("add");
        add.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__add"));
    }

    protected void createAddToComboTip() {
        $objectMap.put("addToComboTip", addToComboTip = "-");
    }

    protected void createAddToListTip() {
        $objectMap.put("addToListTip", addToListTip = "+");
    }

    protected void createCombo() {
        $objectMap.put("combo", combo = new javax.swing.JComboBox());
        combo.setName("combo");
    }

    protected void createHeader() {
        $objectMap.put("header", header = new jaxx.runtime.swing.Table());
        header.setName("header");
    }

    protected void createHidor() {
        $objectMap.put("hidor", hidor = new jaxx.runtime.swing.HidorButton());
        hidor.setName("hidor");
    }

    protected void createList() {
        $objectMap.put("list", list = new javax.swing.JList());
        list.setName("list");
        if (list.getFont() != null) {
            list.setFont(list.getFont().deriveFont((float) 11));
        }
        list.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__list"));
    }

    protected void createListPane() {
        $objectMap.put("listPane", listPane = new javax.swing.JScrollPane());
        listPane.setName("listPane");
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new javax.swing.JButton());
        remove.setName("remove");
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createRenderer() {
        $objectMap.put("renderer", renderer = null);
    }

    protected void createShowHidor() {
        $objectMap.put("showHidor", showHidor = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add(listPane, BorderLayout.CENTER);
        add(header, BorderLayout.SOUTH);
        addChildrenToListPane();
        // inline complete setup of $JPanel1
        $JPanel1.add(list, BorderLayout.CENTER);
        addChildrenToHeader();
        addChildrenToActions();
        
        // apply 11 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 11 property setters
        listPane.setColumnHeaderView(header);
        list.setModel(new DefaultListModel());
        combo.setModel(new DefaultComboBoxModel());
        add.setIcon(jaxx.runtime.SwingUtil.createActionIcon("add"));
        remove.setIcon(jaxx.runtime.SwingUtil.createActionIcon("remove"));
        hidor.setHideTip(_("listSelector.hideList"));
        hidor.setShowTip(_("listSelector.showList"));
        hidor.setTarget(list);
        hidor.setTargetVisible(true);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 11 data bindings
        $registerDefaultBindings();
        $objectMap.put("$JPanel0", this);
        createShowHidor();
        createModified();
        createAddToListTip();
        createAddToComboTip();
        createRenderer();
        createListPane();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createList();
        createHeader();
        createCombo();
        createActions();
        createAdd();
        createRemove();
        createHidor();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        hidor.addPropertyChangeListener("targetVisible", new PropertyChangeListener() {
        
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug("target visible changed <" + evt.getOldValue() + ":" + evt.getNewValue() + ">");
                }
                if (!showHidor || !isEnabled()) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable() {
        
                    @Override
                    public void run() {
                        log.info("invalidate " + getParent().getName());
                        listPane.invalidate();
                    }
                });
            }
        });$completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 11 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JPANEL1_MINIMUM_SIZE, true ,"minimumSize") {
        
            @Override
            public void processDataBinding() {
                $JPanel1.setMinimumSize(getMinimumSize());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LIST_CELL_RENDERER, true ,"renderer") {
        
            @Override
            public void processDataBinding() {
                list.setCellRenderer(getRenderer());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LIST_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                list.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBO_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                combo.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBO_RENDERER, true ,"renderer") {
        
            @Override
            public void processDataBinding() {
                combo.setRenderer(getRenderer());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (combo != null) {
                    combo.addPropertyChangeListener("enabled", this);
                }
                if (combo != null) {
                    $bindingSources.put("combo", combo);
                    combo.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (combo != null) {
                    add.setEnabled(updateAddEnabled(combo.isEnabled() && combo.getSelectedIndex() > -1));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (combo != null) {
                    combo.removePropertyChangeListener("enabled", this);
                }
                if (combo != null) {
                    javax.swing.JComboBox $target = ((javax.swing.JComboBox) $bindingSources.remove("combo"));
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                    }
                }
            }
        
            public void $pr$u0(java.awt.event.ItemEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_TOOL_TIP_TEXT, true ,"addToListTip") {
        
            @Override
            public void processDataBinding() {
                add.setToolTipText(_(getAddToListTip()));
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (list != null) {
                    list.addPropertyChangeListener("enabled", this);
                }
                if (list != null) {
                    $bindingSources.put("list.getSelectionModel()", list.getSelectionModel());
                    list.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    list.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(jaxx.runtime.swing.ListSelectorUI.this, BINDING_REMOVE_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (list != null) {
                    remove.setEnabled(updateRemoveEnabled(list.isEnabled() && list.getSelectedIndex() > -1));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (list != null) {
                    list.removePropertyChangeListener("enabled", this);
                }
                if (list != null) {
                    javax.swing.ListSelectionModel $target = ((javax.swing.ListSelectionModel) $bindingSources.remove("list.getSelectionModel()"));
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    }
                    list.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(jaxx.runtime.swing.ListSelectorUI.this, BINDING_REMOVE_ENABLED));
                }
            }
        
            public void $pr$u1(javax.swing.event.ListSelectionEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_TOOL_TIP_TEXT, true ,"addToComboTip") {
        
            @Override
            public void processDataBinding() {
                remove.setToolTipText(_(getAddToComboTip()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HIDOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                hidor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HIDOR_VISIBLE, true ,"showHidor") {
        
            @Override
            public void processDataBinding() {
                hidor.setVisible(isShowHidor());
            }
        });
    }

}