/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.validator.swing.unified;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.validator.swing.SwingListValidator;
import org.nuiton.jaxx.validator.swing.SwingValidator;
import org.nuiton.jaxx.validator.swing.unified.UnifiedValidatorMessage;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.AbstractValidator;
import org.nuiton.validator.bean.list.BeanListValidator;
import org.nuiton.validator.bean.list.BeanListValidatorListener;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorListener;

public class UnifiedValidatorMessageTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(UnifiedValidatorMessageTableModel.class);
    public static final String[] columnNames = new String[]{"validator.scope", "validator.bean", "validator.field", "validator.message"};
    public static final Class<?>[] columnClasses = new Class[]{NuitonValidatorScope.class, Object.class, String.class, String.class};
    protected final List<AbstractValidator<?>> validators;
    protected final List<UnifiedValidatorMessage> data = Lists.newArrayList();
    protected transient BeanListValidatorListener listValidatorListener;
    protected transient SimpleBeanValidatorListener simpleValidatorListener;

    public UnifiedValidatorMessageTableModel() {
        this.validators = Lists.newArrayList();
    }

    public void registerValidator(SwingValidator<?> validator) {
        if (this.validators.contains(validator)) {
            throw new IllegalArgumentException("the validator " + validator + " is already registred in " + this);
        }
        this.validators.add((AbstractValidator<?>)validator);
        validator.addSimpleBeanValidatorListener(this.getSimpleValidatorListener());
    }

    public void registerValidator(BeanListValidator<?> validator) {
        Preconditions.checkState((!this.validators.contains(validator) ? 1 : 0) != 0, (Object)("Validator " + validator + " is already registred in " + this));
        this.validators.add((AbstractValidator<?>)validator);
        validator.addBeanListValidatorListener(this.getListValidatorListener());
    }

    public void clear() {
        int i = this.data.size();
        if (i > 0) {
            this.data.clear();
            this.fireTableRowsDeleted(0, i - 1);
        }
    }

    public void clearValidators() {
        for (AbstractValidator<?> v : this.validators) {
            if (v instanceof BeanListValidator) {
                ((BeanListValidator)v).removeBeanListValidatorListener(this.getListValidatorListener());
                continue;
            }
            if (!(v instanceof SwingValidator)) continue;
            ((SwingValidator)v).removeSimpleBeanValidatorListener(this.getSimpleValidatorListener());
        }
        this.validators.clear();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        SwingUtil.ensureColumnIndex((TableModel)this, (int)columnIndex);
        return columnClasses[columnIndex];
    }

    @Override
    public String getColumnName(int column) {
        SwingUtil.ensureColumnIndex((TableModel)this, (int)column);
        return columnNames[column];
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result;
        SwingUtil.ensureColumnIndex((TableModel)this, (int)columnIndex);
        SwingUtil.ensureRowIndex((TableModel)this, (int)rowIndex);
        UnifiedValidatorMessage message = this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                result = message.getScope();
                break;
            }
            case 1: {
                result = message.isSimpleValidator() ? "-" : message.getBean();
                break;
            }
            case 2: {
                result = message.getField();
                break;
            }
            case 3: {
                result = message.getMessage();
                break;
            }
            default: {
                throw new IllegalStateException("Can't come here");
            }
        }
        return result;
    }

    public UnifiedValidatorMessage getRow(int rowIndex) {
        SwingUtil.ensureRowIndex((TableModel)this, (int)rowIndex);
        return this.data.get(rowIndex);
    }

    protected void addMessages(SwingValidator<?> validator, String fieldName, NuitonValidatorScope scope, boolean sort, String ... messages) {
        JComponent editor = validator == null ? null : validator.getFieldRepresentation(fieldName);
        for (String error : messages) {
            UnifiedValidatorMessage row = new UnifiedValidatorMessage((AbstractValidator<?>)validator, null, fieldName, error, scope, editor);
            this.data.add(row);
            if (sort) continue;
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        }
        if (sort) {
            Collections.sort(this.data);
            this.fireTableDataChanged();
        }
    }

    protected void addMessages(BeanListValidator<?> validator, Object bean, String fieldName, NuitonValidatorScope scope, boolean sort, String ... messages) {
        JComponent editor = null;
        if (validator instanceof SwingListValidator) {
            editor = ((SwingListValidator)validator).getEditor();
        }
        for (String message : messages) {
            UnifiedValidatorMessage row = new UnifiedValidatorMessage((AbstractValidator<?>)validator, bean, fieldName, message, scope, editor);
            this.data.add(row);
            if (sort) continue;
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        }
        if (sort) {
            Collections.sort(this.data);
            this.fireTableDataChanged();
        }
    }

    protected void removeMessages(SwingValidator<?> validator, String fieldName, NuitonValidatorScope scope, boolean notify, String ... messages) {
        ArrayList<String> messagesToDel = new ArrayList<String>(Arrays.asList(messages));
        for (int i = this.getRowCount() - 1; i > -1; --i) {
            UnifiedValidatorMessage message = this.data.get(i);
            if (!((Object)validator).equals(message.getValidator()) || message.getScope() != scope || !message.getField().equals(fieldName) || !messagesToDel.contains(message.getMessage())) continue;
            this.data.remove(i);
            if (!notify) continue;
            this.fireTableRowsDeleted(i, i);
        }
    }

    protected void removeMessages(JComponent editor, String fieldName, NuitonValidatorScope scope, boolean notify) {
        for (int i = this.getRowCount() - 1; i > -1; --i) {
            UnifiedValidatorMessage message = this.data.get(i);
            if (!editor.equals(message.getEditor()) || scope != null && message.getScope() != scope || !message.getField().equals(fieldName)) continue;
            this.data.remove(i);
            if (!notify) continue;
            this.fireTableRowsDeleted(i, i);
        }
    }

    protected void removeMessages(BeanListValidator<?> validator, Object bean, String fieldName, NuitonValidatorScope scope, boolean notify, String ... messages) {
        ArrayList<String> messagesToDel = new ArrayList<String>(Arrays.asList(messages));
        for (int i = this.getRowCount() - 1; i > -1; --i) {
            UnifiedValidatorMessage message = this.data.get(i);
            if (!validator.equals(message.getValidator()) || message.getScope() != scope || message.getBean() != bean || !message.getField().equals(fieldName) || !messagesToDel.contains(message.getMessage())) continue;
            this.data.remove(i);
            if (!notify) continue;
            this.fireTableRowsDeleted(i, i);
        }
    }

    protected BeanListValidatorListener getListValidatorListener() {
        if (this.listValidatorListener == null) {
            this.listValidatorListener = event -> {
                boolean mustDel;
                String[] toDelete = event.getMessagesToDelete();
                String[] toAdd = event.getMessagesToAdd();
                String field = event.getField();
                Object bean = event.getBean();
                NuitonValidatorScope scope = event.getScope();
                boolean mustAdd = toAdd != null && toAdd.length > 0;
                boolean bl = mustDel = toDelete != null && toDelete.length > 0;
                if (log.isTraceEnabled()) {
                    log.trace((Object)"----------------------------------------------------------");
                    log.trace((Object)(field + " - (" + this.getRowCount() + ") toAdd     " + mustAdd));
                    log.trace((Object)(field + " - (" + this.getRowCount() + ") toDelete  " + mustDel));
                }
                BeanListValidator validator = (BeanListValidator)event.getSource();
                if (mustDel) {
                    this.removeMessages(validator, bean, field, scope, !mustAdd, toDelete);
                }
                if (mustAdd) {
                    this.addMessages(validator, bean, field, scope, true, toAdd);
                }
            };
        }
        return this.listValidatorListener;
    }

    protected SimpleBeanValidatorListener getSimpleValidatorListener() {
        if (this.simpleValidatorListener == null) {
            this.simpleValidatorListener = event -> {
                boolean mustDel;
                String[] toDelete = event.getMessagesToDelete();
                String[] toAdd = event.getMessagesToAdd();
                String field = event.getField();
                NuitonValidatorScope scope = event.getScope();
                boolean mustAdd = toAdd != null && toAdd.length > 0;
                boolean bl = mustDel = toDelete != null && toDelete.length > 0;
                if (log.isTraceEnabled()) {
                    log.trace((Object)"----------------------------------------------------------");
                    log.trace((Object)(field + " - (" + this.getRowCount() + ") toAdd     " + mustAdd));
                    log.trace((Object)(field + " - (" + this.getRowCount() + ") toDelete  " + mustDel));
                }
                SwingValidator validator = (SwingValidator)((Object)((Object)event.getSource()));
                if (mustDel) {
                    this.removeMessages(validator, field, scope, !mustAdd, toDelete);
                }
                if (mustAdd) {
                    this.addMessages(validator, field, scope, true, toAdd);
                }
            };
        }
        return this.simpleValidatorListener;
    }
}

