/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.swing.extra.layer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.plaf.LayerUI;

public class BlockingLayerUI2
extends LayerUI<JComponent> {
    public static final String CAN_CLICK_PROPERTY = "canClick";
    public static final String ACCEPT_ICON_PROPERTY = "acceptIcon";
    public static final String BLOCK_ICON_PROPERTY = "blockIcon";
    protected Action acceptAction;
    protected BufferedImage blockIcon;
    protected BufferedImage acceptIcon;
    protected Color blockingColor;
    protected boolean canClick;
    private static final long ACCEPTED_EVENTS = 231487L;

    public void setAcceptAction(Action acceptAction) {
        this.acceptAction = acceptAction;
    }

    public void setAcceptIcon(ImageIcon acceptIcon) {
        this.acceptIcon = this.prepareIcon(acceptIcon);
        this.firePropertyChange(ACCEPT_ICON_PROPERTY, null, acceptIcon);
        this.setDirty(true);
    }

    public void setBlockIcon(ImageIcon blockIcon) {
        this.blockIcon = this.prepareIcon(blockIcon);
        this.firePropertyChange(BLOCK_ICON_PROPERTY, null, blockIcon);
        this.setDirty(true);
    }

    public void setCanClick(boolean canClick) {
        boolean oldvalue = this.canClick;
        this.canClick = canClick;
        this.firePropertyChange(CAN_CLICK_PROPERTY, oldvalue, canClick);
        if (oldvalue != canClick) {
            this.setDirty(true);
        }
    }

    public void setDirty(boolean dirty) {
        this.firePropertyChange("dirty", null, dirty);
    }

    @Override
    public void applyPropertyChange(PropertyChangeEvent evt, JLayer<? extends JComponent> l) {
        super.applyPropertyChange(evt, l);
        if (!"dirty".equals(evt.getPropertyName()) || evt.getNewValue() == Boolean.TRUE) {
            l.repaint();
        }
    }

    public void setBlockingColor(Color blockingColor) {
        this.blockingColor = blockingColor;
    }

    public void setBlockIcon(BufferedImage blockIcon) {
        this.blockIcon = blockIcon;
    }

    public BufferedImage getBlockIcon() {
        return this.blockIcon;
    }

    protected BufferedImage getAcceptIcon() {
        return this.acceptIcon;
    }

    public boolean isCanClick() {
        return this.canClick;
    }

    public BlockingLayerUI2 clone() {
        BlockingLayerUI2 clone = new BlockingLayerUI2();
        clone.acceptAction = this.acceptAction;
        clone.acceptIcon = this.acceptIcon;
        clone.blockIcon = this.blockIcon;
        clone.blockingColor = this.blockingColor;
        clone.setCanClick(false);
        return clone;
    }

    @Override
    protected void processKeyEvent(KeyEvent e, JLayer<? extends JComponent> l) {
        e.consume();
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e, JLayer<? extends JComponent> l) {
        e.consume();
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e, JLayer<? extends JComponent> l) {
        e.consume();
    }

    @Override
    protected void processMouseEvent(MouseEvent e, JLayer<? extends JComponent> l) {
        switch (e.getID()) {
            case 504: {
                this.setCanClick(true);
                break;
            }
            case 505: {
                this.setCanClick(false);
                break;
            }
            case 500: {
                if (!this.canClick) break;
                this.acceptEvent(e, l);
            }
        }
        e.consume();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        JLayer l = (JLayer)c;
        l.setLayerEventMask(231487L);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        JLayer l = (JLayer)c;
        l.setLayerEventMask(0L);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        JLayer l = (JLayer)c;
        Graphics2D g2 = (Graphics2D)g;
        if (this.blockingColor != null) {
            g2.setColor(this.blockingColor);
            g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
            g2.fillRect(0, 0, l.getWidth(), l.getHeight());
        }
        if (this.getCurrentIcon() != null) {
            g2.drawImage((Image)this.getCurrentIcon(), l.getWidth() - this.getCurrentIcon().getWidth() - 1, 0, null);
        }
    }

    protected void acceptEvent(MouseEvent e, JLayer<? extends JComponent> l) {
        if (this.acceptAction != null) {
            this.acceptAction.putValue("layer", l);
            JComponent source = l.getView();
            this.acceptAction.actionPerformed(new ActionEvent(source, 0, "accept"));
        }
    }

    protected BufferedImage getCurrentIcon() {
        return this.canClick ? this.acceptIcon : this.blockIcon;
    }

    protected BufferedImage prepareIcon(ImageIcon image) {
        BufferedImage icon = new BufferedImage(image.getIconWidth(), image.getIconHeight(), 2);
        Graphics2D g2 = (Graphics2D)icon.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.drawImage(image.getImage(), 0, 0, null);
        g2.dispose();
        return icon;
    }

    protected void updateCanClickState(JLayer<JComponent> l, MouseEvent e) {
        Point layerLocation = l.getView().getLocation();
        Point mousePoint = e.getPoint();
        BufferedImage currentIcon = this.getCurrentIcon();
        if (currentIcon == null) {
            this.setCanClick(false);
            return;
        }
        int minX = (int)layerLocation.getX() + l.getWidth() - currentIcon.getWidth();
        int maxX = (int)layerLocation.getX() + l.getWidth();
        boolean minY = false;
        int maxY = currentIcon.getHeight();
        boolean accept = (double)minX <= mousePoint.getX() && mousePoint.getX() <= (double)maxX;
        this.setCanClick(accept &= (double)minY <= mousePoint.getLocation().getY() && mousePoint.getLocation().getY() <= (double)maxY);
    }
}

