/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.swing.extra;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Swings {
    private static final Log log = LogFactory.getLog(Swings.class);

    public static Map<String, JComponent> lookingForEditor(Class<?> clazz, Container container) {
        HashMap<String, JComponent> result = new HashMap<String, JComponent>();
        try {
            String name;
            HashMap<String, JComponent> allNamedComponent = new HashMap<String, JComponent>();
            LinkedList<Container> todo = new LinkedList<Container>();
            todo.add(container);
            while (todo.size() > 0) {
                ListIterator<Container> i = todo.listIterator();
                while (i.hasNext()) {
                    Container parent = (Container)i.next();
                    i.remove();
                    for (Component c : parent.getComponents()) {
                        if (!(c instanceof Container)) continue;
                        i.add((Container)c);
                        name = c.getName();
                        if (!(c instanceof JComponent) || name == null || "".equals(name)) continue;
                        allNamedComponent.put(name, (JComponent)c);
                    }
                }
            }
            BeanInfo info = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            for (PropertyDescriptor prop : props) {
                name = prop.getName();
                if (!allNamedComponent.containsKey(name)) continue;
                result.put(name, (JComponent)allNamedComponent.get(name));
            }
        }
        catch (IntrospectionException eee) {
            log.warn((Object)"Can't introspect bean", (Throwable)eee);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Result: " + result));
        }
        return result;
    }

    public static Component getDeepestObjectAt(Component parent, int x, int y) {
        Container cont;
        Component child;
        if (parent instanceof Container && (child = Swings.findComponentAt(cont = (Container)parent, cont.getWidth(), cont.getHeight(), x, y)) != null && child != cont) {
            if (child instanceof JRootPane) {
                JLayeredPane lp = ((JRootPane)child).getLayeredPane();
                Rectangle b = lp.getBounds();
                child = Swings.getDeepestObjectAt(lp, x - b.x, y - b.y);
            }
            if (child != null) {
                return child;
            }
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component findComponentAt(Container cont, int width, int height, int x, int y) {
        Object object = cont.getTreeLock();
        synchronized (object) {
            JLayer layer;
            Rectangle rect;
            Component comp;
            int i;
            if (x < 0 || x >= width || y < 0 || y >= height || !cont.isVisible() || !cont.isEnabled()) {
                return null;
            }
            Component[] component = cont.getComponents();
            int ncomponents = cont.getComponentCount();
            for (i = 0; i < ncomponents; ++i) {
                comp = component[i];
                if (comp == null || comp.isLightweight()) continue;
                rect = comp.getBounds();
                if (comp instanceof JLayer) {
                    layer = (JLayer)comp;
                    comp = layer.getView();
                }
                if ((comp = comp instanceof Container ? Swings.findComponentAt((Container)comp, rect.width, rect.height, x - rect.x, y - rect.y) : comp.getComponentAt(x - rect.x, y - rect.y)) == null || !comp.isVisible() || !comp.isEnabled()) continue;
                return comp;
            }
            for (i = 0; i < ncomponents; ++i) {
                comp = component[i];
                if (comp == null || !comp.isLightweight()) continue;
                rect = comp.getBounds();
                if (comp instanceof JLayer) {
                    layer = (JLayer)comp;
                    comp = layer.getView();
                }
                if ((comp = comp instanceof Container ? Swings.findComponentAt((Container)comp, rect.width, rect.height, x - rect.x, y - rect.y) : comp.getComponentAt(x - rect.x, y - rect.y)) == null || !comp.isVisible() || !comp.isEnabled()) continue;
                return comp;
            }
            return cont;
        }
    }

    public static void center(Component parent, Component component) {
        if (parent != null) {
            Rectangle r = parent.getBounds();
            int x = r.x + (r.width - component.getSize().width) / 2;
            int y = r.y + (r.height - component.getSize().height) / 2;
            component.setLocation(x, y);
        }
    }

    public static Dimension newMinDimension() {
        return new Dimension(0, 0);
    }

    public static Dimension newMaxXDimension() {
        return new Dimension(Short.MAX_VALUE, 0);
    }

    public static Dimension newMaxYDimension() {
        return new Dimension(0, Short.MAX_VALUE);
    }

    public static Dimension newMaxXYDimension() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }
}

