/*
 * *##% 
 * JAXX Runtime
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.runtime.context;

import java.util.List;
import jaxx.runtime.JAXXContext;

/**
 * To qualify an entry in a {@link JAXXContext}.
 * <p/>
 * Use the factory methods <code>newContextEntryDef</code> and <code>newListContextEntryDef</code< to obtain new instances.
 *
 * @param <O> type of the entry associated to the definition
 * @author chemit
 */
public class JAXXContextEntryDef<O> implements java.io.Serializable {

    /** name of the entry, can be nuill for a unamed entry. */
    protected String name;

    /** class of the entry, can not be null */
    protected Class<O> klass;

    private static final long serialVersionUID = 1L;

//    public static <O> JAXXContextEntryDef<O> newContextEntryDef(Class<O> klass) {
//        return newContextEntryDef(null, klass);
//    }
//
//    public static <O> JAXXContextEntryDef<O> newContextEntryDef(String name, Class<O> klass) {
//        return new JAXXContextEntryDef<O>(name, klass);
//    }
//
//    public static <O> JAXXContextEntryDef<List<O>> newListContextEntryDef() {
//        return newListContextEntryDef(null);
//    }
//
//    @SuppressWarnings({"unchecked"})
//    public static <O> JAXXContextEntryDef<List<O>> newListContextEntryDef(String name) {
//        Class<List<O>> castList = JAXXContextEntryDef.<O>castList();
//        JAXXContextEntryDef<List<O>> contextEntryDef = new JAXXContextEntryDef<List<O>>(name,castList);
//        contextEntryDef.klass = castList;
//        return contextEntryDef;
//    }


    public String getName() {
        return name;
    }

    public Class<O> getKlass() {
        return klass;
    }

    public O getContextValue(JAXXContext context) {
        return context.getContextValue(klass, name);
    }

    public void removeContextValue(JAXXContext context) {
        context.removeContextValue(klass, name);
    }

    public void setContextValue(JAXXContext context, O value) {
        context.setContextValue(value, name);
    }

    @Override
    public String toString() {
        return super.toString() + "<" + klass + ":" + name + ">";
    }

    public JAXXContextEntryDef(Class<O> klass) {
        this(null, klass);
    }

    @SuppressWarnings("unchecked")
    public JAXXContextEntryDef(String name, Class<O> klass) {
        if (klass == null) {
            throw new IllegalArgumentException("class can not be null");
        }
        this.name = name;
        if (List.class.isAssignableFrom(klass)) {
            klass = (Class<O>) List.class;
        }
        this.klass = klass;
    }
//
//    @SuppressWarnings({"unchecked"})
//    protected static <O> Class<List<O>> castList() {
//        return (Class<List<O>>) Collections.emptyList().getClass();
//    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JAXXContextEntryDef<?>)) {
            return false;
        }
        JAXXContextEntryDef<?> that = (JAXXContextEntryDef<?>) o;
        return klass.equals(that.klass) && !(name != null ? !name.equals(that.name) : that.name != null);

    }

    @Override
    public int hashCode() {
        int result = (name != null ? name.hashCode() : 0);
        return 31 * result + klass.hashCode();
    }

    public boolean accept(Class<?> klass, String name) {
        if (klass == Object.class && this.klass != Object.class) {
            // try on name only
            return (this.name != null && name != null && this.name.equals(name));
        }
        return klass.isAssignableFrom(this.klass) && (this.name == null && name == null
                || (this.name != null && name != null && this.name.equals(name)));
    }

    public boolean accept2(Class<?> klass, String name) {
        return !(klass == Object.class && this.klass != Object.class) &&
                this.klass.isAssignableFrom(klass) && (this.name == null &&
                name == null || (this.name != null && name != null && this.name.equals(name)));
    }
}
