/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.plugin;

import java.io.File;
import java.util.Locale;
import java.util.Set;
import jaxx.compiler.decorators.HelpRootCompiledObjectDecorator;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.nuiton.jaxx.plugin.AbstractGenerateHelpMojo;

@Mojo(name="generate-help-ids", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresProject=true)
public class GenerateHelpIdsMojo
extends AbstractGenerateHelpMojo {
    protected Set<String> helpIds;

    @Override
    public void init() throws Exception {
        if (!this.generateHelp) {
            return;
        }
        super.init();
        if (this.getHelpIdsFilename() == null) {
            throw new MojoFailureException("you must set the 'helpIdStore' property.");
        }
        if (this.getMergeHelpIdsFilename() == null) {
            throw new MojoFailureException("you must set the 'helpIdStoreAll' property.");
        }
        this.helpIds = HelpRootCompiledObjectDecorator.getHelpIds();
        this.cleanHelpIdsStore();
    }

    @Override
    protected boolean checkSkip() {
        boolean b = super.checkSkip();
        if (b && this.helpIds.isEmpty()) {
            this.getLog().info((CharSequence)"No help ids to treate, will skip goal.");
            return false;
        }
        return b;
    }

    @Override
    public void doAction() throws Exception {
        File idsStore = this.getHelpIdsStoreFile();
        this.getLog().info((CharSequence)("Store detected help ids to " + idsStore));
        this.storeHelpIds(idsStore, this.helpIds);
        File idsStoreAll = this.getMergeHelpIdsStoreFile();
        this.getLog().info((CharSequence)("Merge help ids to " + idsStoreAll));
        if (idsStoreAll.exists()) {
            Set<String> allIds = this.loadHelpIds(idsStoreAll);
            this.helpIds.addAll(allIds);
            allIds.clear();
        }
        this.storeHelpIds(idsStoreAll, this.helpIds);
        this.helpIds.clear();
    }

    @Override
    protected void doActionForLocale(Locale locale, boolean isDefaultLocale, File source, String localePath) throws Exception {
    }

    @Override
    protected void postDoAction() {
    }

    @Override
    public File getTargetDirectory() {
        return this.getOutputHelpIds();
    }

    @Override
    public void setTargetDirectory(File targetDirectory) {
        this.setOutputHelpIds(targetDirectory);
    }
}

