package jaxx.demo;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

/**
 *
 * @author chemit
 * @since 1.5
 */
public class NumberEditorDemoModel {

    protected PropertyChangeSupport p;
    protected int positifInteger;
    protected int normalInteger;
    protected float positifFloat;
    protected float normalFloat;

    public NumberEditorDemoModel() {
        p = new PropertyChangeSupport(this);
    }

    public float getNormalFloat() {
        return normalFloat;
    }

    public int getNormalInteger() {
        return normalInteger;
    }

    public float getPositifFloat() {
        return positifFloat;
    }

    public int getPositifInteger() {
        return positifInteger;
    }

    public void setNormalFloat(float normalFloat) {
        float old = this.normalFloat;
        this.normalFloat = normalFloat;
        p.firePropertyChange("normalFloat", old, normalFloat);
    }

    public void setNormalInteger(int normalInteger) {
        int old = this.normalInteger;
        this.normalInteger = normalInteger;
        p.firePropertyChange("normalInteger", old, normalInteger);
    }

    public void setPositifFloat(float positifFloat) {
        float old = this.positifFloat;
        this.positifFloat = positifFloat;
        p.firePropertyChange("positifFloat", old, positifFloat);
    }

    public void setPositifInteger(int positifInteger) {
        int old = this.positifInteger;
        this.positifInteger = positifInteger;
        p.firePropertyChange("positifInteger", old, positifInteger);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }
}
