package jaxx.demo;

import java.beans.*;

public class Model {

    protected String text = "text";

    protected String text2 = "text2";

    protected int ratio = 51;


    PropertyChangeSupport p;

    public Model() {
        p = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }


    public String getText() {
        return text;
    }

    public String getText2() {
        return text2;
    }

    public int getRatio() {
        return ratio;
    }

    public void setText(String text) {
        String oldText = this.text;
        this.text = text;
        p.firePropertyChange("text", oldText, text);
    }

    public void setText2(String text2) {
        String oldText2 = this.text2;
        this.text2 = text2;
        p.firePropertyChange("text2", oldText2, text2);
    }

    public void setRatio(int ratio) {
        int oldRatio = this.ratio;
        this.ratio = ratio;
        p.firePropertyChange("ratio", oldRatio, ratio);
    }
}