/*
 * *##% 
 * JAXX Compiler
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.compiler;

import jaxx.compiler.java.JavaFile;

/**
 * Contract of any object to interact with a {@link JAXXCompiler} before the 
 * generation pass.
 * 
 * @author chemit
 * @since 2.0.0
 */
public interface JAXXCompilerFinalizer {

    /**
     * Finalize compiler for a given compiler on the finalizer pass before any
     * generation.
     * 
     * @param root the root object
     * @param compiler the current compiler
     * @param javaFile the java file to generate
     * @param packageName the package name of the file to generate
     * @param className the class name of the file to generate
     * @throws Exception 
     */
    void finalizeCompiler(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) throws Exception;

    /**
     * Prepare java file after any compiler finalizer pass, says the last
     * action before generation.
     * 
     * @param root the root object
     * @param compiler the current compiler
     * @param javaFile the java file to generate
     * @param packageName the package name of the file to generate
     * @param className the class name of the file to generate
     * @throws Exception
     */
    void prepareJavaFile(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) throws Exception;
}
