/*
 * #%L
 * Maven helper plugin
 * 
 * $Id: RestRequest.java 867 2012-10-25 06:45:19Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-helper-plugin/tags/maven-helper-plugin-1.6/src/main/java/org/nuiton/io/rest/RestRequest.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.io.rest;

import java.io.File;
import java.util.Map;

/**
 * The contract of a rest request.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.3
 * @deprecated since 1.6, see http://nuiton.org/issues/2355, will be removed and not replaced in version 2.0
 */
@Deprecated
public interface RestRequest {

    /** @return the splitted path to add to url */
    String[] getPath();

    /**
     * @return an array of pair (parameter name - parameter value) to pass
     *         to request
     */
    String[] getParameters();

    /**
     * @return {@code true} if request has some attachments.
     * @since 1.5
     */
    boolean containsAttachments();

    /** @return the map of attachment to pass to request */
    Map<String, File> getAttachments();

    /**
     * Obtain the full url of the request.
     *
     * @param baseUrl the base url to use
     * @return the full url for this request
     * @since 1.5
     */
    String toPath(String baseUrl);

    /**
     * The method to use for this request.
     *
     * @return 1.5
     */
    RestMethod getMethod();

    /**
     * Gets headers to add in request.
     *
     * @return the headers to add in request.
     * @since 1.6
     */
    Map<String, String> getHeaders();
}
