package org.nuiton.eugene.plugin.writer;

import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.state.StateModel;
import org.nuiton.plugin.PluginIOContext;

import java.io.File;
import java.io.IOException;
import java.util.Map;

/**
 * @author tchemit
 * @plexus.component role="org.nuiton.eugene.ModelFileWriter" role-hint="xmi2statemodel" description="xmi to state model"
 * @since 2.0.0
 */
public class XmiToStateModelFileWriter extends BaseXmiToModelFileWriter {

    @Override
    public <M extends Model> boolean acceptModel(Class<M> modelType) {
        // accept only state models
        return StateModel.class.isAssignableFrom(modelType);
    }

    @Override
    protected String getExtension() {
        return "statemodel";
    }

    @Override
    protected String getStyleSheet(File model) {
        //TODO when StateModel will be supported in 2.1, compute the version to resolve the correct stylesheet
        return "xmi1.2ToStateModel.xsl";
    }
}