package org.nuiton.eugene.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.nuiton.eugene.models.Model;
import org.nuiton.plugin.AbstractPlugin;

import java.util.Map;

/**
 * User: chemit
 * Date: 23 nov. 2009
 * Time: 20:19:35
 */
public abstract class AbstractEugeneMojo extends AbstractPlugin {

    /**
     * Maven project.
     *
     * @description Dépendance du projet.
     * @parameter default-value="${project}"
     * @readonly
     * @since 2.0.0
     */
    protected MavenProject project;
    /**
     * @description le settings (pour obtenir le mode offline)
     * @parameter default-value="${settings}"
     * @readonly
     * @since 2.0.0
     */
    protected Settings settings;
    /**
     * Ecrase les fichiers générés.
     *
     * @parameter expression="${eugene.overwrite}" default-value="false"
     * @since 2.0.0
     */
    protected boolean overwrite;
    /**
     * Pour activer le mode verbeux.
     *
     * @parameter expression="${eugene.verbose}" default-value="${maven.verbose}"
     * @since 2.0.0
     */
    protected boolean verbose;
    /**
     * Encoding to be used for generation of files.
     *
     * @parameter expression="${eugene.encoding}" default-value="${project.build.sourceEncoding}"
     * @since 2.0.0
     */
    protected String encoding;
    /**
     * A flag to mark the mojo to be used in a test phase. This will permits to add generated sources in test compile roots.
     *
     * @parameter expression="${eugene.testPhase}" default-value="false"
     * @since 2.0.0
     */
    protected boolean testPhase;
    /**
     * The type of model to be used.
     *
     * @parameter expression="${eugene.modelType}"
     * @required
     * @since 2.0.0
     */
    protected String modelType;


    protected Class<? extends Model> modelClass;

    /**
     * All available models
     *
     * @component role="org.nuiton.eugene.models.Model"
     */
    protected Map<String, Model> _models;

    @Override
    protected boolean init() throws Exception {

        // on recupere le fqn du model à traiter via le container plexus (plus pratique dans ce cas où on veut
        // pouvoir associé un nom à un type de service).
        Model model = _models.get(modelType.trim().toLowerCase());
        if (model == null) {
            throw new MojoExecutionException("No modelType named '" + modelType + "', use one of " + _models.keySet());
        }
        modelClass = model.getClass();
        return true;
    }


    @Override
    public MavenProject getProject() {
        return project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Override
    public boolean isVerbose() {
        return verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getEncoding() {
        return encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isOverwrite() {
        return overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public Settings getSettings() {
        return settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public boolean isOffline() {
        return settings.isOffline();
    }

}
