/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.nuiton.eugene.models.extension.io.ModelExtensionFormat;
import org.nuiton.eugene.models.extension.io.ModelExtensionWriter;
import org.nuiton.eugene.models.extension.model.ModelExtension;
import org.nuiton.eugene.models.extension.model.ModelExtensionBuilder;
import org.nuiton.plugin.AbstractPlugin;

@Mojo(name="transform-extension-model")
public class TransformExtensionModelMojo
extends AbstractPlugin {
    @Parameter(property="modelName", required=true)
    protected String modelName;
    @Parameter(property="inputFormat", required=true)
    protected String inputFormat;
    @Parameter(property="outputFormat", required=true)
    protected String outputFormat;
    @Parameter(property="dryRun")
    protected boolean dryRun;
    @Parameter(defaultValue="${maven.verbose}")
    protected boolean verbose;
    @Parameter(property="eugene.directory", defaultValue="${project.basedir}/src/main/xmi", required=true)
    protected File directory;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="eugene.encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    private File[] inputFiles;
    private File outputFile;

    protected void init() throws Exception {
        try {
            ModelExtensionFormat.valueOf((String)this.inputFormat);
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("Unknown input format: " + this.inputFormat + ", must be one of " + Arrays.toString(ModelExtensionFormat.values()));
        }
        try {
            ModelExtensionFormat.valueOf((String)this.outputFormat);
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("Unknown output format: " + this.outputFormat + ", must be one of " + Arrays.toString(ModelExtensionFormat.values()));
        }
        this.inputFiles = this.directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("." + TransformExtensionModelMojo.this.inputFormat);
            }
        });
        this.getLog().info((CharSequence)("Found " + this.inputFiles.length + " model extension file(s)."));
        this.outputFile = new File(this.directory, this.modelName + "." + this.outputFormat);
    }

    protected void doAction() throws Exception {
        ModelExtensionBuilder modelExtensionBuilder = new ModelExtensionBuilder(false, this.modelName);
        for (File inputFile : this.inputFiles) {
            modelExtensionBuilder.addFile(inputFile);
        }
        ModelExtension modelExtension = modelExtensionBuilder.build();
        this.getLog().info((CharSequence)(modelExtensionBuilder.getStereotypeHits() + " stereotype(s) detected."));
        this.getLog().info((CharSequence)(modelExtensionBuilder.getTagValueHits() + " tag value(s) detected."));
        ModelExtensionWriter modelExtensionWriter = ModelExtensionWriter.newWriter((File)this.outputFile);
        if (this.dryRun) {
            String content;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, Charset.forName(this.encoding)));){
                    modelExtensionWriter.write(modelExtension, (Writer)writer);
                }
                content = out.toString(this.encoding);
            }
            this.getLog().info((CharSequence)("\n\nDryRun mode\ncontent:\n\n" + content + "\n\n"));
        } else {
            try (BufferedWriter writer = Files.newWriter((File)this.outputFile, (Charset)Charset.forName(this.encoding));){
                modelExtensionWriter.write(modelExtension, (Writer)writer);
            }
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

