package org.nuiton.eugene.java;

/*
 * #%L
 * EUGene :: Java templates
 * $Id: JavaTemplatesStereoTypes.java 1199 2012-11-06 09:14:01Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/eugene/tags/eugene-2.7.1/eugene-java-templates/src/main/java/org/nuiton/eugene/java/JavaTemplatesStereoTypes.java $
 * %%
 * Copyright (C) 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.eugene.EugeneStereoTypes;
import org.nuiton.eugene.ModelPropertiesUtil;
import org.nuiton.eugene.models.object.ObjectModelClassifier;

/**
 * Defines all stereotypes managed by Java templates.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.5.6
 */
public interface JavaTemplatesStereoTypes extends EugeneStereoTypes {

    /**
     * Stereotype for JavaBean objects to place on a classifier.
     *
     * @see JavaTemplatesGeneratorUtil#hasBeanStereotype(ObjectModelClassifier)
     * @since 2.5.6
     */
    @ModelPropertiesUtil.StereotypeDefinition(
            target = ObjectModelClassifier.class,
            documentation = "To specify that a class is a JavaBean")
    String STEREOTYPE_BEAN = "bean";
}
