package org.nuiton.eugene.java;

/*
 * #%L
 * EUGene :: Java templates
 * $Id: JavaTemplatesTagValues.java 1204 2012-11-13 10:29:53Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/eugene/tags/eugene-2.5.6/eugene-java-templates/src/main/java/org/nuiton/eugene/java/JavaTemplatesTagValues.java $
 * %%
 * Copyright (C) 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.eugene.EugeneTagValues;
import org.nuiton.eugene.ModelPropertiesUtil;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClassifier;

/**
 * Defines all tag values managed by Java templates.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.5.6
 */
public interface JavaTemplatesTagValues extends EugeneTagValues {

    /**
     * Tag value to set if do not want any pcs (says PropertyChangeSupport in a generated bean).
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see JavaTemplatesGeneratorUtil#getNoPCSTagValue(ObjectModel, ObjectModelClassifier)
     * @since 2.5.6
     */
    @ModelPropertiesUtil.TagValueDefinition(
            target = {ObjectModel.class, ObjectModelClassifier.class},
            documentation = "To specify to not generate any propertyChange " +
                            "code for a class or any class of a model")
    String TAG_NO_PCS = "noPCS";

    /**
     * Tag value to use a super class for generated bean.
     * <p/>
     * If the bean needs Property change support (says you do not add the {@link #TAG_NO_PCS} on classifier or model,
     * then your class must provide evrything for it.
     * <p/>
     * More over, if you use some collections in your bean you must also define
     * two method named {@code getChild(Collection list, int index)} and
     * {@code getChild(List list, int index)}
     * <p/>
     * See new code to know minimum stuff to add in your class for this purpose.
     * <pre>
     * public abstract class AbstractBean implements Serializable {
     *
     *     private static final long serialVersionUID = 1L;
     *
     *     protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
     *
     *     public void addPropertyChangeListener(PropertyChangeListener listener) {
     *         pcs.addPropertyChangeListener(listener);
     *     }
     *
     *     public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
     *         pcs.addPropertyChangeListener(propertyName, listener);
     *     }
     *
     *     public void removePropertyChangeListener(PropertyChangeListener listener) {
     *         pcs.removePropertyChangeListener(listener);
     *     }
     *
     *     public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
     *         pcs.removePropertyChangeListener(propertyName, listener);
     *     }
     *
     *     protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
     *         pcs.firePropertyChange(propertyName, oldValue, newValue);
     *     }
     *
     *     protected void firePropertyChange(String propertyName, Object newValue) {
     *         firePropertyChange(propertyName, null, newValue);
     *     }
     *
     *     protected <T> T getChild(Collection<T> list, int index) {
     *         return CollectionUtil.getOrNull(list, index);
     *     }
     *
     *     protected <T> T getChild(List<T> list, int index) {
     *         return CollectionUtil.getOrNull(list, index);
     *     }
     * }
     * </pre>
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see JavaTemplatesGeneratorUtil#getBeanSuperClassTagValue(ObjectModel, ObjectModelClassifier)
     * @since 2.5.6
     */
    @ModelPropertiesUtil.TagValueDefinition(
            target = {ObjectModel.class, ObjectModelClassifier.class},
            documentation = "To specify a super-class to used on generated bean " +
                            "for a class or any class of a model")
    String TAG_BEAN_SUPER_CLASS = "beanSuperClass";
}
