/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.NumericUtils;
import org.neo4j.kernel.api.index.ArrayEncoder;

public class LuceneDocumentStructure {
    static final String NODE_ID_KEY = "id";

    Document newDocument(long nodeId) {
        Document document = new Document();
        document.add((Fieldable)LuceneDocumentStructure.field(NODE_ID_KEY, "" + nodeId, Field.Store.YES));
        return document;
    }

    public Document newDocumentRepresentingProperty(long nodeId, Fieldable encodedValue) {
        Document document = this.newDocument(nodeId);
        document.add(encodedValue);
        return document;
    }

    public Fieldable encodeAsFieldable(Object value) {
        for (ValueEncoding encoding : ValueEncoding.values()) {
            if (!encoding.canEncode(value)) continue;
            return encoding.encodeField(value);
        }
        throw new IllegalStateException("Unable to encode the value " + value);
    }

    private static Field field(String fieldIdentifier, String value) {
        return LuceneDocumentStructure.field(fieldIdentifier, value, Field.Store.NO);
    }

    private static Field field(String fieldIdentifier, String value, Field.Store store) {
        Field result = new Field(fieldIdentifier, value, store, Field.Index.NOT_ANALYZED);
        result.setOmitNorms(true);
        result.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
        return result;
    }

    public MatchAllDocsQuery newScanQuery() {
        return new MatchAllDocsQuery();
    }

    public TermQuery newSeekQuery(Object value) {
        for (ValueEncoding encoding : ValueEncoding.values()) {
            if (!encoding.canEncode(value)) continue;
            return encoding.encodeQuery(value);
        }
        throw new IllegalArgumentException(String.format("Unable to create query for %s", value));
    }

    public TermRangeQuery newInclusiveNumericRangeSeekQuery(Number lower, Number upper) {
        String chosenLower = lower == null ? null : NumericUtils.doubleToPrefixCoded((double)lower.doubleValue());
        String chosenUpper = upper == null ? null : NumericUtils.doubleToPrefixCoded((double)upper.doubleValue());
        return new TermRangeQuery(ValueEncoding.Number.key(), chosenLower, chosenUpper, true, true);
    }

    public TermRangeQuery newRangeSeekByStringQuery(String lower, boolean includeLower, String upper, boolean upperInclusive) {
        boolean includeChosenUpper;
        String chosenUpper;
        boolean includeChosenLower;
        String chosenLower;
        if (lower == null) {
            chosenLower = null;
            includeChosenLower = true;
        } else {
            chosenLower = lower;
            includeChosenLower = includeLower;
        }
        if (upper == null) {
            chosenUpper = null;
            includeChosenUpper = true;
        } else {
            chosenUpper = upper;
            includeChosenUpper = upperInclusive;
        }
        return new TermRangeQuery(ValueEncoding.String.key(), chosenLower, chosenUpper, includeChosenLower, includeChosenUpper);
    }

    public PrefixQuery newRangeSeekByPrefixQuery(String prefix) {
        return new PrefixQuery(new Term(ValueEncoding.String.key(), prefix));
    }

    public Term newTermForChangeOrRemove(long nodeId) {
        return new Term(NODE_ID_KEY, "" + nodeId);
    }

    public long getNodeId(Document from) {
        return Long.parseLong(from.get(NODE_ID_KEY));
    }

    static enum ValueEncoding {
        Number{

            @Override
            String key() {
                return "number";
            }

            @Override
            boolean canEncode(Object value) {
                return value instanceof Number;
            }

            @Override
            Fieldable encodeField(Object value) {
                String encodedString = NumericUtils.doubleToPrefixCoded((double)((Number)value).doubleValue());
                return LuceneDocumentStructure.field(this.key(), encodedString);
            }

            @Override
            TermQuery encodeQuery(Object value) {
                String encodedString = NumericUtils.doubleToPrefixCoded((double)((Number)value).doubleValue());
                return new TermQuery(new Term(this.key(), encodedString));
            }
        }
        ,
        Array{

            @Override
            String key() {
                return "array";
            }

            @Override
            boolean canEncode(Object value) {
                return value.getClass().isArray();
            }

            @Override
            Fieldable encodeField(Object value) {
                return LuceneDocumentStructure.field(this.key(), ArrayEncoder.encode((Object)value));
            }

            @Override
            TermQuery encodeQuery(Object value) {
                return new TermQuery(new Term(this.key(), ArrayEncoder.encode((Object)value)));
            }
        }
        ,
        Bool{

            @Override
            String key() {
                return "bool";
            }

            @Override
            boolean canEncode(Object value) {
                return value instanceof Boolean;
            }

            @Override
            Fieldable encodeField(Object value) {
                return LuceneDocumentStructure.field(this.key(), value.toString());
            }

            @Override
            TermQuery encodeQuery(Object value) {
                return new TermQuery(new Term(this.key(), value.toString()));
            }
        }
        ,
        String{

            @Override
            String key() {
                return "string";
            }

            @Override
            boolean canEncode(Object value) {
                return true;
            }

            @Override
            Fieldable encodeField(Object value) {
                return LuceneDocumentStructure.field(this.key(), value.toString());
            }

            @Override
            TermQuery encodeQuery(Object value) {
                return new TermQuery(new Term(this.key(), value.toString()));
            }
        };


        abstract String key();

        abstract boolean canEncode(Object var1);

        abstract Fieldable encodeField(Object var1);

        abstract TermQuery encodeQuery(Object var1);

        public static ValueEncoding fromKey(String key) {
            switch (key) {
                case "number": {
                    return Number;
                }
                case "array": {
                    return Array;
                }
                case "bool": {
                    return Bool;
                }
                case "string": {
                    return String;
                }
            }
            throw new IllegalArgumentException("Unknown key: " + key);
        }
    }
}

