/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.impl.index.BitmapDocumentFormat;
import org.neo4j.kernel.api.impl.index.LabelScanStorageStrategy;
import org.neo4j.kernel.api.impl.index.bitmaps.Bitmap;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class LuceneLabelScanWriter
implements LabelScanWriter {
    private final LabelScanStorageStrategy.StorageService storage;
    private final BitmapDocumentFormat format;
    private final IndexSearcher searcher;
    private final List<NodeLabelUpdate> updates;
    private long currentRange;
    private final Lock heldLock;

    public LuceneLabelScanWriter(LabelScanStorageStrategy.StorageService storage, BitmapDocumentFormat format, Lock heldLock) {
        this.storage = storage;
        this.format = format;
        this.heldLock = heldLock;
        this.currentRange = -1L;
        this.updates = new ArrayList<NodeLabelUpdate>(format.bitmapFormat().rangeSize());
        this.searcher = storage.acquireSearcher();
    }

    public void write(NodeLabelUpdate update) throws IOException, IndexCapacityExceededException {
        long range = this.format.bitmapFormat().rangeOf(update.getNodeId());
        if (range != this.currentRange) {
            if (range < this.currentRange) {
                throw new IllegalArgumentException("NodeLabelUpdates must be supplied in order of ascending node id");
            }
            this.flush();
            this.currentRange = range;
        }
        this.updates.add(update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (IndexCapacityExceededException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
        finally {
            try {
                this.storage.releaseSearcher(this.searcher);
                this.storage.refreshSearcher();
            }
            finally {
                this.heldLock.unlock();
            }
        }
    }

    private Map<Long, Bitmap> readLabelBitMapsInRange(IndexSearcher searcher, long range) throws IOException {
        HashMap<Long, Bitmap> fields = new HashMap<Long, Bitmap>();
        Term documentTerm = this.format.rangeTerm(range);
        TopDocs docs = searcher.search((Query)new TermQuery(documentTerm), 1);
        if (docs != null && docs.totalHits != 0) {
            Document document = searcher.doc(docs.scoreDocs[0].doc);
            for (Fieldable field : document.getFields()) {
                if (this.format.isRangeField(field)) continue;
                Long label = Long.valueOf(field.name());
                fields.put(label, this.format.readBitmap(field));
            }
        }
        return fields;
    }

    private void flush() throws IOException, IndexCapacityExceededException {
        if (this.currentRange < 0L) {
            return;
        }
        Map<Long, Bitmap> fields = this.readLabelBitMapsInRange(this.searcher, this.currentRange);
        this.updateFields(this.updates, fields);
        Document document = new Document();
        document.add(this.format.rangeField(this.currentRange));
        for (Map.Entry<Long, Bitmap> field : fields.entrySet()) {
            Bitmap value = field.getValue();
            if (!value.hasContent()) continue;
            this.format.addLabelField(document, field.getKey(), value);
        }
        if (this.isEmpty(document)) {
            this.storage.deleteDocuments(this.format.rangeTerm(document));
        } else {
            this.storage.updateDocument(this.format.rangeTerm(document), document);
        }
        this.updates.clear();
    }

    private boolean isEmpty(Document document) {
        for (Fieldable fieldable : document.getFields()) {
            if (this.format.isRangeField(fieldable)) continue;
            return false;
        }
        return true;
    }

    private void updateFields(Iterable<NodeLabelUpdate> updates, Map<Long, Bitmap> fields) {
        for (NodeLabelUpdate update : updates) {
            this.clearLabels(fields, update);
            this.setLabels(fields, update);
        }
    }

    private void clearLabels(Map<Long, Bitmap> fields, NodeLabelUpdate update) {
        for (Bitmap bitmap : fields.values()) {
            this.format.bitmapFormat().set(bitmap, update.getNodeId(), false);
        }
    }

    private void setLabels(Map<Long, Bitmap> fields, NodeLabelUpdate update) {
        for (long label : update.getLabelsAfter()) {
            Bitmap bitmap = fields.get(label);
            if (bitmap == null) {
                bitmap = new Bitmap();
                fields.put(label, bitmap);
            }
            this.format.bitmapFormat().set(bitmap, update.getNodeId(), true);
        }
    }
}

