/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphmatching;

import java.util.regex.Pattern;
import org.neo4j.graphmatching.ArrayPropertyUtil;
import org.neo4j.graphmatching.ValueMatcher;

@Deprecated
public abstract class CommonValueMatchers {
    private static final ValueMatcher HAS = new ValueMatcher(){

        @Override
        public boolean matches(Object value) {
            return value != null;
        }
    };

    private CommonValueMatchers() {
    }

    public static ValueMatcher exact(Object valueToMatch) {
        return new ExactMatcher(valueToMatch);
    }

    public static ValueMatcher exactAny(Object valueToMatch) {
        return new ExactAnyMatcher(valueToMatch);
    }

    public static ValueMatcher exactAnyOf(Object ... anyOfTheseToMatch) {
        return new ExactAnyMatcher(anyOfTheseToMatch);
    }

    public static ValueMatcher has() {
        return HAS;
    }

    public static ValueMatcher regex(Pattern pattern) {
        return new RegexMatcher(pattern);
    }

    private static class RegexMatcher
    implements ValueMatcher {
        private final Pattern pattern;

        public RegexMatcher(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(Object value) {
            return value != null && this.pattern.matcher(value.toString()).matches();
        }
    }

    private static class ExactAnyMatcher
    implements ValueMatcher {
        private final Object[] valuesToMatch;

        public ExactAnyMatcher(Object ... valueToMatch) {
            this.valuesToMatch = valueToMatch;
        }

        @Override
        public boolean matches(Object value) {
            if (value != null) {
                if (value.getClass().isArray()) {
                    for (Object item : ArrayPropertyUtil.propertyValueToCollection(value)) {
                        if (item == null || !this.anyMatches(item)) continue;
                        return true;
                    }
                } else if (this.anyMatches(value)) {
                    return true;
                }
            }
            return false;
        }

        private boolean anyMatches(Object value) {
            for (Object matchValue : this.valuesToMatch) {
                if (!value.equals(matchValue)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ExactMatcher
    implements ValueMatcher {
        private final Object valueToMatch;

        public ExactMatcher(Object valueToMatch) {
            this.valueToMatch = valueToMatch;
        }

        @Override
        public boolean matches(Object value) {
            return value != null && this.valueToMatch.equals(value);
        }
    }
}

