/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.configuration.ConfigOptions;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.DocumentedDefaultValue;
import org.neo4j.configuration.Dynamic;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.ReplacedBy;
import org.neo4j.graphdb.config.BaseSetting;
import org.neo4j.graphdb.config.SettingGroup;

public interface LoadableConfig {
    default public List<ConfigOptions> getConfigOptions() {
        ArrayList<ConfigOptions> configOptions = new ArrayList<ConfigOptions>();
        for (Field f : this.getClass().getDeclaredFields()) {
            try {
                BaseSetting setting;
                Object publicSetting = f.get(this);
                if (publicSetting instanceof BaseSetting) {
                    Internal internalAnnotation;
                    Deprecated deprecatedAnnotation;
                    DocumentedDefaultValue defValue;
                    setting = (BaseSetting)publicSetting;
                    Description documentation = f.getAnnotation(Description.class);
                    if (documentation != null) {
                        setting.setDescription(documentation.value());
                    }
                    if ((defValue = f.getAnnotation(DocumentedDefaultValue.class)) != null) {
                        setting.setDocumentedDefaultValue(defValue.value());
                    }
                    setting.setDeprecated((deprecatedAnnotation = f.getAnnotation(Deprecated.class)) != null);
                    ReplacedBy replacedByAnnotation = f.getAnnotation(ReplacedBy.class);
                    if (replacedByAnnotation != null) {
                        setting.setReplacement(replacedByAnnotation.value());
                    }
                    setting.setInternal((internalAnnotation = f.getAnnotation(Internal.class)) != null);
                    Dynamic dynamicAnnotation = f.getAnnotation(Dynamic.class);
                    setting.setDynamic(dynamicAnnotation != null);
                }
                if (!(publicSetting instanceof SettingGroup)) continue;
                setting = (SettingGroup)publicSetting;
                configOptions.add(new ConfigOptions((SettingGroup<?>)setting));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return configOptions;
    }

    public static List<LoadableConfig> allConfigClasses() {
        return StreamSupport.stream(ServiceLoader.load(LoadableConfig.class).spliterator(), false).collect(Collectors.toList());
    }

    public static List<ConfigOptions> loadAllAvailableConfigOptions() {
        return StreamSupport.stream(ServiceLoader.load(LoadableConfig.class).spliterator(), false).map(LoadableConfig::getConfigOptions).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

