/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.allocator.pointers.cuda;

import org.bytedeco.javacpp.Pointer;
import org.nd4j.jita.allocator.pointers.CudaPointer;
import org.nd4j.jita.allocator.pointers.cuda.cudaStream_t;
import org.nd4j.linalg.exception.ND4JException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.NativeOpsHolder;

public class cudaEvent_t
extends CudaPointer {
    private boolean destroyed = false;
    private long clock;
    private int laneId;
    private int deviceId;

    public cudaEvent_t(Pointer pointer) {
        super(pointer);
    }

    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    public synchronized void markDestroyed() {
        this.destroyed = true;
    }

    public void destroy() {
        if (!this.isDestroyed()) {
            NativeOpsHolder.getInstance().getDeviceNativeOps().destroyEvent((Pointer)this);
            this.markDestroyed();
        }
    }

    public void synchronize() {
        if (!this.isDestroyed()) {
            int res = NativeOpsHolder.getInstance().getDeviceNativeOps().eventSynchronize((Pointer)this);
            if (res == 0) {
                throw new ND4JException("CUDA exception happened. Terminating. Last op: [" + Nd4j.getExecutioner().getLastOp() + "]");
            }
            int code = NativeOpsHolder.getInstance().getDeviceNativeOps().lastErrorCode();
            if (code != 0) {
                throw new RuntimeException(NativeOpsHolder.getInstance().getDeviceNativeOps().lastErrorMessage() + "; Error code: " + code);
            }
        }
    }

    public void register(cudaStream_t stream) {
        if (!this.isDestroyed()) {
            int res = NativeOpsHolder.getInstance().getDeviceNativeOps().registerEvent((Pointer)this, (Pointer)stream);
            int code = NativeOpsHolder.getInstance().getDeviceNativeOps().lastErrorCode();
            if (code != 0) {
                throw new RuntimeException(NativeOpsHolder.getInstance().getDeviceNativeOps().lastErrorMessage() + "; Error code: " + code);
            }
        }
    }

    public long getClock() {
        return this.clock;
    }

    public void setClock(long clock) {
        this.clock = clock;
    }

    public int getLaneId() {
        return this.laneId;
    }

    public void setLaneId(int laneId) {
        this.laneId = laneId;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(int deviceId) {
        this.deviceId = deviceId;
    }
}

