/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.buffer;

import java.nio.ByteBuffer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.jcublas.buffer.BaseCudaDataBuffer;

public class CudaShortDataBuffer
extends BaseCudaDataBuffer {
    public CudaShortDataBuffer(Pointer pointer, Indexer indexer, long length) {
        super(pointer, indexer, length);
    }

    public CudaShortDataBuffer(Pointer pointer, Pointer specialPointer, Indexer indexer, long length) {
        super(pointer, specialPointer, indexer, length);
    }

    public CudaShortDataBuffer(ByteBuffer buffer, DataType dataType, long length, long offset) {
        super(buffer, dataType, length, offset);
    }

    public CudaShortDataBuffer(long length) {
        super(length, 2);
    }

    public CudaShortDataBuffer(long length, boolean initialize) {
        super(length, 2, initialize);
    }

    public CudaShortDataBuffer(long length, int elementSize) {
        super(length, elementSize);
    }

    public CudaShortDataBuffer(long length, int elementSize, long offset) {
        super(length, elementSize, offset);
    }

    public CudaShortDataBuffer(long length, boolean initialize, MemoryWorkspace workspace) {
        super(length, 2, initialize, workspace);
    }

    public CudaShortDataBuffer(float[] data, boolean copy, MemoryWorkspace workspace) {
        super(data, copy, 0L, workspace);
    }

    protected void initTypeAndSize() {
        this.elementSize = (byte)2;
        this.type = DataType.SHORT;
    }

    public CudaShortDataBuffer(DataBuffer underlyingBuffer, long length, long offset) {
        super(underlyingBuffer, length, offset);
    }

    public CudaShortDataBuffer(float[] buffer) {
        super(buffer);
    }

    public CudaShortDataBuffer(float[] data, boolean copy) {
        super(data, copy);
    }

    public CudaShortDataBuffer(float[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaShortDataBuffer(float[] data, boolean copy, long offset, MemoryWorkspace workspace) {
        super(data, copy, offset, workspace);
    }

    public CudaShortDataBuffer(double[] data) {
        super(data);
    }

    public CudaShortDataBuffer(double[] data, boolean copy) {
        super(data, copy);
    }

    public CudaShortDataBuffer(double[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaShortDataBuffer(int[] data) {
        super(data);
    }

    public CudaShortDataBuffer(int[] data, boolean copy) {
        super(data, copy);
    }

    public CudaShortDataBuffer(int[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    protected DataBuffer create(long length) {
        return new CudaShortDataBuffer(length);
    }

    public float[] getFloatsAt(long offset, long inc, int length) {
        return super.getFloatsAt(offset, inc, length);
    }

    public double[] getDoublesAt(long offset, long inc, int length) {
        return ArrayUtil.toDoubles((float[])this.getFloatsAt(offset, inc, length));
    }

    @Override
    public void setData(float[] data) {
        this.setData(ArrayUtil.toShorts((float[])data));
    }

    @Override
    public void setData(int[] data) {
        this.setData(ArrayUtil.toShorts((int[])data));
    }

    @Override
    public void setData(double[] data) {
        this.setData(ArrayUtil.toFloats((double[])data));
    }

    public DataType dataType() {
        return DataType.SHORT;
    }

    @Override
    public float[] asFloat() {
        return super.asFloat();
    }

    @Override
    public double[] asDouble() {
        return ArrayUtil.toDoubles((float[])this.asFloat());
    }

    @Override
    public int[] asInt() {
        return ArrayUtil.toInts((float[])this.asFloat());
    }

    @Override
    public double getDouble(long i) {
        return super.getFloat(i);
    }

    public DataBuffer create(double[] data) {
        return new CudaShortDataBuffer(data);
    }

    public DataBuffer create(float[] data) {
        return new CudaShortDataBuffer(data);
    }

    public DataBuffer create(int[] data) {
        return new CudaShortDataBuffer(data);
    }

    @Override
    public void flush() {
    }
}

