/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.transport.AbstractConnector;

public class XmppConnector
extends AbstractConnector {
    public static final String XMPP = "xmpp";
    public static final String XMPP_PROPERTY_PREFIX = "";
    public static final String XMPP_RESOURCE = "resource";
    public static final String XMPP_SUBJECT = "subject";
    public static final String XMPP_THREAD = "thread";
    public static final String XMPP_TO = "to";
    public static final String XMPP_FROM = "from";
    public static final String XMPP_GROUP_CHAT = "groupChat";
    public static final String XMPP_NICKNAME = "nickname";

    protected void doInitialise() throws InitialisationException {
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public String getProtocol() {
        return XMPP;
    }

    public XMPPConnection createXmppConnection(EndpointURI endpointURI) throws XMPPException {
        this.logger.info((Object)("Trying to find XMPP connection for uri: " + endpointURI));
        String username = endpointURI.getUser();
        String hostname = endpointURI.getHost();
        String password = endpointURI.getPassword();
        String resource = (String)endpointURI.getParams().get(XMPP_RESOURCE);
        XMPPConnection xmppConnection = this.doCreateXmppConnection(endpointURI);
        if (!xmppConnection.isAuthenticated()) {
            try {
                AccountManager accManager = new AccountManager(xmppConnection);
                accManager.createAccount(username, password);
            }
            catch (XMPPException ex) {
                this.logger.info((Object)("*** account (" + username + ") already exists ***"));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Logging in as: " + username));
                this.logger.debug((Object)("pw is        : " + password));
                this.logger.debug((Object)("server       : " + hostname));
                this.logger.debug((Object)("resource     : " + resource));
            }
            if (resource == null) {
                xmppConnection.login(username, password);
            } else {
                xmppConnection.login(username, password, resource);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Already authenticated on this connection, no need to log in again.");
        }
        return xmppConnection;
    }

    protected XMPPConnection doCreateXmppConnection(EndpointURI endpointURI) throws XMPPException {
        XMPPConnection xmppConnection = null;
        xmppConnection = endpointURI.getPort() != -1 ? new XMPPConnection(endpointURI.getHost(), endpointURI.getPort()) : new XMPPConnection(endpointURI.getHost());
        return xmppConnection;
    }

    public boolean isResponseEnabled() {
        return true;
    }
}

