/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.transformers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.mule.util.IOUtils;
import org.mule.util.PropertiesUtils;
import org.mule.util.StringMessageUtils;

public class HttpRequestToSoapRequest
extends AbstractMessageAwareTransformer {
    public static final String SOAP_HEADER = "<?xml version=\"1.0\" encoding=\"{0}\"?><soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soap:Body>";
    public static final String SOAP_FOOTER = "</soap:Body></soap:Envelope>";
    public static final String DEFAULT_NAMESPACE = "http://www.muleumo.org/soap";

    public HttpRequestToSoapRequest() {
        this.registerSourceType(String.class);
        this.registerSourceType(InputStream.class);
        this.registerSourceType(byte[].class);
        this.setReturnClass(String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        int i;
        Object src = message.getPayload();
        String data = src.toString();
        if (src instanceof InputStream) {
            InputStream is = (InputStream)src;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)bos);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new TransformerException((Transformer)this, (Throwable)e);
            }
            src = bos.toByteArray();
        }
        if (src instanceof byte[]) {
            try {
                data = new String((byte[])src, outputEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new TransformerException((Transformer)this, (Throwable)e);
            }
            if (data.startsWith("<") || data.startsWith("&lt;")) {
                return data;
            }
        }
        String httpMethod = message.getStringProperty("http.method", "GET");
        String request = message.getStringProperty("http.request", null);
        String query = request.substring((i = request.indexOf(63)) + 1);
        Properties p = PropertiesUtils.getPropertiesFromQueryString((String)query);
        String method = (String)p.remove("method");
        if (method == null) {
            throw new TransformerException(CoreMessages.propertiesNotSet((String)"method"), (Transformer)this);
        }
        if (httpMethod.equals("POST")) {
            p.setProperty(method, data);
        }
        StringBuffer result = new StringBuffer(8192);
        String header = StringMessageUtils.getFormattedMessage((String)SOAP_HEADER, (Object[])new Object[]{outputEncoding});
        result.append(header);
        result.append('<').append(method).append(" xmlns=\"");
        result.append(DEFAULT_NAMESPACE).append("\">");
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            result.append('<').append(entry.getKey()).append('>');
            result.append(entry.getValue());
            result.append("</").append(entry.getKey()).append('>');
        }
        result.append("</").append(method).append('>');
        result.append(SOAP_FOOTER);
        return result.toString();
    }
}

