/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Header;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.config.ExceptionHelper;
import org.mule.transport.http.HttpResponse;
import org.mule.transport.http.transformers.MuleMessageToHttpResponse;

public abstract class AbstractReceiverServlet
extends HttpServlet {
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String REQUEST_TIMEOUT_PROPERTY = "org.mule.servlet.timeout";
    public static final String FEEDBACK_PROPERTY = "org.mule.servlet.feedback";
    public static final String DEFAULT_CONTENT_TYPE_PROPERTY = "org.mule.servlet.default.content.type";
    @Deprecated
    public static final String SERVLET_CONNECTOR_NAME_PROPERTY = "org.mule.servlet.connector.name";
    public static final String PAYLOAD_PARAMETER_NAME = "org.mule.servlet.payload.param";
    public static final String DEFAULT_PAYLOAD_PARAMETER_NAME = "payload";
    public static final long DEFAULT_GET_TIMEOUT = 10000L;
    protected String payloadParameterName;
    protected long timeout = 10000L;
    protected boolean feedback = true;
    protected String defaultContentType = "text/plain";
    protected MuleContext muleContext;
    private MuleMessageToHttpResponse responseTransformer = new MuleMessageToHttpResponse();

    public final void init() throws ServletException {
        String ct;
        String feedbackString;
        String timeoutString = this.getServletConfig().getInitParameter(REQUEST_TIMEOUT_PROPERTY);
        if (timeoutString != null) {
            this.timeout = Long.parseLong(timeoutString);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Default request timeout for GET methods is: " + this.timeout));
        }
        if ((feedbackString = this.getServletConfig().getInitParameter(FEEDBACK_PROPERTY)) != null) {
            this.feedback = Boolean.valueOf(feedbackString);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("feedback is set to: " + this.feedback));
        }
        if ((ct = this.getServletConfig().getInitParameter(DEFAULT_CONTENT_TYPE_PROPERTY)) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using default content type configured on the servlet (org.mule.servlet.default.content.type) = " + ct));
            }
            this.defaultContentType = ct;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Default content type is: " + this.defaultContentType));
        }
        this.payloadParameterName = this.getServletConfig().getInitParameter(PAYLOAD_PARAMETER_NAME);
        if (this.payloadParameterName == null) {
            this.payloadParameterName = DEFAULT_PAYLOAD_PARAMETER_NAME;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Using payload param name: " + this.payloadParameterName));
        }
        this.muleContext = this.setupMuleContext();
        this.setupResponseTransformer();
        this.doInit();
    }

    protected MuleContext setupMuleContext() throws ServletException {
        MuleContext context = (MuleContext)this.getServletContext().getAttribute("mule.context");
        if (context == null) {
            throw new ServletException("Property mule.context not set on ServletContext");
        }
        return context;
    }

    protected void setupResponseTransformer() throws ServletException {
        this.responseTransformer.setMuleContext(this.muleContext);
        try {
            this.responseTransformer.initialise();
        }
        catch (InitialisationException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doInit() throws ServletException {
    }

    protected void writeResponse(HttpServletResponse servletResponse, MuleMessage message) throws Exception {
        if (message == null) {
            this.writeEmptyResponse(servletResponse);
        } else {
            this.writeResponseFromMessage(servletResponse, message);
        }
        servletResponse.flushBuffer();
    }

    protected void writeEmptyResponse(HttpServletResponse servletResponse) throws IOException {
        servletResponse.setStatus(204);
        if (this.feedback) {
            servletResponse.setStatus(200);
            servletResponse.getWriter().write("Action was processed successfully. There was no result");
        }
    }

    protected void writeResponseFromMessage(HttpServletResponse servletResponse, MuleMessage message) throws Exception {
        HttpResponse httpResponse = this.convertToHttpResponse(message);
        this.setHttpHeadersOnServletResponse(httpResponse, servletResponse);
        if (!servletResponse.isCommitted()) {
            servletResponse.setStatus(httpResponse.getStatusCode());
        }
        if (httpResponse.hasBody()) {
            OutputHandler outputHandler = httpResponse.getBody();
            outputHandler.write(RequestContext.getEvent(), (OutputStream)servletResponse.getOutputStream());
        }
    }

    protected HttpResponse convertToHttpResponse(MuleMessage message) throws TransformerException {
        if (message.getPayload() instanceof HttpResponse) {
            return (HttpResponse)message.getPayload();
        }
        return (HttpResponse)this.responseTransformer.transform((Object)message);
    }

    protected HttpServletResponse setHttpHeadersOnServletResponse(HttpResponse httpResponse, HttpServletResponse servletResponse) {
        Header[] headers;
        httpResponse.removeHeaders("Transfer-Encoding");
        for (Header header : headers = httpResponse.getHeaders()) {
            servletResponse.addHeader(header.getName(), header.getValue());
        }
        this.ensureContentTypeHeaderIsSet(servletResponse, httpResponse);
        return servletResponse;
    }

    protected void ensureContentTypeHeaderIsSet(HttpServletResponse servletResponse, HttpResponse httpResponse) {
        Header contentTypeHeader = httpResponse.getFirstHeader("Content-Type");
        String contentType = this.defaultContentType;
        if (this.contentTypeHeaderIsValid(contentTypeHeader)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using Content-Type from message header = " + contentTypeHeader.getValue()));
            }
            contentType = contentTypeHeader.getValue();
        }
        servletResponse.setContentType(contentType);
    }

    protected boolean contentTypeHeaderIsValid(Header header) {
        return header != null && header.getValue() != null;
    }

    protected void handleException(Throwable exception, String message, HttpServletResponse response) {
        this.logger.error((Object)("message: " + exception.getMessage()), exception);
        int code = Integer.valueOf(ExceptionHelper.getErrorMapping((String)"http", exception.getClass()));
        response.setStatus(code);
        try {
            response.sendError(code, message + ": " + exception.getMessage());
        }
        catch (IOException e) {
            this.logger.error((Object)("Failed to sendError on response: " + e.getMessage()), (Throwable)e);
        }
    }
}

