/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.protocol.Protocol;

public class MuleHostConfiguration
extends HostConfiguration {
    public MuleHostConfiguration() {
    }

    public MuleHostConfiguration(HostConfiguration hostConfig) {
        super(hostConfig);
    }

    public synchronized void setHost(URI uri) {
        try {
            Protocol original = this.getProtocol();
            if (uri.getScheme().equals(original.getScheme())) {
                Protocol newProtocol = new Protocol(uri.getScheme(), original.getSocketFactory(), original.getDefaultPort());
                super.setHost(uri.getHost(), uri.getPort(), newProtocol);
            } else {
                Protocol protoByName = Protocol.getProtocol((String)uri.getScheme());
                super.setHost(uri.getHost(), uri.getPort(), protoByName);
            }
        }
        catch (URIException uriException) {
            throw new IllegalArgumentException(uriException);
        }
    }

    public synchronized void setHost(HttpHost host) {
        Protocol newProtocol = this.cloneProtocolKeepingSocketFactory(host.getProtocol());
        HttpHost hostCopy = new HttpHost(host.getHostName(), host.getPort(), newProtocol);
        super.setHost(hostCopy);
    }

    public synchronized void setHost(String host, int port, String protocolName) {
        Protocol protoByName = Protocol.getProtocol((String)protocolName);
        Protocol newProtocol = this.cloneProtocolKeepingSocketFactory(protoByName);
        super.setHost(host, port, newProtocol);
    }

    public synchronized void setHost(String host, String virtualHost, int port, Protocol protocol) {
        Protocol newProtocol = this.cloneProtocolKeepingSocketFactory(protocol);
        super.setHost(host, virtualHost, port, newProtocol);
    }

    public synchronized void setHost(String host, int port) {
        super.setHost(host, port, this.getProtocol());
    }

    public synchronized void setHost(String host) {
        super.setHost(host, this.getPort(), this.getProtocol());
    }

    private Protocol cloneProtocolKeepingSocketFactory(Protocol protocol) {
        Protocol original = this.getProtocol();
        if (protocol.getScheme().equals(original.getScheme())) {
            return new Protocol(protocol.getScheme(), original.getSocketFactory(), protocol.getDefaultPort());
        }
        return protocol;
    }

    public Object clone() {
        return new MuleHostConfiguration(this);
    }
}

