/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.transformers;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.net.URLCodec;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.StringUtils;

public class HttpRequestBodyToParamMap
extends AbstractMessageTransformer {
    public HttpRequestBodyToParamMap() {
        this.registerSourceType(DataTypeFactory.OBJECT);
        this.setReturnDataType(DataTypeFactory.OBJECT);
    }

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            String httpMethod = (String)message.getInboundProperty("http.method");
            String contentType = (String)message.getInboundProperty("Content-Type");
            boolean isGet = "GET".equalsIgnoreCase(httpMethod);
            boolean isPost = "POST".equalsIgnoreCase(httpMethod);
            boolean isUrlEncoded = false;
            if (contentType != null) {
                isUrlEncoded = contentType.startsWith("application/x-www-form-urlencoded");
            }
            if (!(isGet || isPost && isUrlEncoded)) {
                throw new Exception("The HTTP method or content type is unsupported!");
            }
            String queryString = null;
            if (isGet) {
                URI uri = new URI(message.getPayloadAsString(outputEncoding));
                queryString = uri.getRawQuery();
            } else if (isPost) {
                queryString = new String(message.getPayloadAsBytes());
            }
            if (StringUtils.isNotBlank(queryString)) {
                this.addQueryStringToParameterMap(queryString, paramMap, outputEncoding);
            }
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
        return paramMap;
    }

    protected void addQueryStringToParameterMap(String queryString, Map<String, Object> paramMap, String outputEncoding) throws Exception {
        String[] pairs;
        for (String pair : pairs = queryString.split("&")) {
            String[] nameValue = pair.split("=");
            if (nameValue.length != 2) continue;
            URLCodec codec = new URLCodec(outputEncoding);
            String key = codec.decode(nameValue[0]);
            String value = codec.decode(nameValue[1]);
            this.addToParameterMap(paramMap, key, value);
        }
    }

    protected void addToParameterMap(Map<String, Object> paramMap, String key, String value) {
        Object existingValue = paramMap.get(key);
        if (existingValue != null) {
            ArrayList<Object> values;
            if (existingValue instanceof List) {
                values = (ArrayList<Object>)existingValue;
            } else {
                values = new ArrayList<Object>();
                values.add(existingValue);
            }
            values.add(value);
            paramMap.put(key, values);
        } else {
            paramMap.put(key, value);
        }
    }

    public boolean isAcceptNull() {
        return false;
    }
}

