/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.component.InterfaceBinding;
import org.mule.api.component.JavaComponent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.model.Model;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.exception.AbstractExceptionListener;
import org.mule.model.resolvers.LegacyEntryPointResolverSet;
import org.mule.routing.ForwardingCatchAllStrategy;
import org.mule.routing.filters.MessagePropertyFilter;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.service.ServiceAsyncReplyCompositeMessageSource;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.testmodels.fruit.FruitCleaner;
import org.mule.tck.testmodels.mule.TestCompressionTransformer;
import org.mule.tck.testmodels.mule.TestEntryPointResolverSet;
import org.mule.tck.testmodels.mule.TestExceptionStrategy;
import org.mule.tck.testmodels.mule.TestResponseAggregator;
import org.mule.transformer.TransformerUtils;
import org.mule.transformer.types.DataTypeFactory;

public abstract class AbstractScriptConfigBuilderTestCase
extends FunctionalTestCase {
    private boolean legacy;

    protected AbstractScriptConfigBuilderTestCase() {
        this(false);
    }

    protected AbstractScriptConfigBuilderTestCase(boolean legacy) {
        this.legacy = legacy;
    }

    @Test
    public void testManagerConfig() throws Exception {
        Assert.assertEquals((Object)"true", (Object)muleContext.getRegistry().lookupObject("doCompression"));
        Assert.assertNotNull((Object)muleContext.getTransactionManager());
    }

    @Test
    public void testConnectorConfig() throws Exception {
        MessagingExceptionHandler es = muleContext.getRegistry().lookupModel("main").getExceptionListener();
        Assert.assertNotNull((Object)es);
        Assert.assertTrue((String)es.getClass().getName(), (boolean)(es instanceof TestExceptionStrategy));
    }

    @Test
    public void testGlobalEndpointConfig() throws MuleException {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("fruitBowlEndpoint");
        Assert.assertNotNull((Object)endpoint);
        Assert.assertEquals((Object)endpoint.getEndpointURI().getAddress(), (Object)"fruitBowlPublishQ");
        MessagePropertyFilter filter = (MessagePropertyFilter)endpoint.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertEquals((Object)"foo=bar", (Object)filter.getPattern());
        InboundEndpoint ep = muleContext.getEndpointFactory().getInboundEndpoint("testEPWithCS");
        Assert.assertNotNull((Object)ep);
    }

    @Test
    public void testEndpointConfig() throws MuleException {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("waterMelonEndpoint");
        Assert.assertNotNull((Object)endpoint);
        Assert.assertEquals((Object)"test.queue", (Object)endpoint.getEndpointURI().getAddress());
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        InboundEndpoint ep = ((ServiceCompositeMessageSource)service.getMessageSource()).getEndpoint("Orange");
        Assert.assertNotNull((Object)ep);
        List responseTransformers = ep.getResponseTransformers();
        Assert.assertNotNull((Object)responseTransformers);
        Assert.assertFalse((boolean)responseTransformers.isEmpty());
        Object responseTransformer = responseTransformers.get(0);
        Assert.assertTrue((boolean)(responseTransformer instanceof TestCompressionTransformer));
    }

    @Test
    public void testExceptionStrategy() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        Assert.assertNotNull((Object)muleContext.getRegistry().lookupModel("main").getExceptionListener());
        Assert.assertNotNull((Object)service.getExceptionListener());
        Assert.assertTrue((((AbstractExceptionListener)service.getExceptionListener()).getMessageProcessors().size() > 0 ? 1 : 0) != 0);
        OutboundEndpoint ep = (OutboundEndpoint)((AbstractExceptionListener)service.getExceptionListener()).getMessageProcessors().get(0);
        Assert.assertEquals((Object)"test://orange.exceptions", (Object)ep.getEndpointURI().toString());
    }

    @Test
    public void testTransformerConfig() {
        Transformer t = muleContext.getRegistry().lookupTransformer("TestCompressionTransformer");
        Assert.assertNotNull((Object)t);
        Assert.assertTrue((boolean)(t instanceof TestCompressionTransformer));
        Assert.assertEquals((Object)t.getReturnDataType(), (Object)DataTypeFactory.STRING);
        Assert.assertNotNull((Object)((TestCompressionTransformer)t).getContainerProperty());
    }

    @Test
    public void testModelConfig() throws Exception {
        Model model = muleContext.getRegistry().lookupModel("main");
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((Object)"main", (Object)model.getName());
        if (this.legacy) {
            Assert.assertTrue((boolean)(model.getEntryPointResolverSet() instanceof LegacyEntryPointResolverSet));
        } else {
            Assert.assertTrue((boolean)(model.getEntryPointResolverSet() instanceof TestEntryPointResolverSet));
        }
        Assert.assertTrue((boolean)(model.getExceptionListener() instanceof TestExceptionStrategy));
        Assert.assertTrue((((AbstractExceptionListener)model.getExceptionListener()).getMessageProcessors().size() > 0 ? 1 : 0) != 0);
        OutboundEndpoint ep = (OutboundEndpoint)((AbstractExceptionListener)model.getExceptionListener()).getMessageProcessors().get(0);
        Assert.assertEquals((Object)"test://component.exceptions", (Object)ep.getEndpointURI().toString());
    }

    @Test
    public void testEndpointPropertiesConfig() throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("endpointWithProps");
        Map props = endpoint.getProperties();
        Assert.assertNotNull((Object)props);
        Assert.assertEquals((Object)"9", props.get("segments"));
        Assert.assertEquals((Object)"4.21", props.get("radius"));
        Assert.assertEquals((Object)"Juicy Baby!", props.get("brand"));
        Assert.assertNotNull(props.get("listProperties"));
        List list = (List)props.get("listProperties");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"prop1", list.get(0));
        Assert.assertEquals((Object)"prop2", list.get(1));
        Assert.assertEquals((Object)"prop3", list.get(2));
        Assert.assertNotNull(props.get("arrayProperties"));
        list = (List)props.get("arrayProperties");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"prop4", list.get(0));
        Assert.assertEquals((Object)"prop5", list.get(1));
        Assert.assertEquals((Object)"prop6", list.get(2));
        Assert.assertNotNull(props.get("mapProperties"));
        props = (Map)props.get("mapProperties");
        Assert.assertEquals((Object)"prop1", props.get("prop1"));
        Assert.assertEquals((Object)"prop2", props.get("prop2"));
        Assert.assertEquals((long)6L, (long)endpoint.getProperties().size());
    }

    @Test
    public void testOutboundRouterConfig() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        Assert.assertNotNull((Object)service.getOutboundMessageProcessor());
        OutboundRouterCollection router = (OutboundRouterCollection)service.getOutboundMessageProcessor();
        Assert.assertNull((Object)router.getCatchAllStrategy());
        Assert.assertEquals((long)1L, (long)router.getRoutes().size());
        OutboundRouter route1 = (OutboundRouter)router.getRoutes().get(0);
        Assert.assertTrue((boolean)(route1 instanceof OutboundPassThroughRouter));
        Assert.assertEquals((long)1L, (long)route1.getRoutes().size());
    }

    @Test
    public void testBindingConfig() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        Assert.assertNotNull((Object)service.getComponent());
        Assert.assertTrue((boolean)(service.getComponent() instanceof JavaComponent));
        List bindings = ((JavaComponent)service.getComponent()).getInterfaceBindings();
        Assert.assertNotNull((Object)bindings);
        Assert.assertEquals((long)2L, (long)bindings.size());
        InterfaceBinding route1 = (InterfaceBinding)bindings.get(0);
        Assert.assertEquals(FruitCleaner.class, (Object)route1.getInterface());
        Assert.assertEquals((Object)"wash", (Object)route1.getMethod());
        Assert.assertNotNull((Object)route1.getEndpoint());
        InterfaceBinding route2 = (InterfaceBinding)bindings.get(1);
        Assert.assertEquals(FruitCleaner.class, (Object)route2.getInterface());
        Assert.assertEquals((Object)"polish", (Object)route2.getMethod());
        Assert.assertNotNull((Object)route1.getEndpoint());
    }

    @Test
    public void testDescriptorEndpoints() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        Assert.assertEquals((long)1L, (long)((OutboundRouterCollection)service.getOutboundMessageProcessor()).getRoutes().size());
        OutboundRouter router = (OutboundRouter)((OutboundRouterCollection)service.getOutboundMessageProcessor()).getRoutes().get(0);
        Assert.assertEquals((long)1L, (long)router.getRoutes().size());
        MessageProcessor mp = (MessageProcessor)router.getRoutes().get(0);
        Assert.assertNotNull((Object)mp);
        Assert.assertTrue((boolean)(mp instanceof ImmutableEndpoint));
        ImmutableEndpoint endpoint = (ImmutableEndpoint)mp;
        Assert.assertNotNull((Object)endpoint);
        Assert.assertEquals((Object)"appleInEndpoint", (Object)endpoint.getName());
        Assert.assertNotNull((Object)endpoint.getTransformers());
        Assert.assertTrue((boolean)(TransformerUtils.firstOrNull((List)endpoint.getTransformers()) instanceof TestCompressionTransformer));
        Assert.assertEquals((long)2L, (long)((ServiceCompositeMessageSource)service.getMessageSource()).getEndpoints().size());
        Assert.assertNotNull((Object)((ServiceCompositeMessageSource)service.getMessageSource()).getCatchAllStrategy());
        Assert.assertTrue((boolean)(((ServiceCompositeMessageSource)service.getMessageSource()).getCatchAllStrategy() instanceof ForwardingCatchAllStrategy));
        ForwardingCatchAllStrategy fcas = (ForwardingCatchAllStrategy)((ServiceCompositeMessageSource)service.getMessageSource()).getCatchAllStrategy();
        Assert.assertNotNull((Object)fcas.getEndpoint());
        Assert.assertEquals((Object)"test://catch.all", (Object)fcas.getEndpoint().getEndpointURI().toString());
        endpoint = ((ServiceCompositeMessageSource)service.getMessageSource()).getEndpoint("orangeEndpoint");
        Assert.assertNotNull((Object)endpoint);
        Assert.assertEquals((Object)"orangeEndpoint", (Object)endpoint.getName());
        Assert.assertEquals((Object)"orangeQ", (Object)endpoint.getEndpointURI().getAddress());
        Assert.assertNotNull((Object)endpoint.getTransformers());
        Assert.assertTrue((boolean)(TransformerUtils.firstOrNull((List)endpoint.getTransformers()) instanceof TestCompressionTransformer));
    }

    @Test
    public void testInboundRouterConfig() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        Assert.assertNotNull((Object)service.getMessageSource());
        ServiceCompositeMessageSource messageRouter = (ServiceCompositeMessageSource)service.getMessageSource();
        Assert.assertNotNull((Object)messageRouter.getCatchAllStrategy());
        Assert.assertEquals((long)0L, (long)messageRouter.getMessageProcessors().size());
        Assert.assertTrue((boolean)(messageRouter.getCatchAllStrategy() instanceof ForwardingCatchAllStrategy));
        Assert.assertEquals((long)2L, (long)messageRouter.getEndpoints().size());
    }

    @Test
    public void testResponseRouterConfig() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        Assert.assertNotNull((Object)service.getAsyncReplyMessageSource());
        ServiceAsyncReplyCompositeMessageSource messageRouter = service.getAsyncReplyMessageSource();
        Assert.assertNull((Object)messageRouter.getCatchAllStrategy());
        Assert.assertEquals((long)10001L, (long)messageRouter.getTimeout());
        Assert.assertEquals((long)1L, (long)messageRouter.getMessageProcessors().size());
        MessageProcessor router = (MessageProcessor)messageRouter.getMessageProcessors().get(0);
        Assert.assertTrue((boolean)(router instanceof TestResponseAggregator));
        Assert.assertNotNull((Object)messageRouter.getEndpoints());
        Assert.assertEquals((long)2L, (long)messageRouter.getEndpoints().size());
        InboundEndpoint ep = (InboundEndpoint)messageRouter.getEndpoints().get(0);
        Assert.assertEquals((Object)"response1", (Object)ep.getEndpointURI().getAddress());
        ep = (InboundEndpoint)messageRouter.getEndpoints().get(1);
        Assert.assertEquals((Object)"AppleResponseQueue", (Object)ep.getEndpointURI().getAddress());
    }
}

