/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.filters;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.api.routing.filter.Filter;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.xml.filters.AbstractJaxpFilter;
import org.mule.module.xml.util.NamespaceManager;
import org.mule.util.ClassUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathFilter
extends AbstractJaxpFilter
implements Filter,
Initialisable,
MuleContextAware {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String pattern;
    private String expectedValue;
    private XPath xpath;
    private Map<String, String> prefixToNamespaceMap = null;
    private NamespaceManager namespaceManager;
    private MuleContext muleContext;

    public XPathFilter() {
    }

    public XPathFilter(String pattern) {
        this.pattern = pattern;
    }

    public XPathFilter(String pattern, String expectedValue) {
        this.pattern = pattern;
        this.expectedValue = expectedValue;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void initialise() throws InitialisationException {
        Map<String, String> prefixToNamespaceMap;
        super.initialise();
        if (this.getXpath() == null) {
            this.setXpath(XPathFactory.newInstance().newXPath());
        }
        if (this.pattern == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)("A pattern must be supplied to the " + ClassUtils.getSimpleName(this.getClass()))), (Initialisable)this);
        }
        if (this.muleContext != null) {
            try {
                this.namespaceManager = (NamespaceManager)this.muleContext.getRegistry().lookupObject(NamespaceManager.class);
            }
            catch (RegistrationException e) {
                throw new ExpressionRuntimeException(CoreMessages.failedToLoad((String)"NamespaceManager"), (Throwable)e);
            }
            if (this.namespaceManager != null) {
                if (this.prefixToNamespaceMap == null) {
                    this.prefixToNamespaceMap = new HashMap<String, String>(this.namespaceManager.getNamespaces());
                } else {
                    this.prefixToNamespaceMap.putAll(this.namespaceManager.getNamespaces());
                }
            }
        }
        if ((prefixToNamespaceMap = this.prefixToNamespaceMap) != null) {
            this.getXpath().setNamespaceContext(new NamespaceContext(){

                public String getNamespaceURI(String prefix) {
                    return (String)prefixToNamespaceMap.get(prefix);
                }

                public String getPrefix(String namespaceURI) {
                    for (Map.Entry entry : prefixToNamespaceMap.entrySet()) {
                        if (!namespaceURI.equals(entry.getValue())) continue;
                        return (String)entry.getKey();
                    }
                    return null;
                }

                public Iterator getPrefixes(String namespaceURI) {
                    String prefix = this.getPrefix(namespaceURI);
                    if (prefix == null) {
                        return Collections.emptyList().iterator();
                    }
                    return Arrays.asList(prefix).iterator();
                }
            });
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("XPath implementation: " + this.getXpath()));
            this.logger.info((Object)("DocumentBuilderFactory implementation: " + this.getDocumentBuilderFactory()));
        }
    }

    public boolean accept(MuleMessage message) {
        Node node;
        Object payload = message.getPayload();
        if (payload == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Applying " + ClassUtils.getSimpleName(this.getClass()) + " to null object."));
            }
            return false;
        }
        if (this.pattern == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Expression for " + ClassUtils.getSimpleName(this.getClass()) + " is not set."));
            }
            return false;
        }
        if (this.expectedValue == null) {
            if (this.pattern.endsWith("= null") || this.pattern.endsWith("=null")) {
                this.expectedValue = "null";
                this.pattern = this.pattern.substring(0, this.pattern.lastIndexOf("="));
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("''expectedValue'' attribute for " + ClassUtils.getSimpleName(this.getClass()) + " is not set, using 'true' by default"));
                }
                this.expectedValue = Boolean.TRUE.toString();
            }
        }
        try {
            node = this.toDOMNode(payload);
        }
        catch (Exception e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)(ClassUtils.getSimpleName(this.getClass()) + " filter rejected message because of an error while parsing XML: " + e.getMessage()), (Throwable)e);
            }
            return false;
        }
        message.setPayload((Object)node);
        return this.accept(node);
    }

    protected boolean accept(Node node) {
        Object xpathResult;
        boolean accept = false;
        try {
            xpathResult = this.getXpath().evaluate(this.pattern, node, XPathConstants.STRING);
        }
        catch (Exception e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)(ClassUtils.getSimpleName(this.getClass()) + " filter rejected message because of an error while evaluating the expression: " + e.getMessage()), (Throwable)e);
            }
            return false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)MessageFormat.format("{0} Expression result = ''{1}'' -  Expected value = ''{2}''", ClassUtils.getSimpleName(this.getClass()), xpathResult, this.expectedValue));
        }
        if (xpathResult != null && !"".equals(xpathResult)) {
            accept = xpathResult.toString().equals(this.expectedValue);
        } else if ("null".equals(this.expectedValue)) {
            accept = true;
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)MessageFormat.format("{0} expression evaluates to null: {1}", ClassUtils.getSimpleName(this.getClass()), this.pattern));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)MessageFormat.format("{0} accept object  : {1}", ClassUtils.getSimpleName(this.getClass()), accept));
        }
        return accept;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getExpectedValue() {
        return this.expectedValue;
    }

    public void setExpectedValue(String expectedValue) {
        this.expectedValue = expectedValue;
    }

    public XPath getXpath() {
        return this.xpath;
    }

    public void setXpath(XPath xpath) {
        this.xpath = xpath;
    }

    public Map<String, String> getNamespaces() {
        return this.prefixToNamespaceMap;
    }

    public void setNamespaces(Map<String, String> prefixToNamespaceMap) {
        this.prefixToNamespaceMap = prefixToNamespaceMap;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        XPathFilter other = (XPathFilter)obj;
        return ClassUtils.equal((Object)this.expectedValue, (Object)other.expectedValue) && ClassUtils.equal(this.prefixToNamespaceMap, other.prefixToNamespaceMap) && ClassUtils.equal((Object)this.pattern, (Object)other.pattern);
    }

    public int hashCode() {
        return ClassUtils.hash((Object[])new Object[]{this.getClass(), this.expectedValue, this.prefixToNamespaceMap, this.pattern});
    }
}

