/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.plugin.AbstractJetty6Mojo;
import org.mortbay.jetty.plugin.util.Scanner;
import org.mortbay.jetty.security.UserRealm;

public class Jetty6RunWarExploded
extends AbstractJetty6Mojo {
    private Connector[] connectors;
    private File webApp;
    private UserRealm[] userRealms;

    public Object[] getConfiguredUserRealms() {
        return this.userRealms;
    }

    public Object[] getConfiguredConnectors() {
        return this.connectors;
    }

    public void checkPomConfiguration() throws MojoExecutionException {
    }

    public void configureScanner() throws MojoExecutionException {
        File jettyEnvXmlFile;
        ArrayList<File> scanList = new ArrayList<File>();
        scanList.add(this.getProject().getFile());
        File webInfDir = new File(this.webApp, "WEB-INF");
        scanList.add(new File(webInfDir, "web.xml"));
        File jettyWebXmlFile = this.findJettyWebXmlFile(webInfDir);
        if (jettyWebXmlFile != null) {
            scanList.add(jettyWebXmlFile);
        }
        if ((jettyEnvXmlFile = new File(webInfDir, "jetty-env.xml")).exists()) {
            scanList.add(jettyEnvXmlFile);
        }
        scanList.add(new File(webInfDir, "classes"));
        scanList.add(new File(webInfDir, "lib"));
        this.setScanList(scanList);
        ArrayList<1> listeners = new ArrayList<1>();
        listeners.add(new Scanner.Listener(){

            public void changesDetected(Scanner scanner, List changes) {
                try {
                    Jetty6RunWarExploded.this.getLog().info((CharSequence)"Restarting webapp");
                    Jetty6RunWarExploded.this.getLog().debug((CharSequence)"Stopping webapp ...");
                    Jetty6RunWarExploded.this.getWebApplication().stop();
                    Jetty6RunWarExploded.this.getLog().debug((CharSequence)"Reconfiguring webapp ...");
                    Jetty6RunWarExploded.this.checkPomConfiguration();
                    if (changes.contains(Jetty6RunWarExploded.this.getProject().getFile().getCanonicalPath())) {
                        File jettyEnvXmlFile;
                        Jetty6RunWarExploded.this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
                        ArrayList scanList = Jetty6RunWarExploded.this.getScanList();
                        scanList.clear();
                        scanList.add(Jetty6RunWarExploded.this.getProject().getFile());
                        File webInfDir = new File(Jetty6RunWarExploded.this.webApp, "WEB-INF");
                        scanList.add(new File(webInfDir, "web.xml"));
                        File jettyWebXmlFile = Jetty6RunWarExploded.this.findJettyWebXmlFile(webInfDir);
                        if (jettyWebXmlFile != null) {
                            scanList.add(jettyWebXmlFile);
                        }
                        if ((jettyEnvXmlFile = new File(webInfDir, "jetty-env.xml")).exists()) {
                            scanList.add(jettyEnvXmlFile);
                        }
                        scanList.add(new File(webInfDir, "classes"));
                        scanList.add(new File(webInfDir, "lib"));
                        Jetty6RunWarExploded.this.setScanList(scanList);
                        scanner.setRoots(scanList);
                    }
                    Jetty6RunWarExploded.this.getLog().debug((CharSequence)"Restarting webapp ...");
                    Jetty6RunWarExploded.this.getWebApplication().start();
                    Jetty6RunWarExploded.this.getLog().info((CharSequence)"Restart completed.");
                }
                catch (Exception e) {
                    Jetty6RunWarExploded.this.getLog().error((CharSequence)"Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                }
            }
        });
        this.setScannerListeners(listeners);
    }

    public void finishConfigurationBeforeStart() throws Exception {
    }

    public void configureWebApplication() throws Exception {
        super.configureWebApplication();
        this.getWebApplication().setWebAppSrcDir(this.webApp);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
    }
}

