/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.util.logging.Level;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class JavaUtilLog
implements Logger {
    private java.util.logging.Logger _logger;

    public JavaUtilLog() {
        this("org.eclipse.jetty.util.log");
    }

    public JavaUtilLog(String name) {
        this._logger = java.util.logging.Logger.getLogger(name);
        if (Boolean.getBoolean("org.eclipse.jetty.util.log.DEBUG")) {
            this._logger.setLevel(Level.FINE);
        }
    }

    @Override
    public String getName() {
        return this._logger.getName();
    }

    @Override
    public void warn(String msg, Object ... args) {
        this._logger.log(Level.WARNING, this.format(msg, args));
    }

    @Override
    public void warn(Throwable thrown) {
        this.warn("", thrown);
    }

    @Override
    public void warn(String msg, Throwable thrown) {
        this._logger.log(Level.WARNING, msg, thrown);
    }

    @Override
    public void info(String msg, Object ... args) {
        this._logger.log(Level.INFO, this.format(msg, args));
    }

    @Override
    public void info(Throwable thrown) {
        this.info("", thrown);
    }

    @Override
    public void info(String msg, Throwable thrown) {
        this._logger.log(Level.INFO, msg, thrown);
    }

    @Override
    public boolean isDebugEnabled() {
        return this._logger.isLoggable(Level.FINE);
    }

    @Override
    public void setDebugEnabled(boolean enabled) {
        this._logger.setLevel(Level.FINE);
    }

    @Override
    public void debug(String msg, Object ... args) {
        this._logger.log(Level.FINE, this.format(msg, args));
    }

    @Override
    public void debug(Throwable thrown) {
        this.debug("", thrown);
    }

    @Override
    public void debug(String msg, Throwable thrown) {
        this._logger.log(Level.FINE, msg, thrown);
    }

    @Override
    public Logger getLogger(String name) {
        return new JavaUtilLog(name);
    }

    @Override
    public void ignore(Throwable ignored) {
        if (Log.isIgnored()) {
            this.warn("IGNORED ", ignored);
        }
    }

    private String format(String msg, Object ... args) {
        msg = String.valueOf(msg);
        String braces = "{}";
        StringBuilder builder = new StringBuilder();
        int start = 0;
        for (Object arg : args) {
            int bracesIndex = msg.indexOf(braces, start);
            if (bracesIndex < 0) {
                builder.append(msg.substring(start));
                builder.append(" ");
                builder.append(arg);
                start = msg.length();
                continue;
            }
            builder.append(msg.substring(start, bracesIndex));
            builder.append(String.valueOf(arg));
            start = bracesIndex + braces.length();
        }
        builder.append(msg.substring(start));
        return builder.toString();
    }
}

