/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd.continuation;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Queue;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.AbstractCometdServlet;
import org.mortbay.cometd.ClientImpl;
import org.mortbay.cometd.Transport;
import org.mortbay.cometd.continuation.ContinuationBayeux;
import org.mortbay.cometd.continuation.ContinuationClient;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;
import org.mortbay.util.ajax.JSON;

public class ContinuationCometdServlet
extends AbstractCometdServlet {
    protected AbstractBayeux newBayeux() {
        return new ContinuationBayeux();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object clientObj = req.getAttribute("org.mortbay.cometd.client");
        ContinuationClient client = clientObj instanceof ClientImpl ? (ContinuationClient)clientObj : null;
        Transport transport = null;
        boolean reconnect = false;
        if (client != null) {
            if (this._bayeux.isLogDebug()) {
                this._bayeux.logDebug("doPost: client seen before: " + client);
            }
            transport = (Transport)req.getAttribute("org.mortbay.cometd.transport");
            transport.setResponse(resp);
        } else {
            String[] batches = null;
            int batch_index = 0;
            Object batch = null;
            int index = 0;
            Map message = null;
            int message_count = 0;
            batches = req.getParameterValues("message");
            String jsonpParam = req.getParameter("jsonp");
            if (jsonpParam != null && this._bayeux.isLogDebug()) {
                this._bayeux.logDebug("doPost: jsonp=" + jsonpParam);
            }
            while (batches != null && batch_index < batches.length) {
                if (batch == null) {
                    index = 0;
                    batch = JSON.parse((String)batches[batch_index++], (boolean)this._bayeux.isJSONCommented());
                }
                if (batch == null) continue;
                if (batch.getClass().isArray()) {
                    message = (Map)Array.get(batch, index++);
                    if (index >= Array.getLength(batch)) {
                        batch = null;
                    }
                } else {
                    message = (Map)batch;
                    batch = null;
                }
                ++message_count;
                if (jsonpParam != null) {
                    message.put("jsonp", jsonpParam);
                }
                if ((client = (ContinuationClient)this._bayeux.getClient((String)message.get("clientId"))) != null) break;
                String browser_id = this.browserId(req);
                if (browser_id == null) {
                    browser_id = this.newBrowserId(req, resp);
                }
                transport = this._bayeux.newTransport(client, message);
                transport.setResponse(resp);
                this._bayeux.handle(null, transport, message);
                message = null;
                break;
            }
            if (client != null) {
                client.access();
                client.setBrowserId(this.browserId(req));
                transport = this._bayeux.newTransport(client, message);
                transport.setResponse(resp);
                try {
                    String channel;
                    client.responsePending();
                    if (message != null) {
                        channel = this._bayeux.handle(client, transport, message);
                        reconnect |= "/meta/reconnect".equals(channel);
                    }
                    message = null;
                    while (batches != null && batch_index < batches.length) {
                        if (batch == null) {
                            index = 0;
                            batch = JSON.parse((String)batches[batch_index++], (boolean)this._bayeux.isJSONCommented());
                        }
                        if (batch == null) continue;
                        if (batch.getClass().isArray()) {
                            message = (Map)Array.get(batch, index++);
                            if (index >= Array.getLength(batch)) {
                                batch = null;
                            }
                        } else {
                            message = (Map)batch;
                            batch = null;
                        }
                        if (message != null) {
                            channel = this._bayeux.handle(client, transport, message);
                            reconnect |= "/meta/reconnect".equals(channel);
                        }
                        message = null;
                    }
                }
                finally {
                    client.responded();
                }
            }
        }
        while (transport.isPolling()) {
            if (this._bayeux.isLogDebug()) {
                this._bayeux.logDebug("doPost: transport is polling");
            }
            long timeout = this._timeout;
            Continuation continuation = ContinuationSupport.getContinuation((HttpServletRequest)req, (Object)client);
            if (!continuation.isPending()) {
                client.access();
            }
            Queue<Map<String, Object>> messages = null;
            ContinuationClient continuationClient = client;
            synchronized (continuationClient) {
                messages = client.takeMessages();
                if (!(messages != null && messages.size() != 0 || continuation.isPending())) {
                    client.setContinuation(continuation);
                    req.setAttribute("org.mortbay.cometd.client", (Object)client);
                    req.setAttribute("org.mortbay.cometd.transport", (Object)transport);
                    if (this._bayeux.isLogDebug()) {
                        this._bayeux.logDebug("doPost: setting transport for request: " + transport);
                    }
                    continuation.suspend(timeout);
                    messages = client.takeMessages();
                }
                continuation.reset();
                client.setContinuation(null);
                if (messages == null) {
                    transport.setPolling(false);
                }
            }
            if (messages != null) {
                transport.send(messages);
            }
            if (transport.keepAlive()) continue;
            transport.setPolling(false);
        }
        if (client != null) {
            Queue<Map<String, Object>> messages;
            if (reconnect) {
                client.onBrowser(null);
            }
            if ((messages = client.takeMessages()) != null) {
                transport.send(messages);
            }
        }
        transport.complete();
    }
}

