/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import dojox.cometd.Bayeux;
import dojox.cometd.Channel;
import dojox.cometd.Client;
import dojox.cometd.DataFilter;
import dojox.cometd.Listener;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.mortbay.cometd.ChannelId;
import org.mortbay.cometd.ChannelImpl;
import org.mortbay.cometd.ClientImpl;
import org.mortbay.cometd.JSONPTransport;
import org.mortbay.cometd.JSONTransport;
import org.mortbay.cometd.SecurityPolicy;
import org.mortbay.cometd.Transport;
import org.mortbay.util.DateCache;
import org.mortbay.util.ajax.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBayeux
implements Bayeux {
    public static final String META = "/meta/";
    public static final String META_CONNECT = "/meta/connect";
    public static final String META_DISCONNECT = "/meta/disconnect";
    public static final String META_HANDSHAKE = "/meta/handshake";
    public static final String META_PING = "/meta/ping";
    public static final String META_RECONNECT = "/meta/reconnect";
    public static final String META_STATUS = "/meta/status";
    public static final String META_SUBSCRIBE = "/meta/subscribe";
    public static final String META_UNSUBSCRIBE = "/meta/unsubscribe";
    public static final String CLIENT_FIELD = "clientId";
    public static final String DATA_FIELD = "data";
    public static final String CHANNEL_FIELD = "channel";
    public static final String ID_FIELD = "id";
    public static final String TIMESTAMP_FIELD = "timestamp";
    public static final String TRANSPORT_FIELD = "transport";
    public static final String ADVICE_FIELD = "advice";
    public static final String SUCCESSFUL_FIELD = "successful";
    public static final String SUBSCRIPTION_FIELD = "subscription";
    public static final String EXT_FIELD = "ext";
    public static final ChannelId META_CONNECT_ID = new ChannelId("/meta/connect");
    public static final ChannelId META_DISCONNECT_ID = new ChannelId("/meta/disconnect");
    public static final ChannelId META_HANDSHAKE_ID = new ChannelId("/meta/handshake");
    public static final ChannelId META_PING_ID = new ChannelId("/meta/ping");
    public static final ChannelId META_RECONNECT_ID = new ChannelId("/meta/reconnect");
    public static final ChannelId META_STATUS_ID = new ChannelId("/meta/status");
    public static final ChannelId META_SUBSCRIBE_ID = new ChannelId("/meta/subscribe");
    public static final ChannelId META_UNSUBSCRIBE_ID = new ChannelId("/meta/unsubscribe");
    public static final JSON.Literal TRANSPORTS = new JSON.Literal("[\"long-polling\",\"callback-polling\"]");
    private static final JSON.Literal EXT_JSON_COMMENTED = new JSON.Literal("{\"json-comment-filtered\":true}");
    private static HashMap<String, Class> _transports = new HashMap();
    private static final JSON.Literal __NO_ADVICE = new JSON.Literal("{}");
    private static final JSON.Literal __MULTI_FRAME_ADVICE = new JSON.Literal("{\"reconnect\":\"retry\",\"interval\":1500,\"multiple-clients\":true}");
    HashMap<String, Handler> _handlers = new HashMap();
    ChannelImpl _root = new ChannelImpl("/", this);
    ConcurrentHashMap<String, ClientImpl> _clients = new ConcurrentHashMap();
    SecurityPolicy _securityPolicy = new DefaultPolicy();
    Object _advice = new JSON.Literal("{\"reconnect\":\"retry\",\"interval\":0}");
    Object _unknownAdvice = new JSON.Literal("{\"reconnect\":\"handshake\",\"interval\":500}");
    int _logLevel;
    long _clientTimeoutMs = 60000L;
    boolean _JSONCommented;
    boolean _initialized;
    ConcurrentHashMap<String, Set<String>> _browserPolls = new ConcurrentHashMap();
    transient ServletContext _context;
    transient Random _random;
    transient DateCache _dateCache;
    transient ConcurrentHashMap<String, ChannelId> _channelIdCache;
    private boolean _alwaysResumePoll;

    protected AbstractBayeux() {
        this._handlers.put("*", new PublishHandler());
        this._handlers.put(META_HANDSHAKE, new HandshakeHandler());
        this._handlers.put(META_CONNECT, new ConnectHandler());
        this._handlers.put(META_RECONNECT, new ReconnectHandler());
        this._handlers.put(META_DISCONNECT, new DisconnectHandler());
        this._handlers.put(META_SUBSCRIBE, new SubscribeHandler());
        this._handlers.put(META_UNSUBSCRIBE, new UnsubscribeHandler());
        this._handlers.put(META_STATUS, new StatusHandler());
        this._handlers.put(META_PING, new PingHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFilter(String channels, DataFilter filter) {
        AbstractBayeux abstractBayeux = this;
        synchronized (abstractBayeux) {
            ChannelImpl channel = (ChannelImpl)this.getChannel(channels, true);
            channel.addDataFilter(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFilter(String channels, DataFilter filter) {
        AbstractBayeux abstractBayeux = this;
        synchronized (abstractBayeux) {
            ChannelImpl channel = (ChannelImpl)this.getChannel(channels, false);
            if (channel != null) {
                channel.removeDataFilter(filter);
            }
        }
    }

    public ChannelImpl getChannel(ChannelId id) {
        return this._root.getChild(id);
    }

    public ChannelImpl getChannel(String id) {
        ChannelId cid = this.getChannelId(id);
        if (cid.depth() == 0) {
            return null;
        }
        return this._root.getChild(cid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel getChannel(String id, boolean create) {
        AbstractBayeux abstractBayeux = this;
        synchronized (abstractBayeux) {
            ChannelImpl channel = this.getChannel(id);
            if (channel == null && create) {
                channel = new ChannelImpl(id, this);
                this._root.addChild(channel);
                if (this.isLogInfo()) {
                    this.logInfo("newChannel: " + channel);
                }
            }
            return channel;
        }
    }

    public ChannelId getChannelId(String id) {
        ChannelId cid = this._channelIdCache.get(id);
        if (cid == null) {
            cid = new ChannelId(id);
            this._channelIdCache.put(id, cid);
        }
        return cid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client getClient(String client_id) {
        AbstractBayeux abstractBayeux = this;
        synchronized (abstractBayeux) {
            if (client_id == null) {
                return null;
            }
            Client client = this._clients.get(client_id);
            return client;
        }
    }

    public Set getClientIDs() {
        return this._clients.keySet();
    }

    public long getClientTimeoutMs() {
        return this._clientTimeoutMs;
    }

    public int getLogLevel() {
        return this._logLevel;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this._securityPolicy;
    }

    public String handle(ClientImpl client, Transport transport, Map<String, Object> message) throws IOException {
        String METHOD = "handle: ";
        String channel_id = (String)message.get(CHANNEL_FIELD);
        Handler handler = this._handlers.get(channel_id);
        if (handler == null) {
            handler = this._handlers.get("*");
        }
        if (this.isLogDebug()) {
            this.logDebug("handle: handler=" + handler);
        }
        handler.handle(client, transport, message);
        return channel_id;
    }

    @Override
    public boolean hasChannel(String id) {
        ChannelId cid = this.getChannelId(id);
        return this._root.getChild(cid) != null;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public boolean isJSONCommented() {
        return this._JSONCommented;
    }

    public boolean isLogDebug() {
        return this._logLevel > 1;
    }

    public boolean isLogInfo() {
        return this._logLevel > 0;
    }

    public void logDebug(String message) {
        if (this._logLevel > 1) {
            this._context.log(message);
        }
    }

    public void logDebug(String message, Throwable th) {
        if (this._logLevel > 1) {
            this._context.log(message, th);
        }
    }

    public void logInfo(String message) {
        if (this._logLevel > 0) {
            this._context.log(message);
        }
    }

    @Override
    public Client newClient(String idPrefix, Listener listener) {
        return new ClientImpl(this, idPrefix, listener);
    }

    public abstract ClientImpl newRemoteClient();

    public Transport newTransport(ClientImpl client, Map message) {
        if (this.isLogDebug()) {
            this.logDebug("newTransport: client=" + client + ",message=" + message);
        }
        Transport result = null;
        try {
            Class trans_class;
            String jsonp;
            String type;
            String string = type = client == null ? null : client.getConnectionType();
            if (type == null) {
                type = (String)message.get("connectionType");
            }
            if (type == null && (jsonp = (String)message.get("jsonp")) != null) {
                if (this.isLogDebug()) {
                    this.logDebug("newTransport: using JSONPTransport with jsonp=" + jsonp);
                }
                result = new JSONPTransport(client != null && client.isJSONCommented());
                ((JSONPTransport)result).setJsonp(jsonp);
            }
            if (type != null && result == null && (trans_class = _transports.get(type)) != null) {
                if (trans_class.equals(JSONPTransport.class)) {
                    String jsonp2 = (String)message.get("jsonp");
                    if (jsonp2 == null) {
                        throw new Exception("JSONPTransport needs jsonp parameter");
                    }
                    result = new JSONPTransport(client != null && client.isJSONCommented());
                    ((JSONPTransport)result).setJsonp(jsonp2);
                } else {
                    result = (Transport)trans_class.newInstance();
                    result.setJSONCommented(client != null && client.isJSONCommented());
                }
            }
            if (result == null) {
                result = new JSONTransport(client != null && client.isJSONCommented());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.isLogDebug()) {
            this.logDebug("newTransport: result=" + result);
        }
        return result;
    }

    public void publish(ChannelId to, Client from, Object data, String msgId) {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put(CHANNEL_FIELD, to.toString());
        msg.put(TIMESTAMP_FIELD, this.getTimeOnServer());
        if (msgId == null) {
            long id = msg.hashCode() ^ (to == null ? 0 : to.hashCode()) ^ (from == null ? 0 : from.hashCode());
            id = id < 0L ? -id : id;
            msg.put(ID_FIELD, Long.toString(id, 36));
        } else {
            msg.put(ID_FIELD, msgId);
        }
        msg.put(DATA_FIELD, data);
        this._root.publish(to, from, msg);
    }

    @Override
    public void publish(Client fromClient, String toChannelId, Object data, String msgId) {
        this.publish(this.getChannelId(toChannelId), fromClient, data, msgId);
    }

    public boolean removeChannel(ChannelId channelId) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Client removeClient(String client_id) {
        ClientImpl client;
        AbstractBayeux abstractBayeux = this;
        synchronized (abstractBayeux) {
            if (client_id == null) {
                return null;
            }
            client = this._clients.remove(client_id);
        }
        if (client != null) {
            client.unsubscribeAll();
        }
        return client;
    }

    public void setClientTimeoutMs(long ms) {
        this._clientTimeoutMs = ms;
    }

    public void setJSONCommented(boolean commented) {
        this._JSONCommented = commented;
    }

    public void setLogLevel(int logLevel) {
        this._logLevel = logLevel;
    }

    public void setSecurityPolicy(SecurityPolicy securityPolicy) {
        this._securityPolicy = securityPolicy;
    }

    @Override
    public void subscribe(String toChannel, Client subscriber) {
        ChannelImpl channel = (ChannelImpl)this.getChannel(toChannel, true);
        if (channel != null) {
            channel.subscribe(subscriber);
        }
    }

    @Override
    public void unsubscribe(String toChannel, Client subscriber) {
        ChannelImpl channel = this.getChannel(toChannel);
        if (channel != null) {
            channel.unsubscribe(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(ServletContext context) {
        AbstractBayeux abstractBayeux = this;
        synchronized (abstractBayeux) {
            this._initialized = true;
            this._context = context;
            try {
                this._random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (Exception e) {
                context.log("Could not get secure random for ID generation", (Throwable)e);
                this._random = new Random();
            }
            this._random.setSeed(this._random.nextLong() ^ (long)this.hashCode() ^ (long)(context.hashCode() << 32) ^ Runtime.getRuntime().freeMemory());
            this._dateCache = new DateCache();
            this._channelIdCache = new ConcurrentHashMap();
        }
    }

    public void advise(Client client, Transport transport, Object advice) throws IOException {
        if (advice == null) {
            advice = this._advice;
        }
        if (advice == null) {
            advice = __NO_ADVICE;
        }
        String channel = "/meta/connections/" + client.getId();
        HashMap<String, Object> reply = new HashMap<String, Object>();
        reply.put(CHANNEL_FIELD, channel);
        reply.put(SUCCESSFUL_FIELD, Boolean.TRUE);
        reply.put(ADVICE_FIELD, advice);
        transport.send(reply);
    }

    protected long getRandom(long variation) {
        long l = this._random.nextLong() ^ variation;
        return l < 0L ? -l : l;
    }

    String getTimeOnServer() {
        return this._dateCache.format(System.currentTimeMillis());
    }

    public boolean getAlwaysResumePoll() {
        return this._alwaysResumePoll;
    }

    public void setAlwaysResumePoll(boolean always) {
        this._alwaysResumePoll = always;
    }

    static {
        _transports.put("long-polling", JSONTransport.class);
        _transports.put("callback-polling", JSONPTransport.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnsubscribeHandler
    extends Handler {
        private UnsubscribeHandler() {
        }

        @Override
        public void handle(ClientImpl client, Transport transport, Map<String, Object> message) throws IOException {
            if (client == null) {
                this.unknownClient(transport, AbstractBayeux.META_UNSUBSCRIBE);
                return;
            }
            AbstractBayeux.this._root.publish(META_UNSUBSCRIBE_ID, client, message);
            String channel_id = (String)message.get(AbstractBayeux.SUBSCRIPTION_FIELD);
            ChannelImpl channel = AbstractBayeux.this.getChannel(channel_id);
            if (channel != null) {
                channel.unsubscribe(client);
            }
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(AbstractBayeux.CHANNEL_FIELD, AbstractBayeux.META_UNSUBSCRIBE);
            reply.put(AbstractBayeux.SUBSCRIPTION_FIELD, channel.getId());
            reply.put(AbstractBayeux.SUCCESSFUL_FIELD, Boolean.TRUE);
            reply.put("error", "");
            transport.send(reply);
            AbstractBayeux.this._root.publish(META_UNSUBSCRIBE_ID, client, reply);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubscribeHandler
    extends Handler {
        private SubscribeHandler() {
        }

        @Override
        public void handle(ClientImpl client, Transport transport, Map<String, Object> message) throws IOException {
            if (client == null) {
                this.unknownClient(transport, AbstractBayeux.META_SUBSCRIBE);
                return;
            }
            AbstractBayeux.this._root.publish(META_SUBSCRIBE_ID, client, message);
            String subscribe_id = (String)message.get(AbstractBayeux.SUBSCRIPTION_FIELD);
            if (subscribe_id == null) {
                subscribe_id = Long.toString(AbstractBayeux.this.getRandom(((Object)message).hashCode() ^ client.hashCode()), 36);
                while (AbstractBayeux.this.getChannel(subscribe_id) != null) {
                    subscribe_id = Long.toString(AbstractBayeux.this.getRandom(((Object)message).hashCode() ^ client.hashCode()), 36);
                }
            }
            ChannelId cid = AbstractBayeux.this.getChannelId(subscribe_id);
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(AbstractBayeux.CHANNEL_FIELD, AbstractBayeux.META_SUBSCRIBE);
            reply.put(AbstractBayeux.SUBSCRIPTION_FIELD, subscribe_id);
            if (AbstractBayeux.this._securityPolicy.canSubscribe(client, cid, message)) {
                ChannelImpl channel = AbstractBayeux.this.getChannel(cid);
                if (channel == null && AbstractBayeux.this._securityPolicy.canCreate(client, cid, message)) {
                    channel = (ChannelImpl)AbstractBayeux.this.getChannel(subscribe_id, true);
                }
                if (channel != null) {
                    channel.subscribe(client);
                    reply.put(AbstractBayeux.SUCCESSFUL_FIELD, Boolean.TRUE);
                    reply.put("error", "");
                } else {
                    reply.put(AbstractBayeux.SUCCESSFUL_FIELD, Boolean.FALSE);
                    reply.put("error", "cannot create");
                }
            } else {
                reply.put(AbstractBayeux.SUCCESSFUL_FIELD, Boolean.FALSE);
                reply.put("error", "cannot subscribe");
            }
            transport.send(reply);
            AbstractBayeux.this._root.publish(META_SUBSCRIBE_ID, client, reply);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StatusHandler
    extends Handler {
        private StatusHandler() {
        }

        @Override
        public void handle(ClientImpl client, Transport transport, Map<String, Object> message) throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReconnectHandler
    extends Handler {
        private ReconnectHandler() {
        }

        @Override
        public void handle(ClientImpl client, Transport transport, Map<String, Object> message) throws IOException {
            if (client == null) {
                this.unknownClient(transport, AbstractBayeux.META_RECONNECT);
                return;
            }
            AbstractBayeux.this._root.publish(META_RECONNECT_ID, client, message);
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(AbstractBayeux.CHANNEL_FIELD, AbstractBayeux.META_RECONNECT);
            reply.put(AbstractBayeux.TIMESTAMP_FIELD, AbstractBayeux.this._dateCache.format(System.currentTimeMillis()));
            if (client == null) {
                reply.put(AbstractBayeux.SUCCESSFUL_FIELD, Boolean.FALSE);
                reply.put("error", "unknown clientID");
                if (AbstractBayeux.this._unknownAdvice != null) {
                    reply.put(AbstractBayeux.ADVICE_FIELD, AbstractBayeux.this._unknownAdvice);
                }
                transport.setPolling(false);
                transport.send(reply);
            } else {
                String type = (String)message.get("connectionType");
                if (type != null) {
                    if (AbstractBayeux.this.isLogDebug()) {
                        AbstractBayeux.this.logDebug("Reconnect.handle: old connectionType=" + client.getConnectionType());
                    }
                    if ("callback-polling".equals(client.getConnectionType())) {
                        AbstractBayeux.this.logDebug("Reconnect.handle: connectionType remains callback-polling");
                    } else {
                        client.setConnectionType(type);
                        if (AbstractBayeux.this.isLogDebug()) {
                            AbstractBayeux.this.logDebug("Reconnect.handle: connectionType reset to " + type);
                        }
                    }
                }
                reply.put(AbstractBayeux.SUCCESSFUL_FIELD, Boolean.TRUE);
                reply.put("error", "");
                String browser_id = client.getBrowserId();
                if (browser_id != null) {
                    int count = client.onBrowser(browser_id);
                    if (count > 1) {
                        transport.setPolling(false);
                        reply.put(AbstractBayeux.ADVICE_FIELD, __MULTI_FRAME_ADVICE);
                    } else {
                        transport.setPolling(true);
                        reply.put(AbstractBayeux.ADVICE_FIELD, __NO_ADVICE);
                    }
                } else {
                    transport.setPolling(true);
                    reply.put(AbstractBayeux.ADVICE_FIELD, __NO_ADVICE);
                }
                transport.send(reply);
            }
            AbstractBayeux.this._root.publish(META_RECONNECT_ID, client, reply);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PublishHandler
    extends Handler {
        private PublishHandler() {
        }

        @Override
        public void handle(ClientImpl client, Transport transport, Map<String, Object> message) throws IOException {
            String channel_id = (String)message.get(AbstractBayeux.CHANNEL_FIELD);
            if (client == null) {
                this.unknownClient(transport, channel_id);
                return;
            }
            String id = (String)message.get(AbstractBayeux.ID_FIELD);
            ChannelId cid = AbstractBayeux.this.getChannelId(channel_id);
            Object data = message.get(AbstractBayeux.DATA_FIELD);
            if (client == null && AbstractBayeux.this._securityPolicy.authenticate((String)message.get("authScheme"), (String)message.get("authUser"), (String)message.get("authToken"))) {
                client = AbstractBayeux.this.newRemoteClient();
            }
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(AbstractBayeux.CHANNEL_FIELD, channel_id);
            if (id != null) {
                reply.put(AbstractBayeux.ID_FIELD, id);
            }
            if (data != null && AbstractBayeux.this._securityPolicy.canSend(client, cid, message)) {
                AbstractBayeux.this.publish(cid, client, data, id);
                reply.put(AbstractBayeux.SUCCESSFUL_FIELD, Boolean.TRUE);
                reply.put("error", "");
            } else {
                reply.put(AbstractBayeux.SUCCESSFUL_FIELD, Boolean.FALSE);
                reply.put("error", "unknown channel");
            }
            transport.send(reply);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PingHandler
    extends Handler {
        private PingHandler() {
        }

        @Override
        public void handle(ClientImpl client, Transport transport, Map<String, Object> message) throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HandshakeHandler
    extends Handler {
        private HandshakeHandler() {
        }

        @Override
        public void handle(ClientImpl client, Transport transport, Map<String, Object> message) throws IOException {
            if (client != null) {
                throw new IllegalStateException();
            }
            AbstractBayeux.this._root.publish(META_HANDSHAKE_ID, client, message);
            if (AbstractBayeux.this._securityPolicy.authenticate((String)message.get("authScheme"), (String)message.get("authUser"), (String)message.get("authToken"))) {
                client = AbstractBayeux.this.newRemoteClient();
            }
            Map ext = (Map)message.get(AbstractBayeux.EXT_FIELD);
            boolean commented = AbstractBayeux.this._JSONCommented && ext != null && (Boolean)ext.get("json-comment-filtered") != false;
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(AbstractBayeux.CHANNEL_FIELD, AbstractBayeux.META_HANDSHAKE);
            reply.put("version", new Double(0.1));
            reply.put("minimumVersion", new Double(0.1));
            if (AbstractBayeux.this.isJSONCommented()) {
                reply.put(AbstractBayeux.EXT_FIELD, EXT_JSON_COMMENTED);
            }
            if (client != null) {
                reply.put("supportedConnectionTypes", TRANSPORTS);
                reply.put(AbstractBayeux.SUCCESSFUL_FIELD, Boolean.TRUE);
                reply.put("authSuccessful", Boolean.TRUE);
                reply.put(AbstractBayeux.CLIENT_FIELD, client.getId());
                if (AbstractBayeux.this._advice != null) {
                    reply.put(AbstractBayeux.ADVICE_FIELD, AbstractBayeux.this._advice);
                }
                client.setJSONCommented(commented);
                transport.setJSONCommented(commented);
            } else {
                reply.put(AbstractBayeux.SUCCESSFUL_FIELD, Boolean.FALSE);
                if (AbstractBayeux.this._advice != null) {
                    reply.put(AbstractBayeux.ADVICE_FIELD, AbstractBayeux.this._advice);
                }
            }
            if (AbstractBayeux.this.isLogDebug()) {
                AbstractBayeux.this.logDebug("handshake.handle: reply=" + reply);
            }
            transport.send(reply);
            AbstractBayeux.this._root.publish(META_HANDSHAKE_ID, client, reply);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DisconnectHandler
    extends Handler {
        private DisconnectHandler() {
        }

        @Override
        public void handle(ClientImpl client, Transport transport, Map<String, Object> message) throws IOException {
            if (client == null) {
                this.unknownClient(transport, AbstractBayeux.META_DISCONNECT);
                return;
            }
            client.remove(false);
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(AbstractBayeux.CHANNEL_FIELD, AbstractBayeux.META_DISCONNECT);
            reply.put(AbstractBayeux.SUCCESSFUL_FIELD, Boolean.TRUE);
            reply.put("error", "");
            reply.put(AbstractBayeux.TIMESTAMP_FIELD, AbstractBayeux.this._dateCache.format(System.currentTimeMillis()));
            transport.send(reply);
            transport.setPolling(false);
            AbstractBayeux.this._root.publish(META_DISCONNECT_ID, client, reply);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectHandler
    extends Handler {
        private ConnectHandler() {
        }

        @Override
        public void handle(ClientImpl client, Transport transport, Map<String, Object> message) throws IOException {
            if (client == null) {
                this.unknownClient(transport, AbstractBayeux.META_CONNECT);
                return;
            }
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(AbstractBayeux.CHANNEL_FIELD, AbstractBayeux.META_CONNECT);
            String type = (String)message.get("connectionType");
            client.setConnectionType(type);
            ChannelImpl connection = client.connect();
            if (connection != null) {
                reply.put(AbstractBayeux.SUCCESSFUL_FIELD, Boolean.TRUE);
                reply.put("error", "");
            } else {
                reply.put(AbstractBayeux.SUCCESSFUL_FIELD, Boolean.FALSE);
                reply.put("error", "unknown client ID");
                if (AbstractBayeux.this._unknownAdvice != null) {
                    reply.put(AbstractBayeux.ADVICE_FIELD, AbstractBayeux.this._unknownAdvice);
                }
            }
            reply.put(AbstractBayeux.TIMESTAMP_FIELD, AbstractBayeux.this._dateCache.format(System.currentTimeMillis()));
            transport.send(reply);
            transport.setPolling(false);
            AbstractBayeux.this._root.publish(META_CONNECT_ID, client, reply);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Handler {
        private Handler() {
        }

        abstract void handle(ClientImpl var1, Transport var2, Map<String, Object> var3) throws IOException;

        void unknownClient(Transport transport, String channel) throws IOException {
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(AbstractBayeux.CHANNEL_FIELD, channel);
            reply.put(AbstractBayeux.SUCCESSFUL_FIELD, Boolean.FALSE);
            reply.put("error", "Unknown client");
            reply.put(AbstractBayeux.ADVICE_FIELD, new JSON.Literal("{\"reconnect\":\"handshake\"}"));
            transport.send(reply);
        }
    }

    private static class DefaultPolicy
    implements SecurityPolicy {
        private DefaultPolicy() {
        }

        public boolean authenticate(String scheme, String user, String credentials) {
            return true;
        }

        public boolean canCreate(Client client, ChannelId channel, Map message) {
            return client != null && !"meta".equals(channel.getSegment(0));
        }

        public boolean canSend(Client client, ChannelId channel, Map message) {
            return client != null && !"meta".equals(channel.getSegment(0));
        }

        public boolean canSubscribe(Client client, ChannelId channel, Map message) {
            return client != null && !"meta".equals(channel.getSegment(0));
        }
    }
}

