/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class BatchCursor<T>
implements AutoCloseable {
    private final AsyncBatchCursor<T> wrapped;

    public BatchCursor(AsyncBatchCursor<T> wrapped) {
        this.wrapped = wrapped;
    }

    public Publisher<List<T>> next() {
        return Mono.create(sink -> this.wrapped.next(MongoOperationPublisher.sinkToCallback(sink)));
    }

    public void setBatchSize(int batchSize) {
        this.wrapped.setBatchSize(batchSize);
    }

    public int getBatchSize() {
        return this.wrapped.getBatchSize();
    }

    public boolean isClosed() {
        return this.wrapped.isClosed();
    }

    @Override
    public void close() {
        this.wrapped.close();
    }
}

