/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.connection.AbstractReferenceCounted;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.CommandProtocol;
import com.mongodb.connection.Connection;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.DeleteCommandProtocol;
import com.mongodb.connection.DeleteProtocol;
import com.mongodb.connection.GetMoreProtocol;
import com.mongodb.connection.InsertCommandProtocol;
import com.mongodb.connection.InsertProtocol;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.KillCursorProtocol;
import com.mongodb.connection.Protocol;
import com.mongodb.connection.ProtocolExecutor;
import com.mongodb.connection.QueryProtocol;
import com.mongodb.connection.QueryResult;
import com.mongodb.connection.ServerType;
import com.mongodb.connection.UpdateCommandProtocol;
import com.mongodb.connection.UpdateProtocol;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.FieldNameValidator;
import org.bson.codecs.Decoder;

class DefaultServerConnection
extends AbstractReferenceCounted
implements Connection,
AsyncConnection {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final InternalConnection wrapped;
    private final ProtocolExecutor protocolExecutor;
    private final ClusterConnectionMode clusterConnectionMode;

    DefaultServerConnection(InternalConnection wrapped, ProtocolExecutor protocolExecutor, ClusterConnectionMode clusterConnectionMode) {
        this.wrapped = wrapped;
        this.protocolExecutor = protocolExecutor;
        this.clusterConnectionMode = clusterConnectionMode;
    }

    @Override
    public DefaultServerConnection retain() {
        super.retain();
        return this;
    }

    @Override
    public void release() {
        super.release();
        if (this.getCount() == 0) {
            this.wrapped.close();
        }
    }

    @Override
    public ConnectionDescription getDescription() {
        Assertions.isTrue("open", this.getCount() > 0);
        return this.wrapped.getDescription();
    }

    @Override
    public WriteConcernResult insert(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<InsertRequest> inserts) {
        return this.executeProtocol(new InsertProtocol(namespace, ordered, writeConcern, inserts));
    }

    @Override
    public void insertAsync(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<InsertRequest> inserts, SingleResultCallback<WriteConcernResult> callback) {
        this.executeProtocolAsync(new InsertProtocol(namespace, ordered, writeConcern, inserts), callback);
    }

    @Override
    public WriteConcernResult update(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<UpdateRequest> updates) {
        return this.executeProtocol(new UpdateProtocol(namespace, ordered, writeConcern, updates));
    }

    @Override
    public void updateAsync(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<UpdateRequest> updates, SingleResultCallback<WriteConcernResult> callback) {
        this.executeProtocolAsync(new UpdateProtocol(namespace, ordered, writeConcern, updates), callback);
    }

    @Override
    public WriteConcernResult delete(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<DeleteRequest> deletes) {
        return this.executeProtocol(new DeleteProtocol(namespace, ordered, writeConcern, deletes));
    }

    @Override
    public void deleteAsync(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<DeleteRequest> deletes, SingleResultCallback<WriteConcernResult> callback) {
        this.executeProtocolAsync(new DeleteProtocol(namespace, ordered, writeConcern, deletes), callback);
    }

    @Override
    public BulkWriteResult insertCommand(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<InsertRequest> inserts) {
        return this.insertCommand(namespace, ordered, writeConcern, null, inserts);
    }

    @Override
    public BulkWriteResult insertCommand(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, Boolean bypassDocumentValidation, List<InsertRequest> inserts) {
        return this.executeProtocol(new InsertCommandProtocol(namespace, ordered, writeConcern, bypassDocumentValidation, inserts));
    }

    @Override
    public void insertCommandAsync(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<InsertRequest> inserts, SingleResultCallback<BulkWriteResult> callback) {
        this.insertCommandAsync(namespace, ordered, writeConcern, null, inserts, callback);
    }

    @Override
    public void insertCommandAsync(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, Boolean bypassDocumentValidation, List<InsertRequest> inserts, SingleResultCallback<BulkWriteResult> callback) {
        this.executeProtocolAsync(new InsertCommandProtocol(namespace, ordered, writeConcern, bypassDocumentValidation, inserts), callback);
    }

    @Override
    public BulkWriteResult updateCommand(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<UpdateRequest> updates) {
        return this.updateCommand(namespace, ordered, writeConcern, null, updates);
    }

    @Override
    public BulkWriteResult updateCommand(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, Boolean bypassDocumentValidation, List<UpdateRequest> updates) {
        return this.executeProtocol(new UpdateCommandProtocol(namespace, ordered, writeConcern, bypassDocumentValidation, updates));
    }

    @Override
    public void updateCommandAsync(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<UpdateRequest> updates, SingleResultCallback<BulkWriteResult> callback) {
        this.updateCommandAsync(namespace, ordered, writeConcern, null, updates, callback);
    }

    @Override
    public void updateCommandAsync(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, Boolean bypassDocumentValidation, List<UpdateRequest> updates, SingleResultCallback<BulkWriteResult> callback) {
        this.executeProtocolAsync(new UpdateCommandProtocol(namespace, ordered, writeConcern, bypassDocumentValidation, updates), callback);
    }

    @Override
    public BulkWriteResult deleteCommand(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<DeleteRequest> deletes) {
        return this.executeProtocol(new DeleteCommandProtocol(namespace, ordered, writeConcern, deletes));
    }

    @Override
    public void deleteCommandAsync(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<DeleteRequest> deletes, SingleResultCallback<BulkWriteResult> callback) {
        this.executeProtocolAsync(new DeleteCommandProtocol(namespace, ordered, writeConcern, deletes), callback);
    }

    @Override
    public <T> T command(String database, BsonDocument command, boolean slaveOk, FieldNameValidator fieldNameValidator, Decoder<T> commandResultDecoder) {
        return this.executeProtocol(new CommandProtocol<T>(database, command, fieldNameValidator, commandResultDecoder).slaveOk(this.getSlaveOk(slaveOk)));
    }

    @Override
    public <T> void commandAsync(String database, BsonDocument command, boolean slaveOk, FieldNameValidator fieldNameValidator, Decoder<T> commandResultDecoder, SingleResultCallback<T> callback) {
        this.executeProtocolAsync(new CommandProtocol<T>(database, command, fieldNameValidator, commandResultDecoder).slaveOk(this.getSlaveOk(slaveOk)), callback);
    }

    @Override
    public <T> QueryResult<T> query(MongoNamespace namespace, BsonDocument queryDocument, BsonDocument fields, int numberToReturn, int skip, boolean slaveOk, boolean tailableCursor, boolean awaitData, boolean noCursorTimeout, boolean partial, boolean oplogReplay, Decoder<T> resultDecoder) {
        return (QueryResult)this.executeProtocol(new QueryProtocol<T>(namespace, skip, numberToReturn, queryDocument, fields, resultDecoder).tailableCursor(tailableCursor).slaveOk(this.getSlaveOk(slaveOk)).oplogReplay(oplogReplay).noCursorTimeout(noCursorTimeout).awaitData(awaitData).partial(partial));
    }

    @Override
    public <T> QueryResult<T> query(MongoNamespace namespace, BsonDocument queryDocument, BsonDocument fields, int skip, int limit, int batchSize, boolean slaveOk, boolean tailableCursor, boolean awaitData, boolean noCursorTimeout, boolean partial, boolean oplogReplay, Decoder<T> resultDecoder) {
        return (QueryResult)this.executeProtocol(new QueryProtocol<T>(namespace, skip, limit, batchSize, queryDocument, fields, resultDecoder).tailableCursor(tailableCursor).slaveOk(this.getSlaveOk(slaveOk)).oplogReplay(oplogReplay).noCursorTimeout(noCursorTimeout).awaitData(awaitData).partial(partial));
    }

    @Override
    public <T> void queryAsync(MongoNamespace namespace, BsonDocument queryDocument, BsonDocument fields, int numberToReturn, int skip, boolean slaveOk, boolean tailableCursor, boolean awaitData, boolean noCursorTimeout, boolean partial, boolean oplogReplay, Decoder<T> resultDecoder, SingleResultCallback<QueryResult<T>> callback) {
        this.executeProtocolAsync(new QueryProtocol<T>(namespace, skip, numberToReturn, queryDocument, fields, resultDecoder).tailableCursor(tailableCursor).slaveOk(this.getSlaveOk(slaveOk)).oplogReplay(oplogReplay).noCursorTimeout(noCursorTimeout).awaitData(awaitData).partial(partial), callback);
    }

    @Override
    public <T> void queryAsync(MongoNamespace namespace, BsonDocument queryDocument, BsonDocument fields, int skip, int limit, int batchSize, boolean slaveOk, boolean tailableCursor, boolean awaitData, boolean noCursorTimeout, boolean partial, boolean oplogReplay, Decoder<T> resultDecoder, SingleResultCallback<QueryResult<T>> callback) {
        this.executeProtocolAsync(new QueryProtocol<T>(namespace, skip, limit, batchSize, queryDocument, fields, resultDecoder).tailableCursor(tailableCursor).slaveOk(this.getSlaveOk(slaveOk)).oplogReplay(oplogReplay).noCursorTimeout(noCursorTimeout).awaitData(awaitData).partial(partial), callback);
    }

    @Override
    public <T> QueryResult<T> getMore(MongoNamespace namespace, long cursorId, int numberToReturn, Decoder<T> resultDecoder) {
        return (QueryResult)this.executeProtocol(new GetMoreProtocol<T>(namespace, cursorId, numberToReturn, resultDecoder));
    }

    @Override
    public <T> void getMoreAsync(MongoNamespace namespace, long cursorId, int numberToReturn, Decoder<T> resultDecoder, SingleResultCallback<QueryResult<T>> callback) {
        this.executeProtocolAsync(new GetMoreProtocol<T>(namespace, cursorId, numberToReturn, resultDecoder), callback);
    }

    @Override
    public void killCursor(List<Long> cursors) {
        this.killCursor(null, cursors);
    }

    @Override
    public void killCursor(MongoNamespace namespace, List<Long> cursors) {
        this.executeProtocol(new KillCursorProtocol(namespace, cursors));
    }

    @Override
    public void killCursorAsync(List<Long> cursors, SingleResultCallback<Void> callback) {
        this.killCursorAsync(null, cursors, callback);
    }

    @Override
    public void killCursorAsync(MongoNamespace namespace, List<Long> cursors, SingleResultCallback<Void> callback) {
        this.executeProtocolAsync(new KillCursorProtocol(namespace, cursors), callback);
    }

    private boolean getSlaveOk(boolean slaveOk) {
        return slaveOk || this.clusterConnectionMode == ClusterConnectionMode.SINGLE && this.wrapped.getDescription().getServerType() != ServerType.SHARD_ROUTER;
    }

    private <T> T executeProtocol(Protocol<T> protocol) {
        return this.protocolExecutor.execute(protocol, this.wrapped);
    }

    private <T> void executeProtocolAsync(Protocol<T> protocol, SingleResultCallback<T> callback) {
        SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        try {
            this.protocolExecutor.executeAsync(protocol, this.wrapped, errHandlingCallback);
        }
        catch (Throwable t) {
            errHandlingCallback.onResult(null, t);
        }
    }
}

