/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.bytebuddy;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.mockito.Mockito;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.creation.bytebuddy.access.MockAccess;

public abstract class ModuleHandler {
    abstract void exportFromTo(Class<?> var1, Class<?> var2);

    abstract void exportFromTo(Class<?> var1, ClassLoader var2);

    abstract void openFromTo(Class<?> var1, Class<?> var2);

    abstract void readFromTo(Class<?> var1, Class<?> var2);

    abstract ClassLoader toCodegenLoader(ClassLoader var1);

    public abstract ClassLoadingStrategy<ClassLoader> classLoadingStrategy();

    abstract ClassLoadingStrategy<ClassLoader> classLoadingStrategy(Class<?> var1);

    abstract boolean canOpen(Class<?> var1);

    abstract boolean canAddRead(Class<?> var1);

    static ModuleHandler make() {
        try {
            return new ModuleSystemFound(){

                @Override
                void exportFromTo(Object source, Object target, String packageName) {
                    throw new UnsupportedOperationException("Cannot export " + packageName + " of " + String.valueOf(source) + " to " + String.valueOf(target));
                }

                @Override
                void openFromToRaw(Object source, Object target, String packageName) {
                    throw new UnsupportedOperationException("Cannot open " + packageName + " of " + String.valueOf(source) + " to " + String.valueOf(target));
                }

                @Override
                void addReadsFromToRaw(Object source, Object target) {
                    throw new UnsupportedOperationException("Cannot add reading of " + String.valueOf(source) + " to " + String.valueOf(target));
                }
            };
        }
        catch (Exception ignored) {
            return new NoModuleSystemFound(){

                @Override
                public ClassLoadingStrategy<ClassLoader> classLoadingStrategy() {
                    return ClassLoadingStrategy.Default.INJECTION;
                }
            };
        }
    }

    static ModuleHandler make(final Object inst) {
        try {
            final Method redefineModule = Class.forName("java.lang.instrument.Instrumentation").getMethod("redefineModule", Module.class, Set.class, Map.class, Map.class, Set.class, Map.class);
            return new ModuleSystemFound(){

                @Override
                void exportFromTo(Object source, Object target, String packageName) {
                    try {
                        redefineModule.invoke(inst, source, Collections.emptySet(), Collections.singletonMap(packageName, Collections.singleton(target)), Collections.emptyMap(), Collections.emptySet(), Collections.emptyMap());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }

                @Override
                void openFromToRaw(Object source, Object target, String packageName) {
                    try {
                        redefineModule.invoke(inst, source, Collections.emptySet(), Collections.emptyMap(), Collections.singletonMap(packageName, Collections.singleton(target)), Collections.emptySet(), Collections.emptyMap());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }

                @Override
                void addReadsFromToRaw(Object source, Object target) {
                    try {
                        redefineModule.invoke(inst, source, Collections.singleton(target), Collections.emptyMap(), Collections.emptyMap(), Collections.emptySet(), Collections.emptyMap());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }

                @Override
                boolean canOpen(Class<?> type) {
                    return true;
                }

                @Override
                boolean canAddRead(Class<?> type) {
                    return true;
                }
            };
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static class MockitoMockClassLoader
    extends ClassLoader {
        private MockitoMockClassLoader(ClassLoader parent) {
            super(parent);
        }

        private Map<TypeDescription, Class<?>> defineClasses(Map<TypeDescription, byte[]> types) {
            LinkedHashMap loaded = new LinkedHashMap();
            for (Map.Entry<TypeDescription, byte[]> entry : types.entrySet()) {
                Class<?> type = this.defineClass(entry.getKey().getName(), entry.getValue(), 0, entry.getValue().length);
                loaded.put(entry.getKey(), type);
            }
            return loaded;
        }
    }

    static abstract class ModuleSystemFound
    extends ModuleHandler {
        private final Object lookup;
        private final Method privateLookupIn;
        private final Method getModule;
        private final Method isExported;
        private final Method isOpen;
        private final Method canRead;
        private final Method addExports;
        private final Method addOpens;
        private final Method addReads;
        private final Method getPackageName;
        private final Method getUnnamedModule;

        public ModuleSystemFound() throws Exception {
            Class<?> methodHandles = Class.forName("java.lang.invoke.MethodHandles");
            this.lookup = methodHandles.getMethod("lookup", new Class[0]).invoke(null, new Object[0]);
            this.privateLookupIn = methodHandles.getMethod("privateLookupIn", Class.class, Class.forName("java.lang.invoke.MethodHandles$Lookup"));
            this.getModule = Class.class.getMethod("getModule", new Class[0]);
            Class<?> module = Class.forName("java.lang.Module");
            this.isExported = module.getMethod("isExported", String.class, module);
            this.isOpen = module.getMethod("isOpen", String.class, module);
            this.canRead = module.getMethod("canRead", module);
            this.addExports = module.getMethod("addExports", String.class, module);
            this.addOpens = module.getMethod("addOpens", String.class, module);
            this.addReads = module.getMethod("addReads", module);
            this.getPackageName = Class.class.getMethod("getPackageName", new Class[0]);
            this.getUnnamedModule = ClassLoader.class.getMethod("getUnnamedModule", new Class[0]);
        }

        private Object getModule(Class<?> type) {
            try {
                return this.getModule.invoke(type, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        private boolean isExported(Object module, String packageName, Object target) {
            try {
                return (Boolean)this.isExported.invoke(module, packageName, target);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        private boolean isOpen(Object module, String packageName, Object target) {
            try {
                return (Boolean)this.isOpen.invoke(module, packageName, target);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        private boolean canRead(Object module, Object target) {
            try {
                return (Boolean)this.canRead.invoke(module, target);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        private void addExports(Object module, String packageName, Object target) {
            try {
                this.addExports.invoke(module, packageName, target);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        private void addOpens(Object module, String packageName, Object target) {
            try {
                this.addOpens.invoke(module, packageName, target);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        private void addReads(Object module, Object target) {
            try {
                this.addReads.invoke(module, target);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        private String getPackageName(Class<?> type) {
            try {
                return (String)this.getPackageName.invoke(type, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        private Object getUnnamedModule(ClassLoader classLoader) {
            try {
                return this.getUnnamedModule.invoke((Object)classLoader, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        void exportFromTo(Class<?> source, Class<?> target) {
            this.exportFromTo(source, this.getModule(target));
        }

        @Override
        void exportFromTo(Class<?> source, ClassLoader classLoader) {
            this.exportFromTo(source, this.getUnnamedModule(classLoader));
        }

        private void exportFromTo(Class<?> source, Object target) {
            if (!this.isExported(this.getModule(source), this.getPackageName(source), target)) {
                if (this.getModule(source) == this.getModule(ModuleHandler.class)) {
                    this.addExports(this.getModule(source), this.getPackageName(source), target);
                } else {
                    this.exportFromTo(this.getModule(source), target, this.getPackageName(source));
                }
            }
        }

        abstract void exportFromTo(Object var1, Object var2, String var3);

        @Override
        void openFromTo(Class<?> source, Class<?> target) {
            this.openFromTo(source, this.getModule(target));
        }

        private void openFromTo(Class<?> source, Object target) {
            if (!this.isOpen(this.getModule(source), this.getPackageName(source), target)) {
                if (this.getModule(source) == this.getModule(ModuleHandler.class)) {
                    this.addOpens(this.getModule(source), this.getPackageName(source), target);
                } else {
                    this.openFromToRaw(this.getModule(source), target, this.getPackageName(source));
                }
            }
        }

        abstract void openFromToRaw(Object var1, Object var2, String var3);

        @Override
        void readFromTo(Class<?> source, Class<?> target) {
            this.readFromTo(source, this.getModule(target));
        }

        private void readFromTo(Class<?> source, Object target) {
            if (!this.canRead(this.getModule(source), target)) {
                if (this.getModule(source) == this.getModule(ModuleHandler.class)) {
                    this.addReads(this.getModule(source), target);
                } else {
                    this.addReadsFromToRaw(this.getModule(source), target);
                }
            }
        }

        abstract void addReadsFromToRaw(Object var1, Object var2);

        @Override
        ClassLoader toCodegenLoader(ClassLoader classLoader) {
            if (classLoader == MockAccess.class.getClassLoader()) {
                return classLoader;
            }
            return new MockitoMockClassLoader(classLoader);
        }

        @Override
        public ClassLoadingStrategy<ClassLoader> classLoadingStrategy() {
            return (classLoader, types) -> {
                if (classLoader instanceof MockitoMockClassLoader) {
                    MockitoMockClassLoader mockLoader = (MockitoMockClassLoader)classLoader;
                    return mockLoader.defineClasses(types);
                }
                throw new IllegalStateException("Expected class loader to be a Mockito mock loader: " + String.valueOf(classLoader));
            };
        }

        @Override
        ClassLoadingStrategy<ClassLoader> classLoadingStrategy(Class<?> type) {
            if (!this.canRead(this.getModule(Mockito.class), this.getModule(type))) {
                this.addReads(this.getModule(Mockito.class), this.getModule(type));
            }
            try {
                return ClassLoadingStrategy.UsingLookup.of((Object)this.privateLookupIn.invoke(null, type, this.lookup));
            }
            catch (Exception e) {
                throw new MockitoException("Could not resolve private lookup for " + type.getTypeName(), e);
            }
        }

        @Override
        boolean canOpen(Class<?> type) {
            return this.isOpen(this.getModule(type), this.getPackageName(type), this.getModule(Mockito.class));
        }

        @Override
        boolean canAddRead(Class<?> type) {
            return this.canRead(this.getModule(type), this.getModule(Mockito.class));
        }
    }

    public static abstract class NoModuleSystemFound
    extends ModuleHandler {
        @Override
        void exportFromTo(Class<?> source, Class<?> target) {
        }

        @Override
        void exportFromTo(Class<?> source, ClassLoader classLoader) {
        }

        @Override
        void openFromTo(Class<?> source, Class<?> target) {
        }

        @Override
        void readFromTo(Class<?> source, Class<?> target) {
        }

        @Override
        ClassLoader toCodegenLoader(ClassLoader classLoader) {
            return classLoader;
        }

        @Override
        ClassLoadingStrategy<ClassLoader> classLoadingStrategy(Class<?> type) {
            return this.classLoadingStrategy();
        }

        @Override
        boolean canOpen(Class<?> type) {
            return true;
        }

        @Override
        boolean canAddRead(Class<?> type) {
            return true;
        }
    }
}

