/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.core.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.mockftpserver.core.CommandSyntaxException;
import org.mockftpserver.core.MockFtpServerException;

public final class PortParser {
    private PortParser() {
    }

    public static InetAddress parseHost(String[] parameters) {
        PortParser.verifySufficientParameters(parameters);
        byte host1 = PortParser.parseByte(parameters[0]);
        byte host2 = PortParser.parseByte(parameters[1]);
        byte host3 = PortParser.parseByte(parameters[2]);
        byte host4 = PortParser.parseByte(parameters[3]);
        byte[] address = new byte[]{host1, host2, host3, host4};
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByAddress(address);
        }
        catch (UnknownHostException e) {
            throw new MockFtpServerException("Error parsing host", e);
        }
        return inetAddress;
    }

    public static int parsePortNumber(String[] parameters) {
        PortParser.verifySufficientParameters(parameters);
        int port1 = Integer.parseInt(parameters[4]);
        int port2 = Integer.parseInt(parameters[5]);
        int port = (port1 << 8) + port2;
        return port;
    }

    private static void verifySufficientParameters(String[] parameters) {
        if (parameters == null || parameters.length < 6) {
            List<String> parms = parameters == null ? null : Arrays.asList(parameters);
            throw new CommandSyntaxException("The PORT command must contain least be 6 parameters: " + parms);
        }
    }

    public static String convertHostAndPortToCommaDelimitedBytes(InetAddress host, int port) {
        StringBuffer buffer = new StringBuffer();
        byte[] address = host.getAddress();
        for (int i = 0; i < address.length; ++i) {
            int positiveValue = address[i] >= 0 ? address[i] : 256 + address[i];
            buffer.append(positiveValue);
            buffer.append(",");
        }
        int p1 = port >> 8;
        int p2 = port % 256;
        buffer.append(String.valueOf(p1));
        buffer.append(",");
        buffer.append(String.valueOf(p2));
        return buffer.toString();
    }

    private static byte parseByte(String string) {
        return (byte)(0xFF & Short.parseShort(string));
    }
}

