/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.core.command;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import org.mockftpserver.core.CommandSyntaxException;
import org.mockftpserver.core.command.AbstractCommandHandler;
import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.command.InvocationHistory;
import org.mockftpserver.core.command.InvocationRecord;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.core.util.Assert;

public abstract class AbstractTrackingCommandHandler
extends AbstractCommandHandler
implements InvocationHistory {
    private List invocations = new ArrayList();

    public final void handleCommand(Command command, Session session) throws Exception {
        Assert.notNull(command, "command");
        Assert.notNull(session, "session");
        InvocationRecord invocationRecord = new InvocationRecord(command, session.getClientHost());
        this.invocations.add(invocationRecord);
        try {
            this.handleCommand(command, session, invocationRecord);
        }
        catch (CommandSyntaxException e) {
            this.sendReply(session, 501, null, null, null);
        }
        invocationRecord.lock();
    }

    protected abstract void handleCommand(Command var1, Session var2, InvocationRecord var3) throws Exception;

    protected void sendReply(Session session, int replyCode, String replyMessageKey, String replyText, Object[] arguments) {
        Assert.notNull(session, "session");
        this.assertValidReplyCode(replyCode);
        String key = replyMessageKey != null ? replyMessageKey : Integer.toString(replyCode);
        String text = this.getTextForReplyCode(replyCode, key, replyText, arguments);
        String replyTextToLog = text == null ? "" : " " + text;
        this.LOG.info((Object)("Sending reply [" + replyCode + replyTextToLog + "]"));
        session.sendReply(replyCode, text);
    }

    public int numberOfInvocations() {
        return this.invocations.size();
    }

    public InvocationRecord getInvocation(int index) {
        return (InvocationRecord)this.invocations.get(index);
    }

    public void clearInvocations() {
        this.invocations.clear();
    }

    private String getTextForReplyCode(int code, String messageKey, String overrideText, Object[] arguments) {
        try {
            String t = overrideText == null ? this.getReplyTextBundle().getString(messageKey) : overrideText;
            String formattedMessage = MessageFormat.format(t, arguments);
            return formattedMessage == null ? null : formattedMessage.trim();
        }
        catch (MissingResourceException e) {
            this.LOG.warn((Object)("No reply text defined for reply code [" + code + "]"));
            return null;
        }
    }
}

