/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.util.TypeUtils;

public class MethodMatcher {
    private final SourceMethod candidateMethod;
    private final TypeUtils typeUtils;
    private final TypeFactory typeFactory;

    MethodMatcher(TypeUtils typeUtils, TypeFactory typeFactory, SourceMethod candidateMethod) {
        this.typeUtils = typeUtils;
        this.candidateMethod = candidateMethod;
        this.typeFactory = typeFactory;
    }

    boolean matches(List<Type> sourceTypes, Type targetType) {
        GenericAnalyser analyser = new GenericAnalyser(this.typeFactory, this.typeUtils, this.candidateMethod, sourceTypes, targetType);
        if (!analyser.lineUp()) {
            return false;
        }
        for (int i = 0; i < sourceTypes.size(); ++i) {
            Type candidateSourceParType = analyser.candidateParTypes.get(i);
            if (sourceTypes.get(i).isAssignableTo(candidateSourceParType) && !this.isPrimitiveToObject(sourceTypes.get(i), candidateSourceParType)) continue;
            return false;
        }
        if (!analyser.candidateReturnType.isVoid()) {
            if (targetType.isPrimitive()) {
                return targetType.getBoxedEquivalent().isAssignableTo(analyser.candidateReturnType.getBoxedEquivalent());
            }
            if (!analyser.candidateReturnType.isAssignableTo(targetType)) {
                return false;
            }
        }
        return true;
    }

    private boolean isPrimitiveToObject(Type type, Type isAssignableTo) {
        if (isAssignableTo.isPrimitive()) {
            return !type.isPrimitive();
        }
        return false;
    }

    private static class TypeVarCandidate {
        private Type match;
        private List<Type.ResolvedPair> pairs = new ArrayList<Type.ResolvedPair>();

        private TypeVarCandidate() {
        }
    }

    private static class GenericAnalyser {
        private TypeFactory typeFactory;
        private TypeUtils typeUtils;
        private Method candidateMethod;
        private List<Type> sourceTypes;
        private Type targetType;
        Type candidateReturnType = null;
        List<Type> candidateParTypes;

        GenericAnalyser(TypeFactory typeFactory, TypeUtils typeUtils, Method candidateMethod, List<Type> sourceTypes, Type targetType) {
            this.typeFactory = typeFactory;
            this.typeUtils = typeUtils;
            this.candidateMethod = candidateMethod;
            this.sourceTypes = sourceTypes;
            this.targetType = targetType;
        }

        private boolean lineUp() {
            if (this.candidateMethod.getParameters().size() != this.sourceTypes.size()) {
                return false;
            }
            if (!this.candidateMethod.getTypeParameters().isEmpty()) {
                this.candidateParTypes = new ArrayList<Type>();
                HashMap<Type, TypeVarCandidate> methodParCandidates = new HashMap<Type, TypeVarCandidate>();
                boolean success = this.getCandidates(methodParCandidates);
                if (!success) {
                    return false;
                }
                boolean withinBounds = this.candidatesWithinBounds(methodParCandidates);
                if (!withinBounds) {
                    return false;
                }
                HashMap<Type, Type> resolvedPairs = new HashMap<Type, Type>();
                for (TypeVarCandidate candidate : methodParCandidates.values()) {
                    for (Type.ResolvedPair pair : candidate.pairs) {
                        resolvedPairs.put(pair.getParameter(), pair.getMatch());
                    }
                }
                int nrOfMethodPars = this.candidateMethod.getParameters().size();
                for (int i = 0; i < nrOfMethodPars; ++i) {
                    Type candidateType = this.resolve(this.candidateMethod.getParameters().get(i).getType(), resolvedPairs);
                    if (candidateType == null) {
                        return false;
                    }
                    this.candidateParTypes.add(candidateType);
                }
                if (!this.candidateMethod.getReturnType().isVoid()) {
                    this.candidateReturnType = this.resolve(this.candidateMethod.getReturnType(), resolvedPairs);
                    if (this.candidateReturnType == null) {
                        return false;
                    }
                } else {
                    this.candidateReturnType = this.candidateMethod.getReturnType();
                }
            } else {
                this.candidateParTypes = this.candidateMethod.getParameters().stream().map(Parameter::getType).collect(Collectors.toList());
                this.candidateReturnType = this.candidateMethod.getReturnType();
            }
            return true;
        }

        boolean getCandidates(Map<Type, TypeVarCandidate> methodParCandidates) {
            boolean success;
            int nrOfMethodPars = this.candidateMethod.getParameters().size();
            Type returnType = this.candidateMethod.getReturnType();
            for (int i = 0; i < nrOfMethodPars; ++i) {
                Type sourceType = this.sourceTypes.get(i);
                Parameter par = this.candidateMethod.getParameters().get(i);
                Type parType = par.getType();
                boolean success2 = this.getCandidates(parType, sourceType, methodParCandidates);
                if (success2) continue;
                return false;
            }
            return returnType.isVoid() || (success = this.getCandidates(returnType, this.targetType, methodParCandidates));
        }

        boolean getCandidates(Type aCandidateMethodType, Type matchingType, Map<Type, TypeVarCandidate> candidates) {
            if (!(aCandidateMethodType.isTypeVar() || aCandidateMethodType.isArrayTypeVar() || aCandidateMethodType.isWildCardBoundByTypeVar() || this.hasGenericTypeParameters(aCandidateMethodType))) {
                return true;
            }
            boolean foundAMatch = false;
            for (Type mthdParType : this.candidateMethod.getTypeParameters()) {
                TypeVarCandidate typeVarCandidate;
                Type.ResolvedPair resolved = mthdParType.resolveParameterToType(matchingType, aCandidateMethodType);
                if (resolved.getMatch() == null) continue;
                foundAMatch = true;
                if (candidates.containsKey(mthdParType)) {
                    typeVarCandidate = candidates.get(mthdParType);
                } else {
                    typeVarCandidate = new TypeVarCandidate();
                    candidates.put(mthdParType, typeVarCandidate);
                }
                if (resolved.getParameter().isTypeVar()) {
                    if (typeVarCandidate.match == null) {
                        typeVarCandidate.match = resolved.getMatch();
                        typeVarCandidate.pairs.add(resolved);
                        continue;
                    }
                    if (this.areEquivalent(resolved.getMatch(), typeVarCandidate.match)) continue;
                    return false;
                }
                if (resolved.getParameter().isArrayTypeVar() && resolved.getParameter().getComponentType().isAssignableTo(mthdParType)) {
                    typeVarCandidate.pairs.add(resolved);
                    continue;
                }
                if (resolved.getParameter().isWildCardBoundByTypeVar() && resolved.getParameter().getTypeBound().isAssignableTo(mthdParType)) {
                    typeVarCandidate.pairs.add(resolved);
                    continue;
                }
                return false;
            }
            return foundAMatch;
        }

        private boolean candidatesWithinBounds(Map<Type, TypeVarCandidate> methodParCandidates) {
            for (Map.Entry<Type, TypeVarCandidate> entry : methodParCandidates.entrySet()) {
                for (Type bound : entry.getKey().getTypeBounds()) {
                    for (Type.ResolvedPair pair : entry.getValue().pairs) {
                        if (!(entry.getKey().hasUpperBound() ? !pair.getMatch().asRawType().isAssignableTo(bound.asRawType()) : !bound.asRawType().isAssignableTo(pair.getMatch().asRawType()))) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        private boolean hasGenericTypeParameters(Type typeFromCandidateMethod) {
            for (Type typeParam : typeFromCandidateMethod.getTypeParameters()) {
                if (typeParam.isTypeVar() || typeParam.isWildCardBoundByTypeVar() || typeParam.isArrayTypeVar()) {
                    return true;
                }
                if (!this.hasGenericTypeParameters(typeParam)) continue;
                return true;
            }
            return false;
        }

        private Type resolve(Type typeFromCandidateMethod, Map<Type, Type> pairs) {
            if (typeFromCandidateMethod.isTypeVar() || typeFromCandidateMethod.isArrayTypeVar()) {
                return pairs.get(typeFromCandidateMethod);
            }
            if (this.hasGenericTypeParameters(typeFromCandidateMethod)) {
                TypeMirror[] typeArgs = new TypeMirror[typeFromCandidateMethod.getTypeParameters().size()];
                for (int i = 0; i < typeFromCandidateMethod.getTypeParameters().size(); ++i) {
                    Type matchingType;
                    Type typeFromCandidateMethodTypeParameter = typeFromCandidateMethod.getTypeParameters().get(i);
                    if (this.hasGenericTypeParameters(typeFromCandidateMethodTypeParameter)) {
                        matchingType = this.resolve(typeFromCandidateMethodTypeParameter, pairs);
                        if (matchingType == null) {
                            return null;
                        }
                        typeArgs[i] = matchingType.getTypeMirror();
                        continue;
                    }
                    if (typeFromCandidateMethodTypeParameter.isWildCardBoundByTypeVar() || typeFromCandidateMethodTypeParameter.isTypeVar() || typeFromCandidateMethodTypeParameter.isArrayTypeVar()) {
                        matchingType = pairs.get(typeFromCandidateMethodTypeParameter);
                        if (matchingType == null) {
                            return null;
                        }
                        typeArgs[i] = matchingType.getBoxedEquivalent().getTypeMirror();
                        continue;
                    }
                    typeArgs[i] = typeFromCandidateMethodTypeParameter.getTypeMirror();
                }
                DeclaredType typeArg = this.typeUtils.getDeclaredType(typeFromCandidateMethod.getTypeElement(), typeArgs);
                return this.typeFactory.getType(typeArg);
            }
            return typeFromCandidateMethod;
        }

        boolean areEquivalent(Type a, Type b) {
            if (a == null || b == null) {
                return false;
            }
            return a.getBoxedEquivalent().equals(b.getBoxedEquivalent());
        }
    }
}

