/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.descriptor.parsers;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.processing.core.util.NamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SamlDescriptorIDPKeysExtractor {
    private static final NamespaceContext NS_CONTEXT = new NamespaceContext();
    private final KeyInfoFactory kif = KeyInfoFactory.getInstance();
    private final XPathFactory xPathfactory = XPathFactory.newInstance();
    private final XPath xpath = this.xPathfactory.newXPath();

    public SamlDescriptorIDPKeysExtractor() {
        this.xpath.setNamespaceContext((javax.xml.namespace.NamespaceContext)NS_CONTEXT);
    }

    public MultivaluedHashMap<String, KeyInfo> parse(InputStream stream) throws ParsingException {
        MultivaluedHashMap res = new MultivaluedHashMap();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(stream);
            XPathExpression expr = this.xpath.compile("/m:EntitiesDescriptor/m:EntityDescriptor/m:IDPSSODescriptor/m:KeyDescriptor");
            NodeList keyDescriptors = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < keyDescriptors.getLength(); ++i) {
                Node keyDescriptor = keyDescriptors.item(i);
                Element keyDescriptorEl = (Element)keyDescriptor;
                KeyInfo ki = this.processKeyDescriptor(keyDescriptorEl);
                if (ki == null) continue;
                String use = keyDescriptorEl.getAttribute(JBossSAMLConstants.USE.get());
                res.add((Object)use, (Object)ki);
            }
        }
        catch (IOException | MarshalException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new ParsingException("Error parsing SAML descriptor", (Throwable)e);
        }
        return res;
    }

    private KeyInfo processKeyDescriptor(Element keyDescriptor) throws MarshalException {
        NodeList childNodes = keyDescriptor.getElementsByTagNameNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), JBossSAMLConstants.KEY_INFO.get());
        if (childNodes.getLength() == 0) {
            return null;
        }
        Node keyInfoNode = childNodes.item(0);
        return keyInfoNode == null ? null : this.kif.unmarshalKeyInfo(new DOMStructure(keyInfoNode));
    }

    static {
        NS_CONTEXT.addNsUriPair("m", JBossSAMLURIConstants.METADATA_NSURI.get());
        NS_CONTEXT.addNsUriPair("dsig", JBossSAMLURIConstants.XMLDSIG_NSURI.get());
    }
}

