/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.def;

import java.security.spec.ECParameterSpec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.keycloak.common.crypto.CertificateUtilsProvider;
import org.keycloak.common.crypto.CryptoProvider;
import org.keycloak.common.crypto.PemUtilsProvider;
import org.keycloak.crypto.def.AesKeyWrapAlgorithmProvider;
import org.keycloak.crypto.def.BCCertificateUtilsProvider;
import org.keycloak.crypto.def.BCPemUtilsProvider;

public class DefaultCryptoProvider
implements CryptoProvider {
    private Map<String, Object> providers = new ConcurrentHashMap<String, Object>();

    public DefaultCryptoProvider() {
        this.providers.put("bc-provider", new BouncyCastleProvider());
        this.providers.put("aes-keywrap-alg", new AesKeyWrapAlgorithmProvider());
    }

    public <T> T getAlgorithmProvider(Class<T> clazz, String algorithm) {
        Object o = this.providers.get(algorithm);
        if (o == null) {
            throw new IllegalArgumentException("Not found provider of algorithm: " + algorithm);
        }
        return clazz.cast(o);
    }

    public CertificateUtilsProvider getCertificateUtils() {
        return new BCCertificateUtilsProvider();
    }

    public PemUtilsProvider getPemUtils() {
        return new BCPemUtilsProvider();
    }

    public ECParameterSpec createECParams(String curveName) {
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)curveName);
        return new ECNamedCurveSpec("prime256v1", spec.getCurve(), spec.getG(), spec.getN());
    }
}

