/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.sdjwt.SdJwtSalt;
import org.keycloak.sdjwt.SdJwtUtils;
import org.keycloak.sdjwt.UndisclosedClaim;

public class UndisclosedClaimTest {
    @Before
    public void setUp() throws Exception {
        SdJwtUtils.arrayEltSpaced = false;
    }

    @After
    public void tearDown() throws Exception {
        SdJwtUtils.arrayEltSpaced = true;
    }

    @Test
    public void testToBase64urlEncoded() {
        UndisclosedClaim undisclosedClaim = UndisclosedClaim.builder().withClaimName("family_name").withSalt(new SdJwtSalt("_26bc4LT-ac6q2KI6cBW5es")).withClaimValue((JsonNode)new TextNode("M\u00f6bius")).build();
        String expected = "WyJfMjZiYzRMVC1hYzZxMktJNmNCVzVlcyIsImZhbWlseV9uYW1lIiwiTcO2Yml1cyJd";
        Assert.assertEquals((Object)expected, undisclosedClaim.getDisclosureStrings().get(0));
    }
}

