/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.jose.jws.crypto.HashUtils;

public class HashTest {
    @Test
    public void testSha256Hash() throws Exception {
        this.testSha256Hash("myCodeVerifier", StandardCharsets.ISO_8859_1, "rxrlnYFwTggx1TzJeKXupM_TAJia_vbHD35PIlq9tRg");
        this.testSha256Hash("myCodeVerifier", StandardCharsets.UTF_8, "rxrlnYFwTggx1TzJeKXupM_TAJia_vbHD35PIlq9tRg");
        this.testSha256Hash("Some1[^&*$#", StandardCharsets.ISO_8859_1, "lXO5GHk4DoCxiStRrpJgQ-cOnJQmJTb2gh3HJ3Ueq9U");
        this.testSha256Hash("Some1[^&*$#", StandardCharsets.UTF_8, "lXO5GHk4DoCxiStRrpJgQ-cOnJQmJTb2gh3HJ3Ueq9U");
        this.testSha256Hash("kr\u00e1k", StandardCharsets.ISO_8859_1, "XD3Gb_rLS49onF_rOsTWc7SLa27Vny8AHgmoEOmJx5s");
        this.testSha256Hash("kr\u00e1k", StandardCharsets.UTF_8, "QKvM6HItSe5Yi0rQqQgIFhyKhQJCNr4H60eP3YgcjpU");
    }

    private void testSha256Hash(String codeVerifier, Charset charset, String expectedHash) {
        String hash1 = HashUtils.sha256UrlEncodedHash((String)codeVerifier, (Charset)charset);
        Assert.assertEquals((Object)hash1, (Object)expectedHash);
    }
}

