/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jodconverter.office.OfficeManager;
import org.jodconverter.office.OfficeManagerConfig;
import org.jodconverter.office.TemporaryFileMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractOfficeManager
implements OfficeManager,
TemporaryFileMaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOfficeManager.class);
    protected final OfficeManagerConfig config;
    private final AtomicLong tempFileCounter;
    private File tempDir;

    protected static File makeTempDir(File workingDir) {
        File tempDir = new File(workingDir, "jodconverter_" + UUID.randomUUID().toString());
        tempDir.mkdir();
        if (!tempDir.isDirectory()) {
            throw new IllegalStateException(String.format("Cannot create temp directory: %s", tempDir));
        }
        return tempDir;
    }

    protected AbstractOfficeManager(OfficeManagerConfig config) {
        this.config = config;
        this.tempFileCounter = new AtomicLong(0L);
    }

    @Override
    public File makeTemporaryFile() {
        return new File(this.tempDir, "tempfile_" + this.tempFileCounter.getAndIncrement());
    }

    @Override
    public File makeTemporaryFile(String extension) {
        return new File(this.tempDir, "tempfile_" + this.tempFileCounter.getAndIncrement() + "." + extension);
    }

    protected void makeTempDir() {
        this.deleteTempDir();
        this.tempDir = AbstractOfficeManager.makeTempDir(this.config.getWorkingDir());
    }

    protected void deleteTempDir() {
        if (this.tempDir != null) {
            LOGGER.debug("Deleting temporary directory '{}'", (Object)this.tempDir);
            try {
                FileUtils.deleteDirectory((File)this.tempDir);
            }
            catch (IOException ioEx) {
                LOGGER.error("Could not temporary profileDir: {}", (Object)ioEx.getMessage());
            }
        }
    }

    public static abstract class AbstractOfficeManagerBuilder<B extends AbstractOfficeManagerBuilder<B>> {
        protected boolean install;
        protected File workingDir;

        protected AbstractOfficeManagerBuilder() {
        }

        public B install() {
            this.install = true;
            return (B)this;
        }

        public B workingDir(File workingDir) {
            this.workingDir = workingDir;
            return (B)this;
        }

        public B workingDir(String workingDir) {
            return (B)(StringUtils.isBlank((CharSequence)workingDir) ? this : this.workingDir(new File(workingDir)));
        }

        protected abstract AbstractOfficeManager build();
    }
}

