/*
 * Decompiled with CFR 0.152.
 */
package org.joda.money;

import org.joda.money.BigMoney;
import org.joda.money.BigMoneyProvider;
import org.joda.money.Money;

public final class MoneyUtils {
    static void checkNotNull(Object object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
    }

    private MoneyUtils() {
    }

    public static boolean isZero(BigMoneyProvider moneyProvider) {
        return moneyProvider == null || moneyProvider.toBigMoney().isZero();
    }

    public static boolean isPositive(BigMoneyProvider moneyProvider) {
        return moneyProvider != null && moneyProvider.toBigMoney().isPositive();
    }

    public static boolean isPositiveOrZero(BigMoneyProvider moneyProvider) {
        return moneyProvider == null || moneyProvider.toBigMoney().isPositiveOrZero();
    }

    public static boolean isNegative(BigMoneyProvider moneyProvider) {
        return moneyProvider != null && moneyProvider.toBigMoney().isNegative();
    }

    public static boolean isNegativeOrZero(BigMoneyProvider moneyProvider) {
        return moneyProvider == null || moneyProvider.toBigMoney().isNegativeOrZero();
    }

    public static Money max(Money money1, Money money2) {
        if (money1 == null) {
            return money2;
        }
        if (money2 == null) {
            return money1;
        }
        return money1.compareTo(money2) > 0 ? money1 : money2;
    }

    public static Money min(Money money1, Money money2) {
        if (money1 == null) {
            return money2;
        }
        if (money2 == null) {
            return money1;
        }
        return money1.compareTo(money2) < 0 ? money1 : money2;
    }

    public static Money add(Money money1, Money money2) {
        if (money1 == null) {
            return money2;
        }
        if (money2 == null) {
            return money1;
        }
        return money1.plus(money2);
    }

    public static Money subtract(Money money1, Money money2) {
        if (money2 == null) {
            return money1;
        }
        if (money1 == null) {
            return money2.negated();
        }
        return money1.minus(money2);
    }

    public static BigMoney max(BigMoney money1, BigMoney money2) {
        if (money1 == null) {
            return money2;
        }
        if (money2 == null) {
            return money1;
        }
        return money1.compareTo(money2) > 0 ? money1 : money2;
    }

    public static BigMoney min(BigMoney money1, BigMoney money2) {
        if (money1 == null) {
            return money2;
        }
        if (money2 == null) {
            return money1;
        }
        return money1.compareTo(money2) < 0 ? money1 : money2;
    }

    public static BigMoney add(BigMoney money1, BigMoney money2) {
        if (money1 == null) {
            return money2;
        }
        if (money2 == null) {
            return money1;
        }
        return money1.plus(money2);
    }

    public static BigMoney subtract(BigMoney money1, BigMoney money2) {
        if (money2 == null) {
            return money1;
        }
        if (money1 == null) {
            return money2.negated();
        }
        return money1.minus(money2);
    }
}

