/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.maven.KotlinCompileMojoBase;
import org.jetbrains.kotlin.utils.LibraryUtils;

@Mojo(name="js", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class K2JSCompilerMojo
extends KotlinCompileMojoBase<K2JSCompilerArguments> {
    private static final String OUTPUT_DIRECTORIES_COLLECTOR_PROPERTY_NAME = "outputDirectoriesCollector";
    private static final Lock lock = new ReentrantLock();
    @Parameter(defaultValue="${project.build.directory}/js/${project.artifactId}.js", required=true)
    private String outputFile;
    @Parameter(defaultValue="true")
    private boolean metaInfo;
    @Parameter(defaultValue="false")
    private boolean sourceMap;
    @Parameter
    private String sourceMapPrefix;
    @Parameter(defaultValue="inlining")
    private String sourceMapEmbedSources;
    @Parameter
    private String main;
    @Parameter(defaultValue="plain")
    private String moduleKind;

    @Override
    protected void configureSpecificCompilerArguments(@NotNull K2JSCompilerArguments arguments, @NotNull List<File> sourceRoots) throws MojoExecutionException {
        List<String> libraries;
        arguments.setOutputFile(this.outputFile);
        arguments.setNoStdlib(true);
        arguments.setMetaInfo(this.metaInfo);
        arguments.setModuleKind(this.moduleKind);
        arguments.setMain(this.main);
        try {
            libraries = this.getKotlinJavascriptLibraryFiles();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Unresolved dependencies", (Exception)((Object)e));
        }
        this.getLog().debug((CharSequence)("libraries: " + libraries));
        arguments.setLibraries(StringUtil.join(libraries, (String)File.pathSeparator));
        arguments.setSourceMap(this.sourceMap);
        arguments.setSourceMapPrefix(this.sourceMapPrefix);
        arguments.setSourceMapEmbedSources(this.sourceMapEmbedSources);
        if (this.outputFile != null) {
            ConcurrentMap<String, List<String>> collector = this.getOutputDirectoriesCollector();
            String key = this.project.getArtifactId();
            List paths = collector.computeIfAbsent(key, k -> Collections.synchronizedList(new ArrayList()));
            paths.add(new File(this.outputFile).getParent());
        }
        StringBuilder sourceMapSourceRoots = new StringBuilder();
        if (!sourceRoots.isEmpty()) {
            sourceMapSourceRoots.append(sourceRoots.get(0).getAbsolutePath());
            for (int i = 1; i < sourceRoots.size(); ++i) {
                sourceMapSourceRoots.append(File.pathSeparator);
                sourceMapSourceRoots.append(sourceRoots.get(i).getAbsolutePath());
            }
        }
        arguments.setSourceMapBaseDirs(sourceMapSourceRoots.toString());
    }

    protected List<String> getClassPathElements() throws DependencyResolutionRequiredException {
        return this.project.getCompileClasspathElements();
    }

    @NotNull
    private List<String> getKotlinJavascriptLibraryFiles() throws DependencyResolutionRequiredException {
        ArrayList<String> libraries = new ArrayList<String>();
        for (String path : this.getClassPathElements()) {
            File file = new File(path);
            if (file.exists() && LibraryUtils.isKotlinJavascriptLibrary((File)file)) {
                libraries.add(file.getAbsolutePath());
                continue;
            }
            this.getLog().debug((CharSequence)("artifact " + file.getAbsolutePath() + " is not a Kotlin Javascript Library"));
        }
        for (List paths : this.getOutputDirectoriesCollector().values()) {
            for (String path : paths) {
                File file = new File(path);
                if (file.exists() && LibraryUtils.isKotlinJavascriptLibrary((File)file)) {
                    libraries.add(file.getAbsolutePath());
                    continue;
                }
                this.getLog().debug((CharSequence)("JS output directory missing: " + file));
            }
        }
        return libraries;
    }

    @Override
    @NotNull
    protected K2JSCompilerArguments createCompilerArguments() {
        return new K2JSCompilerArguments();
    }

    @Override
    protected List<String> getRelatedSourceRoots(MavenProject project) {
        return project.getCompileSourceRoots();
    }

    @NotNull
    protected K2JSCompiler createCompiler() {
        return new K2JSCompiler();
    }

    protected ConcurrentMap<String, List<String>> getOutputDirectoriesCollector() {
        lock.lock();
        try {
            ConcurrentSkipListMap<String, List<String>> collector = (ConcurrentSkipListMap<String, List<String>>)this.getPluginContext().get(OUTPUT_DIRECTORIES_COLLECTOR_PROPERTY_NAME);
            if (collector == null) {
                collector = new ConcurrentSkipListMap<String, List<String>>();
                this.getPluginContext().put(OUTPUT_DIRECTORIES_COLLECTOR_PROPERTY_NAME, collector);
            }
            ConcurrentSkipListMap<String, List<String>> concurrentSkipListMap = collector;
            return concurrentSkipListMap;
        }
        finally {
            lock.unlock();
        }
    }
}

