/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.AccessorForCompanionObjectInstanceFieldDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.BranchedValue;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.CallableReferenceUtilKt;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.SyntheticClassDescriptorForLambda;
import org.jetbrains.kotlin.codegen.VariableAsmNameManglingUtils;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.intrinsics.HashCode;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.metadata.jvm.serialization.JvmStringTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.InlineClassManglingRulesKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class AsmUtil {
    private static final Set<Type> STRING_BUILDER_OBJECT_APPEND_ARG_TYPES = Sets.newHashSet(AsmTypes.getType(String.class), AsmTypes.getType(StringBuffer.class), AsmTypes.getType(CharSequence.class));
    public static final int NO_FLAG_PACKAGE_PRIVATE = 0;
    @NotNull
    private static final Map<Visibility, Integer> visibilityToAccessFlag = ImmutableMap.builder().put(Visibilities.PRIVATE, 2).put(Visibilities.PRIVATE_TO_THIS, 2).put(Visibilities.PROTECTED, 4).put(JavaVisibilities.PROTECTED_STATIC_VISIBILITY, 4).put(JavaVisibilities.PROTECTED_AND_PACKAGE, 4).put(Visibilities.PUBLIC, 1).put(Visibilities.INTERNAL, 1).put(Visibilities.LOCAL, 0).put(JavaVisibilities.PACKAGE_VISIBILITY, 0).build();
    public static final String CAPTURED_PREFIX = "$";
    public static final String THIS = "this";
    public static final String THIS_IN_DEFAULT_IMPLS = "$this";
    public static final String LABELED_THIS_FIELD = "this_";
    public static final String CAPTURED_LABELED_THIS_FIELD = "$this_";
    public static final String INLINE_DECLARATION_SITE_THIS = "this_";
    public static final String LABELED_THIS_PARAMETER = "$this$";
    public static final String CAPTURED_THIS_FIELD = "this$0";
    public static final String RECEIVER_PARAMETER_NAME = "$receiver";
    public static final String CAPTURED_RECEIVER_FIELD = "receiver$0";
    public static final String BOUND_REFERENCE_RECEIVER = "receiver";
    public static final String LOCAL_FUNCTION_VARIABLE_PREFIX = "$fun$";
    private static final ImmutableMap<Integer, JvmPrimitiveType> primitiveTypeByAsmSort;
    private static final ImmutableMap<Type, Type> primitiveTypeByBoxedType;

    private AsmUtil() {
    }

    @NotNull
    public static String getCapturedFieldName(@NotNull String originalName) {
        if (originalName == null) {
            AsmUtil.$$$reportNull$$$0(0);
        }
        String string2 = CAPTURED_PREFIX + originalName;
        if (string2 == null) {
            AsmUtil.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public static String getNameForCapturedReceiverField(@NotNull CallableDescriptor descriptor2, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(2);
        }
        if (bindingContext == null) {
            AsmUtil.$$$reportNull$$$0(3);
        }
        if (languageVersionSettings == null) {
            AsmUtil.$$$reportNull$$$0(4);
        }
        return AsmUtil.getLabeledThisNameForReceiver(descriptor2, bindingContext, languageVersionSettings, "this_", CAPTURED_RECEIVER_FIELD);
    }

    @NotNull
    public static String getNameForReceiverParameter(@NotNull CallableDescriptor descriptor2, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(5);
        }
        if (bindingContext == null) {
            AsmUtil.$$$reportNull$$$0(6);
        }
        if (languageVersionSettings == null) {
            AsmUtil.$$$reportNull$$$0(7);
        }
        return AsmUtil.getLabeledThisNameForReceiver(descriptor2, bindingContext, languageVersionSettings, LABELED_THIS_PARAMETER, RECEIVER_PARAMETER_NAME);
    }

    @NotNull
    private static String getLabeledThisNameForReceiver(@NotNull CallableDescriptor descriptor2, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull String prefix, @NotNull String defaultName) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(8);
        }
        if (bindingContext == null) {
            AsmUtil.$$$reportNull$$$0(9);
        }
        if (languageVersionSettings == null) {
            AsmUtil.$$$reportNull$$$0(10);
        }
        if (prefix == null) {
            AsmUtil.$$$reportNull$$$0(11);
        }
        if (defaultName == null) {
            AsmUtil.$$$reportNull$$$0(12);
        }
        if (!languageVersionSettings.supportsFeature(LanguageFeature.NewCapturedReceiverFieldNamingConvention)) {
            String string2 = defaultName;
            if (string2 == null) {
                AsmUtil.$$$reportNull$$$0(13);
            }
            return string2;
        }
        Name callableName = null;
        if (descriptor2 instanceof FunctionDescriptor) {
            String labelName = bindingContext.get(CodegenBinding.CALL_LABEL_FOR_LAMBDA_ARGUMENT, (FunctionDescriptor)descriptor2);
            if (labelName != null) {
                return AsmUtil.getLabeledThisName(labelName, prefix, defaultName);
            }
            if (descriptor2 instanceof VariableAccessorDescriptor) {
                VariableAccessorDescriptor accessor = (VariableAccessorDescriptor)descriptor2;
                callableName = accessor.getCorrespondingVariable().getName();
            }
        }
        if (callableName == null) {
            callableName = descriptor2.getName();
        }
        if (callableName.isSpecial()) {
            String string3 = defaultName;
            if (string3 == null) {
                AsmUtil.$$$reportNull$$$0(14);
            }
            return string3;
        }
        return AsmUtil.getLabeledThisName(callableName.asString(), prefix, defaultName);
    }

    @NotNull
    public static String getLabeledThisName(@NotNull String callableName, @NotNull String prefix, @NotNull String defaultName) {
        if (callableName == null) {
            AsmUtil.$$$reportNull$$$0(15);
        }
        if (prefix == null) {
            AsmUtil.$$$reportNull$$$0(16);
        }
        if (defaultName == null) {
            AsmUtil.$$$reportNull$$$0(17);
        }
        if (!Name.isValidIdentifier(callableName)) {
            String string2 = defaultName;
            if (string2 == null) {
                AsmUtil.$$$reportNull$$$0(18);
            }
            return string2;
        }
        String string3 = prefix + VariableAsmNameManglingUtils.mangleNameIfNeeded(callableName);
        if (string3 == null) {
            AsmUtil.$$$reportNull$$$0(19);
        }
        return string3;
    }

    @NotNull
    public static Type boxType(@NotNull Type type2) {
        Type boxedType;
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(20);
        }
        Type type3 = (boxedType = AsmUtil.boxPrimitiveType(type2)) != null ? boxedType : type2;
        if (type3 == null) {
            AsmUtil.$$$reportNull$$$0(21);
        }
        return type3;
    }

    @NotNull
    public static Type boxType(@NotNull Type type2, @NotNull KotlinType kotlinType, @NotNull KotlinTypeMapper typeMapper) {
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(22);
        }
        if (kotlinType == null) {
            AsmUtil.$$$reportNull$$$0(23);
        }
        if (typeMapper == null) {
            AsmUtil.$$$reportNull$$$0(24);
        }
        if (InlineClassesUtilsKt.isInlineClassType(kotlinType)) {
            Type type3 = typeMapper.mapTypeAsDeclaration(kotlinType);
            if (type3 == null) {
                AsmUtil.$$$reportNull$$$0(25);
            }
            return type3;
        }
        Type boxedPrimitiveType = AsmUtil.boxPrimitiveType(type2);
        Type type4 = boxedPrimitiveType != null ? boxedPrimitiveType : type2;
        if (type4 == null) {
            AsmUtil.$$$reportNull$$$0(26);
        }
        return type4;
    }

    @Nullable
    public static Type boxPrimitiveType(@NotNull Type type2) {
        JvmPrimitiveType jvmPrimitiveType;
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(27);
        }
        return (jvmPrimitiveType = primitiveTypeByAsmSort.get(type2.getSort())) != null ? AsmUtil.asmTypeByFqNameWithoutInnerClasses(jvmPrimitiveType.getWrapperFqName()) : null;
    }

    @NotNull
    public static Type unboxType(@NotNull Type boxedType) {
        Type primitiveType;
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(28);
        }
        if ((primitiveType = AsmUtil.unboxPrimitiveTypeOrNull(boxedType)) == null) {
            throw new UnsupportedOperationException("Unboxing: " + boxedType);
        }
        Type type2 = primitiveType;
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(29);
        }
        return type2;
    }

    @Nullable
    public static Type unboxPrimitiveTypeOrNull(@NotNull Type boxedType) {
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(30);
        }
        return primitiveTypeByBoxedType.get(boxedType);
    }

    public static boolean isBoxedPrimitiveType(@NotNull Type boxedType) {
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(31);
        }
        return primitiveTypeByBoxedType.get(boxedType) != null;
    }

    @NotNull
    public static Type unboxUnlessPrimitive(@NotNull Type boxedOrPrimitiveType) {
        if (boxedOrPrimitiveType == null) {
            AsmUtil.$$$reportNull$$$0(32);
        }
        if (AsmUtil.isPrimitive(boxedOrPrimitiveType)) {
            Type type2 = boxedOrPrimitiveType;
            if (type2 == null) {
                AsmUtil.$$$reportNull$$$0(33);
            }
            return type2;
        }
        return AsmUtil.unboxType(boxedOrPrimitiveType);
    }

    public static boolean isBoxedTypeOf(@NotNull Type boxedType, @NotNull Type unboxedType) {
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(34);
        }
        if (unboxedType == null) {
            AsmUtil.$$$reportNull$$$0(35);
        }
        return AsmUtil.unboxPrimitiveTypeOrNull(boxedType) == unboxedType;
    }

    public static boolean isIntPrimitive(Type type2) {
        return type2 == Type.INT_TYPE || type2 == Type.SHORT_TYPE || type2 == Type.BYTE_TYPE || type2 == Type.CHAR_TYPE;
    }

    public static boolean isIntOrLongPrimitive(Type type2) {
        return AsmUtil.isIntPrimitive(type2) || type2 == Type.LONG_TYPE;
    }

    public static boolean isPrimitive(Type type2) {
        return type2.getSort() != 10 && type2.getSort() != 9;
    }

    public static boolean isPrimitiveNumberClassDescriptor(DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return false;
        }
        return KotlinBuiltIns.isPrimitiveClass((ClassDescriptor)descriptor2) && !KotlinBuiltIns.isBoolean((ClassDescriptor)descriptor2);
    }

    @NotNull
    public static Type correctElementType(@NotNull Type type2) {
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(36);
        }
        String internalName = type2.getInternalName();
        assert (internalName.charAt(0) == '[');
        Type type3 = Type.getType(internalName.substring(1));
        if (type3 == null) {
            AsmUtil.$$$reportNull$$$0(37);
        }
        return type3;
    }

    @NotNull
    public static Type getArrayType(@NotNull Type componentType) {
        if (componentType == null) {
            AsmUtil.$$$reportNull$$$0(38);
        }
        Type type2 = Type.getType("[" + componentType.getDescriptor());
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(39);
        }
        return type2;
    }

    @Nullable
    public static PrimitiveType asmPrimitiveTypeToLangPrimitiveType(Type type2) {
        JvmPrimitiveType jvmPrimitiveType = primitiveTypeByAsmSort.get(type2.getSort());
        return jvmPrimitiveType != null ? jvmPrimitiveType.getPrimitiveType() : null;
    }

    @NotNull
    public static Method method(@NotNull String name, @NotNull Type returnType2, Type ... parameterTypes) {
        if (name == null) {
            AsmUtil.$$$reportNull$$$0(40);
        }
        if (returnType2 == null) {
            AsmUtil.$$$reportNull$$$0(41);
        }
        if (parameterTypes == null) {
            AsmUtil.$$$reportNull$$$0(42);
        }
        return new Method(name, Type.getMethodDescriptor(returnType2, parameterTypes));
    }

    public static boolean isAbstractMethod(FunctionDescriptor functionDescriptor, OwnerKind kind) {
        return (functionDescriptor.getModality() == Modality.ABSTRACT || JvmCodegenUtil.isJvmInterface(functionDescriptor.getContainingDeclaration()) && !JvmAnnotationUtilKt.hasJvmDefaultAnnotation(functionDescriptor)) && !AsmUtil.isStaticMethod(kind, functionDescriptor);
    }

    public static boolean isStaticMethod(OwnerKind kind, CallableMemberDescriptor functionDescriptor) {
        return AsmUtil.isStaticKind(kind) || KotlinTypeMapper.isStaticAccessor(functionDescriptor) || CodegenUtilKt.isJvmStaticInObjectOrClassOrInterface(functionDescriptor);
    }

    public static boolean isStaticKind(OwnerKind kind) {
        return kind == OwnerKind.PACKAGE || kind == OwnerKind.DEFAULT_IMPLS || kind == OwnerKind.ERASED_INLINE_CLASS;
    }

    public static int getMethodAsmFlags(FunctionDescriptor functionDescriptor, OwnerKind kind, GenerationState state) {
        return AsmUtil.getMethodAsmFlags(functionDescriptor, kind, state.getDeprecationProvider());
    }

    public static int getMethodAsmFlags(FunctionDescriptor functionDescriptor, OwnerKind kind, DeprecationResolver deprecationResolver) {
        DeclarationDescriptor containingDeclaration;
        int flags = AsmUtil.getCommonCallableFlags(functionDescriptor, kind, deprecationResolver);
        for (AnnotationCodegen.JvmFlagAnnotation flagAnnotation : AnnotationCodegen.METHOD_FLAGS) {
            flags |= flagAnnotation.getJvmFlag(functionDescriptor.getOriginal());
        }
        if (functionDescriptor.getOriginal().isExternal()) {
            flags |= 0x100;
        }
        if (CodegenUtilKt.isJvmStaticInCompanionObject(functionDescriptor)) {
            flags &= 0xFFFFFEFF;
        }
        if (!(functionDescriptor.getModality() != Modality.FINAL || functionDescriptor instanceof ConstructorDescriptor || (containingDeclaration = functionDescriptor.getContainingDeclaration()) instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.INTERFACE)) {
            flags |= 0x10;
        }
        if (AsmUtil.isStaticMethod(kind, functionDescriptor)) {
            flags |= 8;
        }
        if (AsmUtil.isAbstractMethod(functionDescriptor, kind)) {
            flags |= 0x400;
        }
        if (KotlinTypeMapper.isAccessor(functionDescriptor) || JvmAnnotationUtilKt.hasJvmSyntheticAnnotation(functionDescriptor) || AsmUtil.isInlineClassWrapperConstructor(functionDescriptor, kind) || InlineClassDescriptorResolver.isSynthesizedBoxMethod(functionDescriptor) || InlineClassDescriptorResolver.isSynthesizedUnboxMethod(functionDescriptor)) {
            flags |= 0x1000;
        }
        return flags;
    }

    private static boolean isInlineClassWrapperConstructor(@NotNull FunctionDescriptor functionDescriptor, @Nullable OwnerKind kind) {
        if (functionDescriptor == null) {
            AsmUtil.$$$reportNull$$$0(43);
        }
        if (!(functionDescriptor instanceof ConstructorDescriptor)) {
            return false;
        }
        ClassDescriptor classDescriptor2 = ((ConstructorDescriptor)functionDescriptor).getConstructedClass();
        return classDescriptor2.isInline() && kind == OwnerKind.IMPLEMENTATION;
    }

    public static int getCommonCallableFlags(FunctionDescriptor functionDescriptor, @NotNull GenerationState state) {
        if (state == null) {
            AsmUtil.$$$reportNull$$$0(44);
        }
        return AsmUtil.getCommonCallableFlags(functionDescriptor, null, state.getDeprecationProvider());
    }

    private static int getCommonCallableFlags(FunctionDescriptor functionDescriptor, @Nullable OwnerKind kind, @NotNull DeprecationResolver deprecationResolver) {
        if (deprecationResolver == null) {
            AsmUtil.$$$reportNull$$$0(45);
        }
        int flags = AsmUtil.getVisibilityAccessFlag(functionDescriptor, kind);
        flags |= AsmUtil.getVarargsFlag(functionDescriptor);
        flags |= AsmUtil.getDeprecatedAccessFlag(functionDescriptor);
        if (deprecationResolver.isDeprecatedHidden(functionDescriptor) || InlineOnlyKt.isInlineWithReified(functionDescriptor) || functionDescriptor.isSuspend() && functionDescriptor.getVisibility().equals(Visibilities.PRIVATE)) {
            flags |= 0x1000;
        }
        return flags;
    }

    public static int getVisibilityAccessFlag(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(46);
        }
        return AsmUtil.getVisibilityAccessFlag(descriptor2, null);
    }

    private static int getVisibilityAccessFlag(@NotNull MemberDescriptor descriptor2, @Nullable OwnerKind kind) {
        Integer specialCase;
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(47);
        }
        if ((specialCase = AsmUtil.specialCaseVisibility(descriptor2, kind)) != null) {
            return specialCase;
        }
        Visibility visibility = descriptor2.getVisibility();
        Integer defaultMapping = AsmUtil.getVisibilityAccessFlag(visibility);
        if (defaultMapping == null) {
            throw new IllegalStateException(visibility + " is not a valid visibility in backend for " + DescriptorRenderer.DEBUG_TEXT.render(descriptor2));
        }
        return defaultMapping;
    }

    @Nullable
    public static Integer getVisibilityAccessFlag(Visibility visibility) {
        return visibilityToAccessFlag.get(visibility);
    }

    public static int getVisibilityAccessFlagForClass(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(48);
        }
        if (descriptor2 instanceof SyntheticClassDescriptorForLambda) {
            return AsmUtil.getVisibilityAccessFlagForAnonymous(descriptor2);
        }
        if (ExpectedActualDeclarationChecker.isOptionalAnnotationClass(descriptor2)) {
            return 0;
        }
        if (descriptor2.getKind() == ClassKind.ENUM_ENTRY) {
            return 0;
        }
        if (descriptor2.getVisibility() == Visibilities.PUBLIC || descriptor2.getVisibility() == Visibilities.PROTECTED || descriptor2.getVisibility() == Visibilities.LOCAL || descriptor2.getVisibility() == Visibilities.INTERNAL) {
            return 1;
        }
        return 0;
    }

    private static int getVisibilityAccessFlagForAnonymous(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(49);
        }
        return InlineUtil.isInlineOrContainingInline(descriptor2.getContainingDeclaration()) ? 1 : 0;
    }

    public static int getSyntheticAccessFlagForLambdaClass(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(50);
        }
        return descriptor2 instanceof SyntheticClassDescriptorForLambda && ((SyntheticClassDescriptorForLambda)descriptor2).isCallableReference() ? 4096 : 0;
    }

    public static int calculateInnerClassAccessFlags(@NotNull ClassDescriptor innerClass) {
        if (innerClass == null) {
            AsmUtil.$$$reportNull$$$0(51);
        }
        int visibility = innerClass instanceof SyntheticClassDescriptorForLambda ? AsmUtil.getVisibilityAccessFlagForAnonymous(innerClass) : (innerClass.getVisibility() == Visibilities.LOCAL ? 1 : AsmUtil.getVisibilityAccessFlag(innerClass));
        return visibility | AsmUtil.getSyntheticAccessFlagForLambdaClass(innerClass) | AsmUtil.innerAccessFlagsForModalityAndKind(innerClass) | (innerClass.isInner() ? 0 : 8);
    }

    private static int innerAccessFlagsForModalityAndKind(@NotNull ClassDescriptor innerClass) {
        if (innerClass == null) {
            AsmUtil.$$$reportNull$$$0(52);
        }
        switch (innerClass.getKind()) {
            case INTERFACE: {
                return 1536;
            }
            case ENUM_CLASS: {
                return 16400;
            }
            case ANNOTATION_CLASS: {
                return 9728;
            }
        }
        Modality modality = innerClass.getModality();
        if (modality == Modality.FINAL) {
            return 16;
        }
        if (modality == Modality.ABSTRACT || modality == Modality.SEALED) {
            return 1024;
        }
        return 0;
    }

    public static int getDeprecatedAccessFlag(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(53);
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return KotlinBuiltIns.isDeprecated(descriptor2) ? 131072 : AsmUtil.getDeprecatedAccessFlag(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty());
        }
        if (KotlinBuiltIns.isDeprecated(descriptor2)) {
            return 131072;
        }
        return 0;
    }

    private static int getVarargsFlag(FunctionDescriptor functionDescriptor) {
        if (!functionDescriptor.getValueParameters().isEmpty() && functionDescriptor.getValueParameters().get(functionDescriptor.getValueParameters().size() - 1).getVarargElementType() != null) {
            return 128;
        }
        return 0;
    }

    @Nullable
    private static Integer specialCaseVisibility(@NotNull MemberDescriptor memberDescriptor, @Nullable OwnerKind kind) {
        PropertyDescriptor property;
        if (memberDescriptor == null) {
            AsmUtil.$$$reportNull$$$0(54);
        }
        DeclarationDescriptor containingDeclaration = memberDescriptor.getContainingDeclaration();
        Visibility memberVisibility = memberDescriptor.getVisibility();
        if (JvmCodegenUtil.isNonIntrinsicPrivateCompanionObjectInInterface(memberDescriptor)) {
            return 1;
        }
        if (memberDescriptor instanceof FunctionDescriptor && AsmUtil.isInlineClassWrapperConstructor((FunctionDescriptor)memberDescriptor, kind)) {
            return 2;
        }
        if (kind != OwnerKind.ERASED_INLINE_CLASS && memberDescriptor instanceof ConstructorDescriptor && !(memberDescriptor instanceof AccessorForConstructorDescriptor) && InlineClassManglingRulesKt.shouldHideConstructorDueToInlineClassTypeValueParameters((ConstructorDescriptor)memberDescriptor)) {
            return 2;
        }
        if (InlineOnlyKt.isInlineOnlyPrivateInBytecode(memberDescriptor)) {
            return 2;
        }
        if (memberVisibility == Visibilities.LOCAL && memberDescriptor instanceof CallableMemberDescriptor) {
            return 1;
        }
        if (DescriptorUtils.isEnumEntry(memberDescriptor)) {
            return 0;
        }
        if (CodegenUtilKt.isToArrayFromCollection(memberDescriptor)) {
            return 1;
        }
        if (memberDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isAnonymousObject(memberDescriptor.getContainingDeclaration())) {
            return AsmUtil.getVisibilityAccessFlagForAnonymous((ClassDescriptor)memberDescriptor.getContainingDeclaration());
        }
        if (memberDescriptor instanceof SyntheticJavaPropertyDescriptor) {
            return AsmUtil.getVisibilityAccessFlag(((SyntheticJavaPropertyDescriptor)memberDescriptor).getGetMethod());
        }
        if (memberDescriptor instanceof PropertyAccessorDescriptor && (property = ((PropertyAccessorDescriptor)memberDescriptor).getCorrespondingProperty()) instanceof SyntheticJavaPropertyDescriptor) {
            FunctionDescriptor method;
            FunctionDescriptor functionDescriptor = method = memberDescriptor == property.getGetter() ? ((SyntheticJavaPropertyDescriptor)property).getGetMethod() : ((SyntheticJavaPropertyDescriptor)property).getSetMethod();
            assert (method != null) : "No get/set method in SyntheticJavaPropertyDescriptor: " + property;
            return AsmUtil.getVisibilityAccessFlag(method);
        }
        if (memberDescriptor instanceof CallableDescriptor && memberVisibility == Visibilities.PROTECTED) {
            for (CallableDescriptor overridden : DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)((Object)memberDescriptor))) {
                if (!JvmCodegenUtil.isJvmInterface(overridden.getContainingDeclaration())) continue;
                return 1;
            }
        }
        if (!Visibilities.isPrivate(memberVisibility)) {
            return null;
        }
        if (memberDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)memberDescriptor).isSuspend()) {
            return 0;
        }
        if (memberDescriptor instanceof AccessorForCompanionObjectInstanceFieldDescriptor) {
            return 0;
        }
        if (memberDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isEnumEntry(containingDeclaration)) {
            return 0;
        }
        return null;
    }

    public static Type stringValueOfType(Type type2) {
        int sort = type2.getSort();
        return sort == 10 || sort == 9 ? AsmTypes.OBJECT_TYPE : (sort == 3 || sort == 4 ? Type.INT_TYPE : type2);
    }

    private static Type stringBuilderAppendType(Type type2) {
        switch (type2.getSort()) {
            case 10: {
                return STRING_BUILDER_OBJECT_APPEND_ARG_TYPES.contains(type2) ? type2 : AsmTypes.OBJECT_TYPE;
            }
            case 9: {
                return AsmTypes.OBJECT_TYPE;
            }
            case 3: 
            case 4: {
                return Type.INT_TYPE;
            }
        }
        return type2;
    }

    public static void genThrow(@NotNull InstructionAdapter v, @NotNull String exception, @Nullable String message2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(55);
        }
        if (exception == null) {
            AsmUtil.$$$reportNull$$$0(56);
        }
        v.anew(Type.getObjectType(exception));
        v.dup();
        if (message2 != null) {
            v.aconst(message2);
            v.invokespecial(exception, "<init>", "(Ljava/lang/String;)V", false);
        } else {
            v.invokespecial(exception, "<init>", "()V", false);
        }
        v.athrow();
    }

    public static void genClosureFields(@NotNull CalculatedClosure closure, ClassBuilder v, KotlinTypeMapper typeMapper, @NotNull LanguageVersionSettings languageVersionSettings) {
        KotlinType captureReceiverType;
        if (closure == null) {
            AsmUtil.$$$reportNull$$$0(57);
        }
        if (languageVersionSettings == null) {
            AsmUtil.$$$reportNull$$$0(58);
        }
        ArrayList<Pair<String, Type>> allFields = new ArrayList<Pair<String, Type>>();
        ClassDescriptor captureThis = closure.getCapturedOuterClassDescriptor();
        if (captureThis != null) {
            allFields.add(Pair.create(CAPTURED_THIS_FIELD, typeMapper.mapType(captureThis)));
        }
        if ((captureReceiverType = closure.getCapturedReceiverFromOuterContext()) != null && !CallableReferenceUtilKt.isForCallableReference(closure)) {
            String fieldName = closure.getCapturedReceiverFieldName(typeMapper.getBindingContext(), languageVersionSettings);
            allFields.add(Pair.create(fieldName, typeMapper.mapType(captureReceiverType)));
        }
        allFields.addAll(closure.getRecordedFields());
        AsmUtil.genClosureFields(allFields, v);
    }

    public static void genClosureFields(List<Pair<String, Type>> allFields, ClassBuilder builder) {
        int access = 4112;
        for (Pair<String, Type> field : allFields) {
            builder.newField(JvmDeclarationOrigin.NO_ORIGIN, access, (String)field.first, ((Type)field.second).getDescriptor(), null, null);
        }
    }

    public static int genAssignInstanceFieldFromParam(FieldInfo info2, int index2, InstructionAdapter iv) {
        return AsmUtil.genAssignInstanceFieldFromParam(info2, index2, iv, 0, false);
    }

    public static int genAssignInstanceFieldFromParam(FieldInfo info2, int index2, InstructionAdapter iv, int ownerIndex, boolean cast) {
        assert (!info2.isStatic());
        Type fieldType = info2.getFieldType();
        KotlinType fieldKotlinType = info2.getFieldKotlinType();
        SimpleType nullableAny = fieldKotlinType != null ? fieldKotlinType.getConstructor().getBuiltIns().getNullableAnyType() : null;
        iv.load(ownerIndex, info2.getOwnerType());
        if (cast) {
            iv.load(index2, AsmTypes.OBJECT_TYPE);
            StackValue.coerce(AsmTypes.OBJECT_TYPE, nullableAny, fieldType, fieldKotlinType, iv);
        } else {
            iv.load(index2, fieldType);
        }
        iv.visitFieldInsn(181, info2.getOwnerInternalName(), info2.getFieldName(), fieldType.getDescriptor());
        return index2 += fieldType.getSize();
    }

    public static void genStringBuilderConstructor(InstructionAdapter v) {
        v.visitTypeInsn(187, "java/lang/StringBuilder");
        v.dup();
        v.invokespecial("java/lang/StringBuilder", "<init>", "()V", false);
    }

    public static void genInvokeAppendMethod(@NotNull InstructionAdapter v, @NotNull Type type2, @Nullable KotlinType kotlinType) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(59);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(60);
        }
        AsmUtil.genInvokeAppendMethod(v, type2, kotlinType, null);
    }

    public static void genInvokeAppendMethod(@NotNull InstructionAdapter v, @NotNull Type type2, @Nullable KotlinType kotlinType, @Nullable KotlinTypeMapper typeMapper) {
        Type appendParameterType;
        CallableMethod specializedToString;
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(61);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(62);
        }
        if ((specializedToString = AsmUtil.getSpecializedToStringCallableMethodOrNull(kotlinType, typeMapper)) != null) {
            specializedToString.genInvokeInstruction(v);
            appendParameterType = AsmTypes.JAVA_STRING_TYPE;
        } else if (kotlinType != null && InlineClassesUtilsKt.isInlineClassType(kotlinType)) {
            appendParameterType = AsmTypes.OBJECT_TYPE;
            SimpleType nullableAnyType = kotlinType.getConstructor().getBuiltIns().getNullableAnyType();
            StackValue.coerce(type2, kotlinType, appendParameterType, nullableAnyType, v);
        } else {
            appendParameterType = AsmUtil.stringBuilderAppendType(type2);
        }
        v.invokevirtual("java/lang/StringBuilder", "append", "(" + appendParameterType.getDescriptor() + ")Ljava/lang/StringBuilder;", false);
    }

    public static StackValue genToString(@NotNull StackValue receiver, @NotNull Type receiverType, @Nullable KotlinType receiverKotlinType, @Nullable KotlinTypeMapper typeMapper) {
        if (receiver == null) {
            AsmUtil.$$$reportNull$$$0(63);
        }
        if (receiverType == null) {
            AsmUtil.$$$reportNull$$$0(64);
        }
        return StackValue.operation(AsmTypes.JAVA_STRING_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            SimpleType kotlinType;
            Type type2;
            CallableMethod specializedToString = AsmUtil.getSpecializedToStringCallableMethodOrNull(receiverKotlinType, typeMapper);
            if (specializedToString != null) {
                receiver.put(receiverType, receiverKotlinType, (InstructionAdapter)v);
                specializedToString.genInvokeInstruction((InstructionAdapter)v);
                return null;
            }
            if (receiverKotlinType != null && InlineClassesUtilsKt.isInlineClassType(receiverKotlinType)) {
                type2 = AsmTypes.OBJECT_TYPE;
                kotlinType = receiverKotlinType.getConstructor().getBuiltIns().getNullableAnyType();
            } else {
                type2 = AsmUtil.stringValueOfType(receiverType);
                kotlinType = null;
            }
            receiver.put(type2, kotlinType, (InstructionAdapter)v);
            v.invokestatic("java/lang/String", "valueOf", "(" + type2.getDescriptor() + ")Ljava/lang/String;", false);
            return null;
        }));
    }

    @Nullable
    private static CallableMethod getSpecializedToStringCallableMethodOrNull(@Nullable KotlinType receiverKotlinType, @Nullable KotlinTypeMapper typeMapper) {
        if (typeMapper == null) {
            return null;
        }
        if (receiverKotlinType == null) {
            return null;
        }
        if (!InlineClassesUtilsKt.isInlineClassType(receiverKotlinType)) {
            return null;
        }
        if (receiverKotlinType.isMarkedNullable()) {
            return null;
        }
        ClassifierDescriptor receiverTypeDescriptor = receiverKotlinType.getConstructor().getDeclarationDescriptor();
        assert (receiverTypeDescriptor instanceof ClassDescriptor && ((ClassDescriptor)receiverTypeDescriptor).isInline()) : "Inline class type expected: " + receiverKotlinType;
        ClassDescriptor receiverClassDescriptor = (ClassDescriptor)receiverTypeDescriptor;
        FunctionDescriptor toStringDescriptor = receiverClassDescriptor.getUnsubstitutedMemberScope().getContributedFunctions(Name.identifier("toString"), NoLookupLocation.FROM_BACKEND).stream().filter(f -> f.getValueParameters().size() == 0 && KotlinBuiltIns.isString(f.getReturnType()) && f.getDispatchReceiverParameter() != null && f.getExtensionReceiverParameter() == null).findFirst().orElseThrow(() -> new AssertionError((Object)("'toString' not found in member scope of " + receiverClassDescriptor)));
        return typeMapper.mapToCallableMethod(toStringDescriptor, false, OwnerKind.ERASED_INLINE_CLASS);
    }

    public static void genHashCode(MethodVisitor mv, InstructionAdapter iv, Type type2, JvmTarget jvmTarget) {
        if (type2.getSort() == 9) {
            Type elementType = AsmUtil.correctElementType(type2);
            if (elementType.getSort() == 10 || elementType.getSort() == 9) {
                iv.invokestatic("java/util/Arrays", "hashCode", "([Ljava/lang/Object;)I", false);
            } else {
                iv.invokestatic("java/util/Arrays", "hashCode", "(" + type2.getDescriptor() + ")I", false);
            }
        } else if (type2.getSort() == 10) {
            iv.invokevirtual("java/lang/Object", "hashCode", "()I", false);
        } else if (type2.getSort() == 1) {
            Label end = new Label();
            iv.dup();
            iv.ifeq(end);
            iv.pop();
            iv.iconst(1);
            iv.mark(end);
        } else if (JvmTarget.JVM_1_6 == jvmTarget) {
            if (type2.getSort() == 7) {
                AsmUtil.genLongHashCode(mv, iv);
            } else if (type2.getSort() == 8) {
                iv.invokestatic("java/lang/Double", "doubleToLongBits", "(D)J", false);
                AsmUtil.genLongHashCode(mv, iv);
            } else if (type2.getSort() == 6) {
                iv.invokestatic("java/lang/Float", "floatToIntBits", "(F)I", false);
            }
        } else {
            HashCode.Companion.invokeHashCode(iv, type2);
        }
    }

    private static void genLongHashCode(MethodVisitor mv, InstructionAdapter iv) {
        iv.dup2();
        iv.iconst(32);
        iv.ushr(Type.LONG_TYPE);
        iv.xor(Type.LONG_TYPE);
        mv.visitInsn(136);
    }

    public static void genInvertBoolean(InstructionAdapter v) {
        v.iconst(1);
        v.xor(Type.INT_TYPE);
    }

    @NotNull
    public static StackValue genEqualsForExpressionsOnStack(@NotNull IElementType opToken, @NotNull StackValue left, @NotNull StackValue right) {
        if (opToken == null) {
            AsmUtil.$$$reportNull$$$0(65);
        }
        if (left == null) {
            AsmUtil.$$$reportNull$$$0(66);
        }
        if (right == null) {
            AsmUtil.$$$reportNull$$$0(67);
        }
        Type leftType = left.type;
        Type rightType = right.type;
        if (AsmUtil.isPrimitive(leftType) && leftType == rightType) {
            StackValue stackValue = StackValue.cmp(opToken, leftType, left, right);
            if (stackValue == null) {
                AsmUtil.$$$reportNull$$$0(68);
            }
            return stackValue;
        }
        StackValue stackValue = StackValue.operation(Type.BOOLEAN_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            left.put(AsmTypes.OBJECT_TYPE, left.kotlinType, (InstructionAdapter)v);
            right.put(AsmTypes.OBJECT_TYPE, right.kotlinType, (InstructionAdapter)v);
            return AsmUtil.genAreEqualCall(v, opToken);
        }));
        if (stackValue == null) {
            AsmUtil.$$$reportNull$$$0(69);
        }
        return stackValue;
    }

    @NotNull
    public static BranchedValue genTotalOrderEqualsForExpressionOnStack(final @NotNull StackValue left, final @NotNull StackValue right, final @NotNull Type asmType) {
        if (left == null) {
            AsmUtil.$$$reportNull$$$0(70);
        }
        if (right == null) {
            AsmUtil.$$$reportNull$$$0(71);
        }
        if (asmType == null) {
            AsmUtil.$$$reportNull$$$0(72);
        }
        return new BranchedValue(left, right, asmType, 153){

            @Override
            public void condJump(@NotNull Label jumpLabel, @NotNull InstructionAdapter iv, boolean jumpIfFalse) {
                if (jumpLabel == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (iv == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (asmType.getSort() == 6) {
                    left.put(asmType, this.kotlinType, iv);
                    right.put(asmType, this.kotlinType, iv);
                    iv.invokestatic("java/lang/Float", "compare", "(FF)I", false);
                    iv.visitJumpInsn(this.patchOpcode(jumpIfFalse ? 154 : 153, iv), jumpLabel);
                } else if (asmType.getSort() == 8) {
                    left.put(asmType, this.kotlinType, iv);
                    right.put(asmType, this.kotlinType, iv);
                    iv.invokestatic("java/lang/Double", "compare", "(DD)I", false);
                    iv.visitJumpInsn(this.patchOpcode(jumpIfFalse ? 154 : 153, iv), jumpLabel);
                } else {
                    StackValue value2 = AsmUtil.genEqualsForExpressionsOnStack(KtTokens.EQEQ, left, right);
                    BranchedValue.Companion.condJump(value2, jumpLabel, jumpIfFalse, iv);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "jumpLabel";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "iv";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/AsmUtil$1";
                objectArray[2] = "condJump";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static StackValue genEqualsBoxedOnStack(@NotNull IElementType opToken) {
        if (opToken == null) {
            AsmUtil.$$$reportNull$$$0(73);
        }
        StackValue stackValue = StackValue.operation(Type.BOOLEAN_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> AsmUtil.genAreEqualCall(v, opToken)));
        if (stackValue == null) {
            AsmUtil.$$$reportNull$$$0(74);
        }
        return stackValue;
    }

    public static void genAreEqualCall(InstructionAdapter v) {
        v.invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
    }

    @NotNull
    private static Unit genAreEqualCall(InstructionAdapter v, @NotNull IElementType opToken) {
        if (opToken == null) {
            AsmUtil.$$$reportNull$$$0(75);
        }
        AsmUtil.genAreEqualCall(v);
        if (opToken == KtTokens.EXCLEQ || opToken == KtTokens.EXCLEQEQEQ) {
            AsmUtil.genInvertBoolean(v);
        }
        Unit unit = Unit.INSTANCE;
        if (unit == null) {
            AsmUtil.$$$reportNull$$$0(76);
        }
        return unit;
    }

    public static void genIEEE754EqualForNullableTypesCall(InstructionAdapter v, Type left, Type right) {
        v.invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", "(" + left.getDescriptor() + right.getDescriptor() + ")Z", false);
    }

    public static void numConst(int value2, Type type2, InstructionAdapter v) {
        if (type2 == Type.FLOAT_TYPE) {
            v.fconst(value2);
        } else if (type2 == Type.DOUBLE_TYPE) {
            v.dconst(value2);
        } else if (type2 == Type.LONG_TYPE) {
            v.lconst(value2);
        } else if (type2 == Type.CHAR_TYPE || type2 == Type.BYTE_TYPE || type2 == Type.SHORT_TYPE || type2 == Type.INT_TYPE) {
            v.iconst(value2);
        } else {
            throw new IllegalArgumentException("Primitive numeric type expected, got: " + type2);
        }
    }

    public static void genIncrement(Type baseType, int myDelta, InstructionAdapter v) {
        Type operationType = AsmUtil.numberFunctionOperandType(baseType);
        AsmUtil.numConst(myDelta, operationType, v);
        v.add(operationType);
        StackValue.coerce(operationType, baseType, v);
    }

    public static void swap(InstructionAdapter v, Type stackTop, Type afterTop) {
        if (stackTop.getSize() == 1) {
            if (afterTop.getSize() == 1) {
                v.swap();
            } else {
                v.dupX2();
                v.pop();
            }
        } else {
            if (afterTop.getSize() == 1) {
                v.dup2X1();
            } else {
                v.dup2X2();
            }
            v.pop2();
        }
    }

    static void genNotNullAssertionsForParameters(@NotNull InstructionAdapter v, @NotNull GenerationState state, @NotNull FunctionDescriptor descriptor2, @NotNull FrameMap frameMap) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(77);
        }
        if (state == null) {
            AsmUtil.$$$reportNull$$$0(78);
        }
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(79);
        }
        if (frameMap == null) {
            AsmUtil.$$$reportNull$$$0(80);
        }
        if (state.isParamAssertionsDisabled()) {
            return;
        }
        if (descriptor2.isSuspend()) {
            return;
        }
        if (AsmUtil.getVisibilityAccessFlag(descriptor2) == 2) {
            ReceiverParameterDescriptor receiverParameter;
            if (state.isReceiverAssertionsDisabled()) {
                return;
            }
            if (descriptor2.isOperator() && (receiverParameter = descriptor2.getExtensionReceiverParameter()) != null) {
                String name = AsmUtil.getNameForReceiverParameter(descriptor2, state.getBindingContext(), state.getLanguageVersionSettings());
                AsmUtil.genParamAssertion(v, state, frameMap, receiverParameter, name, descriptor2);
            }
            return;
        }
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            String name = AsmUtil.getNameForReceiverParameter(descriptor2, state.getBindingContext(), state.getLanguageVersionSettings());
            AsmUtil.genParamAssertion(v, state, frameMap, receiverParameter, name, descriptor2);
        }
        for (ValueParameterDescriptor parameter : descriptor2.getValueParameters()) {
            AsmUtil.genParamAssertion(v, state, frameMap, parameter, parameter.getName().asString(), descriptor2);
        }
    }

    private static void genParamAssertion(@NotNull InstructionAdapter v, @NotNull GenerationState state, @NotNull FrameMap frameMap, @NotNull ParameterDescriptor parameter, @NotNull String name, @NotNull FunctionDescriptor containingDeclaration) {
        KotlinType type2;
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(81);
        }
        if (state == null) {
            AsmUtil.$$$reportNull$$$0(82);
        }
        if (frameMap == null) {
            AsmUtil.$$$reportNull$$$0(83);
        }
        if (parameter == null) {
            AsmUtil.$$$reportNull$$$0(84);
        }
        if (name == null) {
            AsmUtil.$$$reportNull$$$0(85);
        }
        if (containingDeclaration == null) {
            AsmUtil.$$$reportNull$$$0(86);
        }
        if (TypeUtils.isNullableType(type2 = parameter.getType()) || InlineClassesUtilsKt.isNullableUnderlyingType(type2)) {
            return;
        }
        Type asmType = state.getTypeMapper().mapType(type2);
        if (asmType.getSort() == 10 || asmType.getSort() == 9) {
            StackValue value2;
            int index2;
            if (JvmCodegenUtil.isDeclarationOfBigArityFunctionInvoke(containingDeclaration) || JvmCodegenUtil.isDeclarationOfBigArityCreateCoroutineMethod(containingDeclaration)) {
                index2 = AsmUtil.getIndexOfParameterInVarargInvokeArray(parameter);
                value2 = StackValue.arrayElement(AsmTypes.OBJECT_TYPE, null, StackValue.local(1, AsmUtil.getArrayType(AsmTypes.OBJECT_TYPE)), StackValue.constant(index2));
            } else {
                index2 = frameMap.getIndex(parameter);
                value2 = StackValue.local(index2, asmType);
            }
            value2.put(asmType, v);
            v.visitLdcInsn(name);
            String methodName = state.getLanguageVersionSettings().getApiVersion().compareTo(ApiVersion.KOTLIN_1_4) >= 0 ? "checkNotNullParameter" : "checkParameterIsNotNull";
            v.invokestatic("kotlin/jvm/internal/Intrinsics", methodName, "(Ljava/lang/Object;Ljava/lang/String;)V", false);
        }
    }

    @NotNull
    public static StackValue genNotNullAssertions(final @NotNull GenerationState state, final @NotNull StackValue stackValue, final @Nullable RuntimeAssertionInfo runtimeAssertionInfo) {
        if (state == null) {
            AsmUtil.$$$reportNull$$$0(87);
        }
        if (stackValue == null) {
            AsmUtil.$$$reportNull$$$0(88);
        }
        if (state.isCallAssertionsDisabled()) {
            StackValue stackValue2 = stackValue;
            if (stackValue2 == null) {
                AsmUtil.$$$reportNull$$$0(89);
            }
            return stackValue2;
        }
        if (runtimeAssertionInfo == null || !runtimeAssertionInfo.getNeedNotNullAssertion()) {
            StackValue stackValue3 = stackValue;
            if (stackValue3 == null) {
                AsmUtil.$$$reportNull$$$0(90);
            }
            return stackValue3;
        }
        return new StackValue(stackValue.type, stackValue.kotlinType){

            @Override
            public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
                if (type2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (v == null) {
                    2.$$$reportNull$$$0(1);
                }
                Type innerType = stackValue.type;
                KotlinType innerKotlinType = stackValue.kotlinType;
                stackValue.put(innerType, innerKotlinType, v);
                if (innerType.getSort() == 10 || innerType.getSort() == 9) {
                    v.dup();
                    v.visitLdcInsn(runtimeAssertionInfo.getMessage());
                    String methodName = state.getLanguageVersionSettings().getApiVersion().compareTo(ApiVersion.KOTLIN_1_4) >= 0 ? "checkNotNullExpressionValue" : "checkExpressionValueIsNotNull";
                    v.invokestatic("kotlin/jvm/internal/Intrinsics", methodName, "(Ljava/lang/Object;Ljava/lang/String;)V", false);
                }
                StackValue.coerce(innerType, innerKotlinType, type2, kotlinType, v);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "v";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/AsmUtil$2";
                objectArray[2] = "putSelector";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static int getIndexOfParameterInVarargInvokeArray(@NotNull ParameterDescriptor parameter) {
        if (parameter == null) {
            AsmUtil.$$$reportNull$$$0(91);
        }
        if (parameter instanceof ReceiverParameterDescriptor) {
            return 0;
        }
        DeclarationDescriptor container = parameter.getContainingDeclaration();
        assert (parameter instanceof ValueParameterDescriptor) : "Non-extension-receiver parameter must be a value parameter: " + parameter;
        int extensionShift = ((CallableDescriptor)container).getExtensionReceiverParameter() == null ? 0 : 1;
        return extensionShift + ((ValueParameterDescriptor)parameter).getIndex();
    }

    public static void generateVarargInvokeArityAssert(InstructionAdapter v, int functionArity) {
        Label start = new Label();
        v.load(1, AsmUtil.getArrayType(AsmTypes.OBJECT_TYPE));
        v.arraylength();
        v.iconst(functionArity);
        v.ificmpeq(start);
        v.visitLdcInsn("Vararg argument must contain " + functionArity + " elements.");
        v.invokestatic("kotlin/jvm/internal/Intrinsics", "throwIllegalArgument", "(Ljava/lang/String;)V", false);
        v.visitLabel(start);
    }

    public static void pushDefaultValueOnStack(@NotNull Type type2, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(92);
        }
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(93);
        }
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            v.aconst(null);
        } else {
            AsmUtil.pushDefaultPrimitiveValueOnStack(type2, v);
        }
    }

    public static void pushDefaultPrimitiveValueOnStack(@NotNull Type type2, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(94);
        }
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(95);
        }
        if (type2.getSort() == 6) {
            v.fconst(0.0f);
        } else if (type2.getSort() == 8) {
            v.dconst(0.0);
        } else if (type2.getSort() == 7) {
            v.lconst(0L);
        } else {
            v.iconst(0);
        }
    }

    public static boolean isInstancePropertyWithStaticBackingField(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            AsmUtil.$$$reportNull$$$0(96);
        }
        return propertyDescriptor.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && DescriptorUtils.isObject(propertyDescriptor.getContainingDeclaration());
    }

    public static int getVisibilityForBackingField(@NotNull PropertyDescriptor propertyDescriptor, boolean isDelegate) {
        boolean isExtensionProperty;
        if (propertyDescriptor == null) {
            AsmUtil.$$$reportNull$$$0(97);
        }
        boolean bl = isExtensionProperty = propertyDescriptor.getExtensionReceiverParameter() != null;
        if (isDelegate || isExtensionProperty) {
            return 2;
        }
        return propertyDescriptor.isLateInit() || JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(propertyDescriptor) ? AsmUtil.getVisibilityAccessFlag(AsmUtil.descriptorForVisibility(propertyDescriptor)) : 2;
    }

    private static MemberDescriptor descriptorForVisibility(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            AsmUtil.$$$reportNull$$$0(98);
        }
        if (!propertyDescriptor.isVar()) {
            return propertyDescriptor;
        }
        return propertyDescriptor.getSetter() != null ? propertyDescriptor.getSetter() : propertyDescriptor;
    }

    public static boolean isPropertyWithBackingFieldCopyInOuterClass(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            AsmUtil.$$$reportNull$$$0(99);
        }
        DeclarationDescriptor propertyContainer = propertyDescriptor.getContainingDeclaration();
        return propertyDescriptor.isConst() && DescriptorUtils.isCompanionObject(propertyContainer) && JvmCodegenUtil.isJvmInterface(propertyContainer.getContainingDeclaration()) && AsmUtil.getVisibilityForBackingField(propertyDescriptor, false) == 1;
    }

    public static Type comparisonOperandType(Type left, Type right) {
        if (left == Type.DOUBLE_TYPE || right == Type.DOUBLE_TYPE) {
            return Type.DOUBLE_TYPE;
        }
        if (left == Type.FLOAT_TYPE || right == Type.FLOAT_TYPE) {
            return Type.FLOAT_TYPE;
        }
        if (left == Type.LONG_TYPE || right == Type.LONG_TYPE) {
            return Type.LONG_TYPE;
        }
        if (left == Type.CHAR_TYPE || right == Type.CHAR_TYPE) {
            return Type.CHAR_TYPE;
        }
        return Type.INT_TYPE;
    }

    @NotNull
    public static Type numberFunctionOperandType(@NotNull Type expectedType) {
        if (expectedType == null) {
            AsmUtil.$$$reportNull$$$0(100);
        }
        if (expectedType == Type.SHORT_TYPE || expectedType == Type.BYTE_TYPE || expectedType == Type.CHAR_TYPE) {
            Type type2 = Type.INT_TYPE;
            if (type2 == null) {
                AsmUtil.$$$reportNull$$$0(101);
            }
            return type2;
        }
        Type type3 = expectedType;
        if (type3 == null) {
            AsmUtil.$$$reportNull$$$0(102);
        }
        return type3;
    }

    public static void pop(@NotNull MethodVisitor v, @NotNull Type type2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(103);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(104);
        }
        if (type2.getSize() == 2) {
            v.visitInsn(88);
        } else {
            v.visitInsn(87);
        }
    }

    public static void pop2(@NotNull MethodVisitor v, @NotNull Type topOfStack, @NotNull Type afterTop) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(105);
        }
        if (topOfStack == null) {
            AsmUtil.$$$reportNull$$$0(106);
        }
        if (afterTop == null) {
            AsmUtil.$$$reportNull$$$0(107);
        }
        if (topOfStack.getSize() == 1 && afterTop.getSize() == 1) {
            v.visitInsn(88);
        } else {
            AsmUtil.pop(v, topOfStack);
            AsmUtil.pop(v, afterTop);
        }
    }

    public static void pop2(@NotNull MethodVisitor v, @NotNull Type type2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(108);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(109);
        }
        if (type2.getSize() == 2) {
            v.visitInsn(88);
            v.visitInsn(88);
        } else {
            v.visitInsn(88);
        }
    }

    public static void dup(@NotNull InstructionAdapter v, @NotNull Type type2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(110);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(111);
        }
        AsmUtil.dup(v, type2.getSize());
    }

    private static void dup(@NotNull InstructionAdapter v, int size) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(112);
        }
        if (size == 2) {
            v.dup2();
        } else if (size == 1) {
            v.dup();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void dupx(@NotNull InstructionAdapter v, @NotNull Type type2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(113);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(114);
        }
        AsmUtil.dupx(v, type2.getSize());
    }

    private static void dupx(@NotNull InstructionAdapter v, int size) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(115);
        }
        if (size == 2) {
            v.dup2X2();
        } else if (size == 1) {
            v.dupX1();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void dupSecond(@NotNull InstructionAdapter v, @NotNull Type topOfStack, @NotNull Type afterTop) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(116);
        }
        if (topOfStack == null) {
            AsmUtil.$$$reportNull$$$0(117);
        }
        if (afterTop == null) {
            AsmUtil.$$$reportNull$$$0(118);
        }
        if (afterTop.getSize() == 0) {
            return;
        }
        if (topOfStack.getSize() == 0) {
            AsmUtil.dup(v, afterTop);
        } else if (topOfStack.getSize() == 1 && afterTop.getSize() == 1) {
            v.dup2();
            v.pop();
        } else {
            AsmUtil.swap(v, topOfStack, afterTop);
            if (topOfStack.getSize() == 1 && afterTop.getSize() == 2) {
                v.dup2X1();
            } else if (topOfStack.getSize() == 2 && afterTop.getSize() == 1) {
                v.dupX2();
            } else {
                v.dup2X2();
            }
        }
    }

    public static void dup(@NotNull InstructionAdapter v, @NotNull Type topOfStack, @NotNull Type afterTop) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(119);
        }
        if (topOfStack == null) {
            AsmUtil.$$$reportNull$$$0(120);
        }
        if (afterTop == null) {
            AsmUtil.$$$reportNull$$$0(121);
        }
        if (topOfStack.getSize() == 0 && afterTop.getSize() == 0) {
            return;
        }
        if (topOfStack.getSize() == 0) {
            AsmUtil.dup(v, afterTop);
        } else if (afterTop.getSize() == 0) {
            AsmUtil.dup(v, topOfStack);
        } else if (afterTop.getSize() == 1) {
            if (topOfStack.getSize() == 1) {
                AsmUtil.dup(v, 2);
            } else {
                v.dup2X1();
                v.pop2();
                v.dupX2();
                v.dupX2();
                v.pop();
                v.dup2X1();
            }
        } else {
            throw new UnsupportedOperationException("Don't know how generate dup3/dup4 for: " + topOfStack + " and " + afterTop);
        }
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull DescriptorSerializer serializer2, @NotNull MessageLite message2) {
        if (av == null) {
            AsmUtil.$$$reportNull$$$0(122);
        }
        if (serializer2 == null) {
            AsmUtil.$$$reportNull$$$0(123);
        }
        if (message2 == null) {
            AsmUtil.$$$reportNull$$$0(124);
        }
        AsmUtil.writeAnnotationData(av, message2, (JvmStringTable)((Object)serializer2.getStringTable()));
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull MessageLite message2, @NotNull JvmStringTable stringTable) {
        if (av == null) {
            AsmUtil.$$$reportNull$$$0(125);
        }
        if (message2 == null) {
            AsmUtil.$$$reportNull$$$0(126);
        }
        if (stringTable == null) {
            AsmUtil.$$$reportNull$$$0(127);
        }
        AsmUtil.writeAnnotationData(av, JvmProtoBufUtil.writeData(message2, stringTable), ArrayUtil.toStringArray(stringTable.getStrings()));
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull String[] data, @NotNull String[] strings2) {
        if (av == null) {
            AsmUtil.$$$reportNull$$$0(128);
        }
        if (data == null) {
            AsmUtil.$$$reportNull$$$0(129);
        }
        if (strings2 == null) {
            AsmUtil.$$$reportNull$$$0(130);
        }
        AnnotationVisitor dataVisitor = av.visitArray("d1");
        for (String string2 : data) {
            dataVisitor.visit(null, string2);
        }
        dataVisitor.visitEnd();
        AnnotationVisitor stringsVisitor = av.visitArray("d2");
        for (String string3 : strings2) {
            stringsVisitor.visit(null, string3);
        }
        stringsVisitor.visitEnd();
    }

    @NotNull
    public static Type asmTypeByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            AsmUtil.$$$reportNull$$$0(131);
        }
        Type type2 = Type.getObjectType(AsmUtil.internalNameByFqNameWithoutInnerClasses(fqName2));
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(132);
        }
        return type2;
    }

    @NotNull
    public static Type asmTypeByClassId(@NotNull ClassId classId) {
        if (classId == null) {
            AsmUtil.$$$reportNull$$$0(133);
        }
        Type type2 = Type.getObjectType(classId.asString().replace('.', '$'));
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(134);
        }
        return type2;
    }

    @NotNull
    public static String internalNameByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            AsmUtil.$$$reportNull$$$0(135);
        }
        String string2 = JvmClassName.byFqNameWithoutInnerClasses(fqName2).getInternalName();
        if (string2 == null) {
            AsmUtil.$$$reportNull$$$0(136);
        }
        return string2;
    }

    public static void putJavaLangClassInstance(@NotNull InstructionAdapter v, @NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull KotlinTypeMapper typeMapper) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(137);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(138);
        }
        if (typeMapper == null) {
            AsmUtil.$$$reportNull$$$0(139);
        }
        if (kotlinType != null && InlineClassesUtilsKt.isInlineClassType(kotlinType)) {
            v.aconst(AsmUtil.boxType(type2, kotlinType, typeMapper));
        } else if (AsmUtil.isPrimitive(type2)) {
            v.getstatic(AsmUtil.boxType(type2).getInternalName(), "TYPE", "Ljava/lang/Class;");
        } else {
            v.aconst(type2);
        }
    }

    public static void wrapJavaClassIntoKClass(@NotNull InstructionAdapter v) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(140);
        }
        v.invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinClass", Type.getMethodDescriptor(AsmTypes.K_CLASS_TYPE, AsmTypes.getType(Class.class)), false);
    }

    public static void wrapJavaClassesIntoKClasses(@NotNull InstructionAdapter v) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(141);
        }
        v.invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinClasses", Type.getMethodDescriptor(AsmTypes.K_CLASS_ARRAY_TYPE, AsmTypes.getType(Class[].class)), false);
    }

    public static int getReceiverIndex(@NotNull CodegenContext context2, @NotNull CallableMemberDescriptor descriptor2) {
        OwnerKind kind;
        if (context2 == null) {
            AsmUtil.$$$reportNull$$$0(142);
        }
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(143);
        }
        return (kind = context2.getContextKind()) != OwnerKind.DEFAULT_IMPLS && AsmUtil.isStaticMethod(kind, descriptor2) ? 0 : 1;
    }

    static {
        ImmutableMap.Builder<Integer, JvmPrimitiveType> typeBySortBuilder = ImmutableMap.builder();
        ImmutableMap.Builder<Type, Type> typeByWrapperBuilder = ImmutableMap.builder();
        for (JvmPrimitiveType primitiveType : JvmPrimitiveType.values()) {
            Type asmType = Type.getType(primitiveType.getDesc());
            typeBySortBuilder.put(asmType.getSort(), primitiveType);
            typeByWrapperBuilder.put(AsmUtil.asmTypeByFqNameWithoutInnerClasses(primitiveType.getWrapperFqName()), asmType);
        }
        primitiveTypeByAsmSort = typeBySortBuilder.build();
        primitiveTypeByBoxedType = typeByWrapperBuilder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 33: 
            case 37: 
            case 39: 
            case 68: 
            case 69: 
            case 74: 
            case 76: 
            case 89: 
            case 90: 
            case 101: 
            case 102: 
            case 132: 
            case 134: 
            case 136: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 33: 
            case 37: 
            case 39: 
            case 68: 
            case 69: 
            case 74: 
            case 76: 
            case 89: 
            case 90: 
            case 101: 
            case 102: 
            case 132: 
            case 134: 
            case 136: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalName";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 33: 
            case 37: 
            case 39: 
            case 68: 
            case 69: 
            case 74: 
            case 76: 
            case 89: 
            case 90: 
            case 101: 
            case 102: 
            case 132: 
            case 134: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/AsmUtil";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 79: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableName";
                break;
            }
            case 20: 
            case 22: 
            case 27: 
            case 36: 
            case 60: 
            case 62: 
            case 92: 
            case 94: 
            case 104: 
            case 109: 
            case 111: 
            case 114: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinType";
                break;
            }
            case 24: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 28: 
            case 30: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedType";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedOrPrimitiveType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unboxedType";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 40: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 44: 
            case 78: 
            case 82: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecationResolver";
                break;
            }
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClass";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberDescriptor";
                break;
            }
            case 55: 
            case 59: 
            case 61: 
            case 77: 
            case 81: 
            case 93: 
            case 95: 
            case 103: 
            case 105: 
            case 108: 
            case 110: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 119: 
            case 137: 
            case 140: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = BOUND_REFERENCE_RECEIVER;
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverType";
                break;
            }
            case 65: 
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opToken";
                break;
            }
            case 66: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 67: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asmType";
                break;
            }
            case 80: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameMap";
                break;
            }
            case 84: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDeclaration";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackValue";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 106: 
            case 117: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topOfStack";
                break;
            }
            case 107: 
            case 118: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterTop";
                break;
            }
            case 122: 
            case 125: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "av";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 124: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringTable";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 131: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classId";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/AsmUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapturedFieldName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabeledThisNameForReceiver";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabeledThisName";
                break;
            }
            case 21: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "boxType";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "unboxType";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "unboxUnlessPrimitive";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "correctElementType";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayType";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "genEqualsForExpressionsOnStack";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "genEqualsBoxedOnStack";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "genAreEqualCall";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "genNotNullAssertions";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "numberFunctionOperandType";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "asmTypeByFqNameWithoutInnerClasses";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "asmTypeByClassId";
                break;
            }
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "internalNameByFqNameWithoutInnerClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCapturedFieldName";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 33: 
            case 37: 
            case 39: 
            case 68: 
            case 69: 
            case 74: 
            case 76: 
            case 89: 
            case 90: 
            case 101: 
            case 102: 
            case 132: 
            case 134: 
            case 136: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNameForCapturedReceiverField";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNameForReceiverParameter";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLabeledThisNameForReceiver";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLabeledThisName";
                break;
            }
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "boxType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "boxPrimitiveType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "unboxType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "unboxPrimitiveTypeOrNull";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isBoxedPrimitiveType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "unboxUnlessPrimitive";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isBoxedTypeOf";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "correctElementType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getArrayType";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "method";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isInlineClassWrapperConstructor";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getCommonCallableFlags";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityAccessFlag";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityAccessFlagForClass";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityAccessFlagForAnonymous";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getSyntheticAccessFlagForLambdaClass";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "calculateInnerClassAccessFlags";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "innerAccessFlagsForModalityAndKind";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecatedAccessFlag";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "specialCaseVisibility";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "genThrow";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "genClosureFields";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "genInvokeAppendMethod";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "genToString";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "genEqualsForExpressionsOnStack";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "genTotalOrderEqualsForExpressionOnStack";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "genEqualsBoxedOnStack";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "genAreEqualCall";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "genNotNullAssertionsForParameters";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "genParamAssertion";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "genNotNullAssertions";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getIndexOfParameterInVarargInvokeArray";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "pushDefaultValueOnStack";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "pushDefaultPrimitiveValueOnStack";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "isInstancePropertyWithStaticBackingField";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityForBackingField";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "descriptorForVisibility";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyWithBackingFieldCopyInOuterClass";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "numberFunctionOperandType";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "pop";
                break;
            }
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "pop2";
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "dup";
                break;
            }
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "dupx";
                break;
            }
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "dupSecond";
                break;
            }
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "writeAnnotationData";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "asmTypeByFqNameWithoutInnerClasses";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "asmTypeByClassId";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "internalNameByFqNameWithoutInnerClasses";
                break;
            }
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "putJavaLangClassInstance";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "wrapJavaClassIntoKClass";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "wrapJavaClassesIntoKClasses";
                break;
            }
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "getReceiverIndex";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 33: 
            case 37: 
            case 39: 
            case 68: 
            case 69: 
            case 74: 
            case 76: 
            case 89: 
            case 90: 
            case 101: 
            case 102: 
            case 132: 
            case 134: 
            case 136: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

