/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt$WhenMappings;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.RenderedDiagnostic;
import org.jetbrains.kotlin.diagnostics.TypeMismatchDueToTypeProjectionsData;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0086\b\u001a9\u0010\u000e\u001a\u00020\u0005\"\n\b\u0000\u0010\u000f\u0018\u0001*\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u00020\r0\u000bH\u0086\b\u001a-\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0086\b\u001a\u0012\u0010\u0012\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\u0013\u001a\u00020\r\u001a)\u0010\u0014\u001a\u00020\u0005\"\b\b\u0000\u0010\u0015*\u00020\r*\u00020\u00162\u0006\u0010\u0013\u001a\u0002H\u00152\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019\u001a(\u0010\u001a\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d\u001a(\u0010\u001f\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d\u00a8\u0006 "}, d2={"isScalaLikeEqualsBlock", "", "expression", "Lorg/jetbrains/kotlin/psi/KtElement;", "reportOnDeclaration", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "what", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "reportOnDeclarationAs", "T", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "reportOnDeclarationOrFail", "reportDiagnosticOnce", "diagnostic", "reportFromPlugin", "D", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "ext", "Lorg/jetbrains/kotlin/diagnostics/rendering/DefaultErrorMessages$Extension;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;Lorg/jetbrains/kotlin/diagnostics/Diagnostic;Lorg/jetbrains/kotlin/diagnostics/rendering/DefaultErrorMessages$Extension;)V", "reportTypeMismatchDueToScalaLikeNamedFunctionSyntax", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionType", "reportTypeMismatchDueToTypeProjection", "frontend"})
public final class DiagnosticUtilsKt {
    /*
     * WARNING - void declaration
     */
    public static final boolean reportTypeMismatchDueToTypeProjection(@NotNull ResolutionContext<?> $this$reportTypeMismatchDueToTypeProjection, @NotNull KtElement expression2, @NotNull KotlinType expectedType, @Nullable KotlinType expressionType) {
        void resolvedCall2;
        Pair pair;
        CallPosition callPosition;
        Intrinsics.checkParameterIsNotNull($this$reportTypeMismatchDueToTypeProjection, (String)"$this$reportTypeMismatchDueToTypeProjection");
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        if (!TypeUtils.contains(expectedType, (Function1<UnwrappedType, Boolean>)((Function1)reportTypeMismatchDueToTypeProjection.1.INSTANCE))) {
            return false;
        }
        CallPosition callPosition2 = $this$reportTypeMismatchDueToTypeProjection.callPosition;
        Intrinsics.checkExpressionValueIsNotNull((Object)callPosition2, (String)"this.callPosition");
        CallPosition callPosition3 = callPosition = callPosition2;
        if (callPosition3 instanceof CallPosition.ValueArgumentPosition) {
            pair = new Pair(((CallPosition.ValueArgumentPosition)callPosition).getResolvedCall(), (Object)new Function1<CallableDescriptor, KotlinType>($this$reportTypeMismatchDueToTypeProjection, callPosition){
                final /* synthetic */ ResolutionContext $this_reportTypeMismatchDueToTypeProjection;
                final /* synthetic */ CallPosition $callPosition;

                @Nullable
                public final KotlinType invoke(@NotNull CallableDescriptor f) {
                    Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
                    ValueParameterDescriptor valueParameterDescriptor = f.getValueParameters().get(((CallPosition.ValueArgumentPosition)this.$callPosition).getValueParameter().getIndex());
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"f.valueParameters[callPo\u2026ion.valueParameter.index]");
                    return CallResolverUtilKt.getEffectiveExpectedType(valueParameterDescriptor, ((CallPosition.ValueArgumentPosition)this.$callPosition).getValueArgument(), this.$this_reportTypeMismatchDueToTypeProjection);
                }
                {
                    this.$this_reportTypeMismatchDueToTypeProjection = resolutionContext;
                    this.$callPosition = callPosition;
                    super(1);
                }
            });
        } else if (callPosition3 instanceof CallPosition.ExtensionReceiverPosition) {
            pair = new Pair(((CallPosition.ExtensionReceiverPosition)callPosition).getResolvedCall(), (Object)reportTypeMismatchDueToTypeProjection.3.INSTANCE);
        } else if (callPosition3 instanceof CallPosition.PropertyAssignment) {
            KtElement ktElement = ((CallPosition.PropertyAssignment)callPosition).getLeftPart();
            BindingTrace bindingTrace = $this$reportTypeMismatchDueToTypeProjection.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"trace");
            BindingContext bindingContext = bindingTrace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            if (resolvedCall3 == null) {
                return false;
            }
            pair = new Pair(resolvedCall3, (Object)reportTypeMismatchDueToTypeProjection.4.INSTANCE);
        } else {
            if (callPosition3 instanceof CallPosition.Unknown) {
                return false;
            }
            throw new NoWhenBranchMatchedException();
        }
        Pair pair2 = pair;
        ResolvedCall resolvedCall4 = (ResolvedCall)pair2.component1();
        Function1 correspondingNotApproximatedTypeByDescriptor = (Function1)pair2.component2();
        KotlinType kotlinType2 = resolvedCall2.getSmartCastDispatchReceiverType();
        if (kotlinType2 == null) {
            ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
            if (receiverValue == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)receiverValue, (String)"(resolvedCall.dispatchReceiver ?: return false)");
            kotlinType2 = receiverValue.getType();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"resolvedCall.smartCastDi\u2026ver ?: return false).type");
        KotlinType receiverType = kotlinType2;
        Object d = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(d, (String)"resolvedCall.resultingDescriptor");
        CallableDescriptor callableDescriptor = d.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull((Object)callableDescriptor, (String)"resolvedCall.resultingDescriptor.original");
        CallableDescriptor callableDescriptor2 = callableDescriptor;
        TypeSubstitutor typeSubstitutor2 = CapturedTypeConstructorKt.wrapWithCapturingSubstitution(TypeConstructorSubstitution.Companion.create(receiverType), false).buildSubstitutor();
        boolean bl = false;
        boolean bl2 = false;
        TypeSubstitutor it = typeSubstitutor2;
        boolean bl3 = false;
        CallableDescriptor callableDescriptor3 = (CallableDescriptor)callableDescriptor2.substitute(it);
        if (callableDescriptor3 == null) {
            return false;
        }
        CallableDescriptor substitutedDescriptor = callableDescriptor3;
        KotlinType kotlinType3 = (KotlinType)correspondingNotApproximatedTypeByDescriptor.invoke((Object)substitutedDescriptor);
        if (kotlinType3 == null) {
            return false;
        }
        KotlinType nonApproximatedExpectedType = kotlinType3;
        if (!TypeUtils.contains(nonApproximatedExpectedType, (Function1<UnwrappedType, Boolean>)((Function1)reportTypeMismatchDueToTypeProjection.5.INSTANCE))) {
            return false;
        }
        if (TypeUtilsKt.isNothing(expectedType)) {
            if (callPosition instanceof CallPosition.PropertyAssignment) {
                KtExpression ktExpression = ((CallPosition.PropertyAssignment)callPosition).getLeftPart();
                if (ktExpression == null) {
                    return false;
                }
                $this$reportTypeMismatchDueToTypeProjection.trace.report(Errors.SETTER_PROJECTED_OUT.on((KtExpression)((PsiElement)ktExpression), (DeclarationDescriptor)resolvedCall2.getResultingDescriptor()));
            } else {
                KtExpression ktExpression;
                Call call2 = resolvedCall2.getCall();
                Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
                Call call3 = call2;
                if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                    Call call4 = ((VariableAsFunctionResolvedCall)resolvedCall2).getVariableCall().getCall();
                    Intrinsics.checkExpressionValueIsNotNull((Object)call4, (String)"resolvedCall.variableCall.call");
                    ktExpression = call4.getCalleeExpression();
                } else {
                    ktExpression = call3.getCalleeExpression();
                }
                KtExpression reportOn = ktExpression;
                BindingTrace bindingTrace = $this$reportTypeMismatchDueToTypeProjection.trace;
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"trace");
                KtExpression ktExpression2 = reportOn;
                ParametrizedDiagnostic<KtElement> parametrizedDiagnostic = Errors.MEMBER_PROJECTED_OUT.on((KtElement)((PsiElement)(ktExpression2 != null ? (KtElement)ktExpression2 : call3.getCallElement())), callableDescriptor2, receiverType);
                Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"Errors.MEMBER_PROJECTED_\u2026Descriptor, receiverType)");
                DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
            }
        } else {
            if (expressionType == null) {
                return false;
            }
            $this$reportTypeMismatchDueToTypeProjection.trace.report(Errors.TYPE_MISMATCH_DUE_TO_TYPE_PROJECTIONS.on((KtElement)((PsiElement)expression2), new TypeMismatchDueToTypeProjectionsData(expectedType, expressionType, receiverType, callableDescriptor2)));
        }
        return true;
    }

    public static final void reportDiagnosticOnce(@NotNull BindingTrace $this$reportDiagnosticOnce, @NotNull Diagnostic diagnostic) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)$this$reportDiagnosticOnce, (String)"$this$reportDiagnosticOnce");
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            BindingContext bindingContext = $this$reportDiagnosticOnce.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"bindingContext");
            Diagnostics diagnostics2 = bindingContext.getDiagnostics();
            PsiElement psiElement = diagnostic.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"diagnostic.psiElement");
            Iterable $this$any$iv = diagnostics2.forElement(psiElement);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getFactory(), diagnostic.getFactory())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        $this$reportDiagnosticOnce.report(diagnostic);
    }

    public static final boolean reportTypeMismatchDueToScalaLikeNamedFunctionSyntax(@NotNull ResolutionContext<?> $this$reportTypeMismatchDueToScalaLikeNamedFunctionSyntax, @NotNull KtElement expression2, @NotNull KotlinType expectedType, @Nullable KotlinType expressionType) {
        Intrinsics.checkParameterIsNotNull($this$reportTypeMismatchDueToScalaLikeNamedFunctionSyntax, (String)"$this$reportTypeMismatchDueToScalaLikeNamedFunctionSyntax");
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        if (expressionType == null) {
            return false;
        }
        if (FunctionTypesKt.isFunctionType(expressionType) && !FunctionTypesKt.isFunctionType(expectedType) && DiagnosticUtilsKt.isScalaLikeEqualsBlock(expression2)) {
            $this$reportTypeMismatchDueToScalaLikeNamedFunctionSyntax.trace.report(Errors.TYPE_MISMATCH_DUE_TO_EQUALS_LAMBDA_IN_FUN.on((KtElement)((PsiElement)expression2), expectedType));
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isScalaLikeEqualsBlock(KtElement expression2) {
        if (!(expression2 instanceof KtLambdaExpression)) return false;
        PsiElement psiElement = ((KtLambdaExpression)expression2).getParent();
        boolean bl = false;
        boolean bl2 = false;
        PsiElement it = psiElement;
        boolean bl3 = false;
        if (!(it instanceof KtNamedFunction)) return false;
        if (((KtNamedFunction)it).getEqualsToken() == null) return false;
        return true;
    }

    public static final void reportOnDeclaration(@NotNull BindingTrace trace, @NotNull DeclarationDescriptor descriptor2, @NotNull Function1<? super PsiElement, ? extends Diagnostic> what) {
        block0: {
            int $i$f$reportOnDeclaration = 0;
            Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull(what, (String)"what");
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
            if (psiElement == null) break block0;
            PsiElement psiElement2 = psiElement;
            boolean bl = false;
            boolean bl2 = false;
            PsiElement psiElement3 = psiElement2;
            boolean bl3 = false;
            trace.report((Diagnostic)what.invoke((Object)psiElement3));
        }
    }

    public static final void reportOnDeclarationOrFail(@NotNull BindingTrace trace, @NotNull DeclarationDescriptor descriptor2, @NotNull Function1<? super PsiElement, ? extends Diagnostic> what) {
        int $i$f$reportOnDeclarationOrFail = 0;
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull(what, (String)"what");
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (psiElement == null) {
            throw (Throwable)((Object)new AssertionError((Object)("No declaration for " + descriptor2)));
        }
        PsiElement psiElement2 = psiElement;
        boolean bl = false;
        boolean bl2 = false;
        PsiElement psiElement3 = psiElement2;
        boolean bl3 = false;
        trace.report((Diagnostic)what.invoke((Object)psiElement3));
    }

    public static final /* synthetic */ <T extends KtDeclaration> void reportOnDeclarationAs(@NotNull BindingTrace trace, @NotNull DeclarationDescriptor descriptor2, @NotNull Function1<? super T, ? extends Diagnostic> what) {
        KtDeclaration ktDeclaration;
        int $i$f$reportOnDeclarationAs = 0;
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull(what, (String)"what");
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (psiElement != null) {
            PsiElement psiElement2 = psiElement;
            boolean bl = false;
            boolean bl2 = false;
            PsiElement psiElement3 = psiElement2;
            boolean bl3 = false;
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            ktDeclaration = (KtDeclaration)psiElement3;
            if (ktDeclaration == null) {
                StringBuilder stringBuilder = new StringBuilder().append("Declaration for ").append(descriptor2).append(" is expected to be ");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(Reflection.getOrCreateKotlinClass(KtDeclaration.class).getSimpleName()).append(", actual declaration: ").append(psiElement3).toString()));
            }
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("No declaration for " + descriptor2)));
        }
        KtDeclaration ktDeclaration2 = ktDeclaration;
        boolean bl = false;
        boolean bl4 = false;
        KtDeclaration it = ktDeclaration2;
        boolean bl5 = false;
        trace.report((Diagnostic)what.invoke((Object)it));
    }

    public static final <D extends Diagnostic> void reportFromPlugin(@NotNull DiagnosticSink $this$reportFromPlugin, @NotNull D diagnostic, @NotNull DefaultErrorMessages.Extension ext) {
        Intrinsics.checkParameterIsNotNull((Object)$this$reportFromPlugin, (String)"$this$reportFromPlugin");
        Intrinsics.checkParameterIsNotNull(diagnostic, (String)"diagnostic");
        Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
        DiagnosticRenderer<?> diagnosticRenderer = ext.getMap().get(diagnostic.getFactory());
        if (!(diagnosticRenderer instanceof DiagnosticRenderer)) {
            diagnosticRenderer = null;
        }
        if (diagnosticRenderer == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Renderer not found for diagnostic ");
            DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory, (String)"diagnostic.factory");
            String string2 = stringBuilder.append(diagnosticFactory.getName()).toString();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        DiagnosticRenderer<?> renderer = diagnosticRenderer;
        RenderedDiagnostic<D> renderedDiagnostic = new RenderedDiagnostic<D>(diagnostic, renderer);
        switch (DiagnosticUtilsKt$WhenMappings.$EnumSwitchMapping$0[diagnostic.getSeverity().ordinal()]) {
            case 1: {
                $this$reportFromPlugin.report(Errors.PLUGIN_ERROR.on(diagnostic.getPsiElement(), renderedDiagnostic));
                break;
            }
            case 2: {
                $this$reportFromPlugin.report(Errors.PLUGIN_WARNING.on(diagnostic.getPsiElement(), renderedDiagnostic));
                break;
            }
            case 3: {
                $this$reportFromPlugin.report(Errors.PLUGIN_INFO.on(diagnostic.getPsiElement(), renderedDiagnostic));
            }
        }
    }
}

